/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.carrotsearch.hppc.cursors.ObjectCursor;
import org.elasticsearch.cluster.metadata.IndexGraveyard;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.gateway.LocalAllocateDangledIndices;
import org.elasticsearch.gateway.MetaStateService;
import org.elasticsearch.index.Index;

public class DanglingIndicesState
extends AbstractComponent {
    private final NodeEnvironment nodeEnv;
    private final MetaStateService metaStateService;
    private final LocalAllocateDangledIndices allocateDangledIndices;
    private final Map<Index, IndexMetaData> danglingIndices = ConcurrentCollections.newConcurrentMap();

    @Inject
    public DanglingIndicesState(Settings settings, NodeEnvironment nodeEnv, MetaStateService metaStateService, LocalAllocateDangledIndices allocateDangledIndices) {
        super(settings);
        this.nodeEnv = nodeEnv;
        this.metaStateService = metaStateService;
        this.allocateDangledIndices = allocateDangledIndices;
    }

    public void processDanglingIndices(MetaData metaData) {
        if (!this.nodeEnv.hasNodeFile()) {
            return;
        }
        this.cleanupAllocatedDangledIndices(metaData);
        this.findNewAndAddDanglingIndices(metaData);
        this.allocateDanglingIndices();
    }

    Map<Index, IndexMetaData> getDanglingIndices() {
        return Collections.unmodifiableMap(new HashMap<Index, IndexMetaData>(this.danglingIndices));
    }

    void cleanupAllocatedDangledIndices(MetaData metaData) {
        for (Index index : this.danglingIndices.keySet()) {
            IndexMetaData indexMetaData = metaData.index(index);
            if (indexMetaData == null || !indexMetaData.getIndex().getName().equals(index.getName())) continue;
            if (!indexMetaData.getIndex().getUUID().equals(index.getUUID())) {
                this.logger.warn("[{}] can not be imported as a dangling index, as there is already another index with the same name but a different uuid. local index will be ignored (but not deleted)", (Object)index);
            } else {
                this.logger.debug("[{}] no longer dangling (created), removing from dangling list", (Object)index);
            }
            this.danglingIndices.remove(index);
        }
    }

    void findNewAndAddDanglingIndices(MetaData metaData) {
        this.danglingIndices.putAll(this.findNewDanglingIndices(metaData));
    }

    Map<Index, IndexMetaData> findNewDanglingIndices(MetaData metaData) {
        HashSet<String> excludeIndexPathIds = new HashSet<String>(metaData.indices().size() + this.danglingIndices.size());
        for (ObjectCursor<IndexMetaData> objectCursor : metaData.indices().values()) {
            excludeIndexPathIds.add(((IndexMetaData)objectCursor.value).getIndex().getUUID());
        }
        excludeIndexPathIds.addAll(this.danglingIndices.keySet().stream().map(Index::getUUID).collect(Collectors.toList()));
        try {
            List<IndexMetaData> indexMetaDataList = this.metaStateService.loadIndicesStates(excludeIndexPathIds::contains);
            HashMap<Index, IndexMetaData> hashMap = new HashMap<Index, IndexMetaData>(indexMetaDataList.size());
            IndexGraveyard graveyard = metaData.indexGraveyard();
            for (IndexMetaData indexMetaData : indexMetaDataList) {
                if (metaData.hasIndex(indexMetaData.getIndex().getName())) {
                    this.logger.warn("[{}] can not be imported as a dangling index, as index with same name already exists in cluster metadata", (Object)indexMetaData.getIndex());
                    continue;
                }
                if (graveyard.containsIndex(indexMetaData.getIndex())) {
                    this.logger.warn("[{}] can not be imported as a dangling index, as an index with the same name and UUID exist in the index tombstones.  This situation is likely caused by copying over the data directory for an index that was previously deleted.", (Object)indexMetaData.getIndex());
                    continue;
                }
                this.logger.info("[{}] dangling index exists on local file system, but not in cluster metadata, auto import to cluster state", (Object)indexMetaData.getIndex());
                hashMap.put(indexMetaData.getIndex(), indexMetaData);
            }
            return hashMap;
        }
        catch (IOException e) {
            this.logger.warn("failed to list dangling indices", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private void allocateDanglingIndices() {
        if (this.danglingIndices.isEmpty()) {
            return;
        }
        try {
            this.allocateDangledIndices.allocateDangled(Collections.unmodifiableCollection(new ArrayList<IndexMetaData>(this.danglingIndices.values())), new LocalAllocateDangledIndices.Listener(){

                @Override
                public void onResponse(LocalAllocateDangledIndices.AllocateDangledResponse response) {
                    DanglingIndicesState.this.logger.trace("allocated dangled");
                }

                @Override
                public void onFailure(Throwable e) {
                    DanglingIndicesState.this.logger.info("failed to send allocated dangled", e);
                }
            });
        }
        catch (Exception e) {
            this.logger.warn("failed to send allocate dangled", (Throwable)e);
        }
    }
}

