/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.discovery.zen.PendingClusterStateStats;

public class PendingClusterStatesQueue {
    final ArrayList<ClusterStateContext> pendingStates = new ArrayList();
    final Logger logger;
    final int maxQueueSize;

    public PendingClusterStatesQueue(Logger logger, int maxQueueSize) {
        this.logger = logger;
        this.maxQueueSize = maxQueueSize;
    }

    public synchronized void addPending(ClusterState state) {
        this.pendingStates.add(new ClusterStateContext(state));
        if (this.pendingStates.size() > this.maxQueueSize) {
            ClusterStateContext context = this.pendingStates.remove(0);
            this.logger.warn("dropping pending state [{}]. more than [{}] pending states.", (Object)context, (Object)this.maxQueueSize);
            if (context.committed()) {
                context.listener.onNewClusterStateFailed(new ElasticsearchException("too many pending states ([{}] pending)", this.maxQueueSize));
            }
        }
    }

    public synchronized ClusterState markAsCommitted(String stateUUID, StateProcessedListener listener) {
        ClusterStateContext context = this.findState(stateUUID);
        if (context == null) {
            listener.onNewClusterStateFailed(new IllegalStateException("can't resolve cluster state with uuid [" + stateUUID + "] to commit"));
            return null;
        }
        if (context.committed()) {
            listener.onNewClusterStateFailed(new IllegalStateException("cluster state with uuid [" + stateUUID + "] is already committed"));
            return null;
        }
        context.markAsCommitted(listener);
        return context.state;
    }

    public synchronized void markAsFailed(ClusterState state, Exception reason) {
        ClusterStateContext failedContext = this.findState(state.stateUUID());
        if (failedContext == null) {
            throw new IllegalArgumentException("can't resolve failed cluster state with uuid [" + state.stateUUID() + "], version [" + state.version() + "]");
        }
        if (!failedContext.committed()) {
            throw new IllegalArgumentException("failed cluster state is not committed " + state);
        }
        ArrayList<ClusterStateContext> statesToRemove = new ArrayList<ClusterStateContext>();
        for (int index = 0; index < this.pendingStates.size(); ++index) {
            ClusterStateContext pendingContext = this.pendingStates.get(index);
            if (!pendingContext.committed()) continue;
            ClusterState pendingState = pendingContext.state;
            if (pendingContext.equals(failedContext)) {
                statesToRemove.add(pendingContext);
                pendingContext.listener.onNewClusterStateFailed(reason);
                continue;
            }
            if (!state.supersedes(pendingState)) continue;
            statesToRemove.add(pendingContext);
            this.logger.debug("failing committed state {} together with state {}", (Object)pendingContext, (Object)failedContext);
            pendingContext.listener.onNewClusterStateFailed(reason);
        }
        this.pendingStates.removeAll(statesToRemove);
        assert (this.findState(state.stateUUID()) == null) : "state was marked as processed but can still be found in pending list " + state;
    }

    public synchronized void markAsProcessed(ClusterState state) {
        if (this.findState(state.stateUUID()) == null) {
            throw new IllegalStateException("can't resolve processed cluster state with uuid [" + state.stateUUID() + "], version [" + state.version() + "]");
        }
        DiscoveryNode currentMaster = state.nodes().getMasterNode();
        assert (currentMaster != null) : "processed cluster state mast have a master. " + state;
        ArrayList<ClusterStateContext> contextsToRemove = new ArrayList<ClusterStateContext>();
        for (int index = 0; index < this.pendingStates.size(); ++index) {
            ClusterStateContext pendingContext = this.pendingStates.get(index);
            ClusterState pendingState = pendingContext.state;
            DiscoveryNode pendingMasterNode = pendingState.nodes().getMasterNode();
            if (!Objects.equals(currentMaster, pendingMasterNode)) {
                contextsToRemove.add(pendingContext);
                if (pendingContext.committed()) {
                    this.logger.warn("received a cluster state (uuid[{}]/v[{}]) from a different master than the current one, rejecting (received {}, current {})", (Object)pendingState.stateUUID(), (Object)pendingState.version(), (Object)pendingMasterNode, (Object)currentMaster);
                    pendingContext.listener.onNewClusterStateFailed(new IllegalStateException("cluster state from a different master than the current one, rejecting (received " + pendingMasterNode + ", current " + currentMaster + ")"));
                    continue;
                }
                this.logger.trace("removing non-committed state with uuid[{}]/v[{}] from [{}] - a state from [{}] was successfully processed", (Object)pendingState.stateUUID(), (Object)pendingState.version(), (Object)pendingMasterNode, (Object)currentMaster);
                continue;
            }
            if (pendingState.stateUUID().equals(state.stateUUID())) {
                assert (pendingContext.committed()) : "processed cluster state is not committed " + state;
                contextsToRemove.add(pendingContext);
                pendingContext.listener.onNewClusterStateProcessed();
                continue;
            }
            if (state.version() < pendingState.version()) continue;
            this.logger.trace("processing pending state uuid[{}]/v[{}] together with state uuid[{}]/v[{}]", (Object)pendingState.stateUUID(), (Object)pendingState.version(), (Object)state.stateUUID(), (Object)state.version());
            contextsToRemove.add(pendingContext);
            if (!pendingContext.committed()) continue;
            pendingContext.listener.onNewClusterStateProcessed();
        }
        this.pendingStates.removeAll(contextsToRemove);
        assert (this.findState(state.stateUUID()) == null) : "state was marked as processed but can still be found in pending list " + state;
    }

    ClusterStateContext findState(String stateUUID) {
        for (int i = 0; i < this.pendingStates.size(); ++i) {
            ClusterStateContext context = this.pendingStates.get(i);
            if (!context.stateUUID().equals(stateUUID)) continue;
            return context;
        }
        return null;
    }

    public synchronized void failAllStatesAndClear(Exception reason) {
        for (ClusterStateContext pendingState : this.pendingStates) {
            if (!pendingState.committed()) continue;
            pendingState.listener.onNewClusterStateFailed(reason);
        }
        this.pendingStates.clear();
    }

    public synchronized ClusterState getNextClusterStateToProcess() {
        ClusterStateContext potentialState;
        int index;
        if (this.pendingStates.isEmpty()) {
            return null;
        }
        ClusterStateContext stateToProcess = null;
        for (index = 0; index < this.pendingStates.size(); ++index) {
            potentialState = this.pendingStates.get(index);
            if (!potentialState.committed()) continue;
            stateToProcess = potentialState;
            break;
        }
        if (stateToProcess == null) {
            return null;
        }
        while (index < this.pendingStates.size()) {
            potentialState = this.pendingStates.get(index);
            if (potentialState.state.supersedes(stateToProcess.state) && potentialState.committed()) {
                stateToProcess = potentialState;
            }
            ++index;
        }
        assert (stateToProcess.committed()) : "should only return committed cluster state. found " + stateToProcess.state;
        return stateToProcess.state;
    }

    public synchronized ClusterState[] pendingClusterStates() {
        ArrayList<ClusterState> states = new ArrayList<ClusterState>();
        for (ClusterStateContext context : this.pendingStates) {
            states.add(context.state);
        }
        return states.toArray(new ClusterState[states.size()]);
    }

    public synchronized PendingClusterStateStats stats() {
        int committed = 0;
        for (ClusterStateContext clusterStatsContext : this.pendingStates) {
            if (!clusterStatsContext.committed()) continue;
            ++committed;
        }
        return new PendingClusterStateStats(this.pendingStates.size(), this.pendingStates.size() - committed, committed);
    }

    static class ClusterStateContext {
        final ClusterState state;
        StateProcessedListener listener;

        ClusterStateContext(ClusterState clusterState) {
            this.state = clusterState;
        }

        void markAsCommitted(StateProcessedListener listener) {
            if (this.listener != null) {
                throw new IllegalStateException(this.toString() + "is already committed");
            }
            this.listener = listener;
        }

        boolean committed() {
            return this.listener != null;
        }

        public String stateUUID() {
            return this.state.stateUUID();
        }

        public String toString() {
            return String.format(Locale.ROOT, "[uuid[%s], v[%d], m[%s]]", this.stateUUID(), this.state.version(), this.state.nodes().getMasterNodeId());
        }
    }

    static interface StateProcessedListener {
        public void onNewClusterStateProcessed();

        public void onNewClusterStateFailed(Exception var1);
    }
}

