/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery;

import java.util.Set;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.logging.log4j.Logger;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.discovery.BlockingClusterStatePublishResponseHandler;
import org.elasticsearch.discovery.Discovery;

public class AckClusterStatePublishResponseHandler
extends BlockingClusterStatePublishResponseHandler {
    private static final Logger logger = ESLoggerFactory.getLogger(AckClusterStatePublishResponseHandler.class.getName());
    private final Discovery.AckListener ackListener;

    public AckClusterStatePublishResponseHandler(Set<DiscoveryNode> publishingToNodes, Discovery.AckListener ackListener) {
        super(publishingToNodes);
        this.ackListener = ackListener;
    }

    @Override
    public void onResponse(DiscoveryNode node) {
        super.onResponse(node);
        this.onNodeAck(this.ackListener, node, null);
    }

    @Override
    public void onFailure(DiscoveryNode node, Exception e) {
        try {
            super.onFailure(node, e);
        }
        finally {
            this.onNodeAck(this.ackListener, node, e);
        }
    }

    private void onNodeAck(Discovery.AckListener ackListener, DiscoveryNode node, Exception e) {
        try {
            ackListener.onNodeAck(node, e);
        }
        catch (Exception inner) {
            inner.addSuppressed(e);
            logger.debug(() -> new ParameterizedMessage("error while processing ack for node [{}]", (Object)node), (Throwable)inner);
        }
    }
}

