/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.ThreadInterruptedException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;

public class CancellableThreads {
    private final Set<Thread> threads = new HashSet<Thread>();
    private volatile boolean cancelled = false;
    private String reason;

    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public synchronized void checkForCancel() {
        if (this.isCancelled()) {
            this.onCancel(this.reason, null);
        }
    }

    protected void onCancel(String reason, @Nullable Exception suppressedException) {
        ExecutionCancelledException e = new ExecutionCancelledException("operation was cancelled reason [" + reason + "]");
        if (suppressedException != null) {
            e.addSuppressed(suppressedException);
        }
        throw e;
    }

    private synchronized boolean add() {
        this.checkForCancel();
        this.threads.add(Thread.currentThread());
        return Thread.interrupted();
    }

    public void execute(Interruptable interruptable) {
        try {
            this.executeIO(interruptable);
        }
        catch (IOException e) {
            assert (false) : "the passed interruptable can not result in an IOException";
            throw new RuntimeException("unexpected IO exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeIO(IOInterruptable interruptable) throws IOException {
        boolean wasInterrupted = this.add();
        boolean cancelledByExternalInterrupt = false;
        RuntimeException runtimeException = null;
        IOException ioException = null;
        try {
            interruptable.run();
        }
        catch (InterruptedException | ThreadInterruptedException e) {
            assert (this.cancelled) : "Interruption via Thread#interrupt() is unsupported. Use CancellableThreads#cancel() instead";
            cancelledByExternalInterrupt = !this.cancelled;
        }
        catch (RuntimeException t) {
            runtimeException = t;
        }
        catch (IOException e) {
            ioException = e;
        }
        finally {
            this.remove();
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        } else {
            Thread.interrupted();
        }
        CancellableThreads cancellableThreads = this;
        synchronized (cancellableThreads) {
            if (this.isCancelled()) {
                this.onCancel(this.reason, ioException != null ? ioException : runtimeException);
            } else if (ioException != null) {
                throw ioException;
            }
            if (runtimeException != null) {
                throw runtimeException;
            }
        }
        if (cancelledByExternalInterrupt) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interruption via Thread#interrupt() is unsupported. Use CancellableThreads#cancel() instead");
        }
    }

    private synchronized void remove() {
        this.threads.remove(Thread.currentThread());
    }

    public synchronized void cancel(String reason) {
        if (this.cancelled) {
            return;
        }
        this.cancelled = true;
        this.reason = reason;
        for (Thread thread : this.threads) {
            thread.interrupt();
        }
        this.threads.clear();
    }

    public static class ExecutionCancelledException
    extends ElasticsearchException {
        public ExecutionCancelledException(String msg) {
            super(msg, new Object[0]);
        }

        public ExecutionCancelledException(StreamInput in) throws IOException {
            super(in);
        }
    }

    public static interface IOInterruptable {
        public void run() throws IOException, InterruptedException;
    }

    public static interface Interruptable
    extends IOInterruptable {
        @Override
        public void run() throws InterruptedException;
    }
}

