/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.logging.log4j.Logger;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.codecs.CodecUtil;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.codecs.DocValuesFormat;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.codecs.PostingsFormat;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.document.LatLonDocValuesField;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.DirectoryReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexCommit;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexFileNames;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexWriter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexWriterConfig;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.NoMergePolicy;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SegmentCommitInfo;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SegmentInfos;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Collector;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Explanation;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.FieldDoc;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.LeafCollector;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.ScoreDoc;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.SimpleCollector;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.SortField;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.TimeLimitingCollector;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.TopDocs;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.TopFieldDocs;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.TwoPhaseIterator;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Weight;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.Directory;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.IOContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.IndexInput;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.Lock;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Bits;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Counter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Version;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.iterable.Iterables;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.IndexFieldData;

public class Lucene {
    public static final String LATEST_DOC_VALUES_FORMAT = "Lucene54";
    public static final String LATEST_POSTINGS_FORMAT = "Lucene50";
    public static final String LATEST_CODEC = "Lucene62";
    public static final NamedAnalyzer STANDARD_ANALYZER;
    public static final NamedAnalyzer KEYWORD_ANALYZER;
    public static final ScoreDoc[] EMPTY_SCORE_DOCS;
    public static final TopDocs EMPTY_TOP_DOCS;
    private static final Class<?> GEO_DISTANCE_SORT_TYPE_CLASS;

    public static Version parseVersion(@Nullable String version, Version defaultVersion, Logger logger) {
        if (version == null) {
            return defaultVersion;
        }
        try {
            return Version.parse(version);
        }
        catch (ParseException e) {
            logger.warn(() -> new ParameterizedMessage("no version match {}, default to {}", (Object)version, (Object)defaultVersion), (Throwable)e);
            return defaultVersion;
        }
    }

    public static SegmentInfos readSegmentInfos(Directory directory) throws IOException {
        return SegmentInfos.readLatestCommit(directory);
    }

    public static Iterable<String> files(SegmentInfos infos) throws IOException {
        ArrayList<Collection<String>> list = new ArrayList<Collection<String>>();
        list.add(Collections.singleton(infos.getSegmentsFileName()));
        for (SegmentCommitInfo info : infos) {
            list.add(info.files());
        }
        return Iterables.flatten(list);
    }

    public static int getNumDocs(SegmentInfos info) {
        int numDocs = 0;
        for (SegmentCommitInfo si : info) {
            numDocs += si.info.maxDoc() - si.getDelCount();
        }
        return numDocs;
    }

    public static SegmentInfos readSegmentInfos(IndexCommit commit) throws IOException {
        String filename = IndexFileNames.fileNameFromGeneration("segments", "", commit.getGeneration());
        return SegmentInfos.readCommit(commit.getDirectory(), filename);
    }

    private static SegmentInfos readSegmentInfos(String segmentsFileName, Directory directory) throws IOException {
        return SegmentInfos.readCommit(directory, segmentsFileName);
    }

    public static SegmentInfos pruneUnreferencedFiles(String segmentsFileName, Directory directory) throws IOException {
        SegmentInfos si = Lucene.readSegmentInfos(segmentsFileName, directory);
        try (Lock writeLock = directory.obtainLock("write.lock");){
            int foundSegmentFiles = 0;
            for (String file : directory.listAll()) {
                if (!file.startsWith("segments") && !file.equals("segments.gen")) continue;
                ++foundSegmentFiles;
                if (file.equals(si.getSegmentsFileName())) continue;
                directory.deleteFile(file);
            }
            assert (SegmentInfos.getLastCommitSegmentsFileName(directory).equals(segmentsFileName));
            if (foundSegmentFiles == 0) {
                throw new IllegalStateException("no commit found in the directory");
            }
        }
        CommitPoint cp = new CommitPoint(si, directory);
        IndexWriter writer = new IndexWriter(directory, new IndexWriterConfig(STANDARD_ANALYZER).setIndexCommit(cp).setCommitOnClose(false).setMergePolicy(NoMergePolicy.INSTANCE).setOpenMode(IndexWriterConfig.OpenMode.APPEND));
        Throwable throwable = null;
        if (writer != null) {
            if (throwable != null) {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                writer.close();
            }
        }
        return si;
    }

    public static void cleanLuceneIndex(Directory directory) throws IOException {
        try (Lock writeLock = directory.obtainLock("write.lock");){
            for (String file : directory.listAll()) {
                if (!file.startsWith("segments") && !file.equals("segments.gen")) continue;
                directory.deleteFile(file);
            }
        }
        IndexWriter writer = new IndexWriter(directory, new IndexWriterConfig(STANDARD_ANALYZER).setMergePolicy(NoMergePolicy.INSTANCE).setCommitOnClose(false).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
        var2_2 = null;
        if (writer != null) {
            if (var2_2 != null) {
                try {
                    writer.close();
                }
                catch (Throwable throwable) {
                    var2_2.addSuppressed(throwable);
                }
            } else {
                writer.close();
            }
        }
    }

    public static void checkSegmentInfoIntegrity(final Directory directory) throws IOException {
        new SegmentInfos.FindSegmentsFile(directory){

            protected Object doBody(String segmentFileName) throws IOException {
                try (IndexInput input = directory.openInput(segmentFileName, IOContext.READ);){
                    CodecUtil.checksumEntireFile(input);
                }
                return null;
            }
        }.run();
    }

    public static final EarlyTerminatingCollector wrapCountBasedEarlyTerminatingCollector(Collector delegate, int maxCountHits) {
        return new EarlyTerminatingCollector(delegate, maxCountHits);
    }

    public static final TimeLimitingCollector wrapTimeLimitingCollector(Collector delegate, Counter counter, long timeoutInMillis) {
        return new TimeLimitingCollector(delegate, counter, timeoutInMillis);
    }

    public static boolean exists(IndexSearcher searcher, Query query) throws IOException {
        Weight weight = searcher.createNormalizedWeight(query, false);
        for (LeafReaderContext context : searcher.getIndexReader().leaves()) {
            Scorer scorer = weight.scorer(context);
            if (scorer == null) continue;
            Bits liveDocs = context.reader().getLiveDocs();
            DocIdSetIterator iterator = scorer.iterator();
            int doc = iterator.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                if (liveDocs == null || liveDocs.get(doc)) {
                    return true;
                }
                doc = iterator.nextDoc();
            }
        }
        return false;
    }

    public static TopDocs readTopDocs(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            int totalHits = in.readVInt();
            float maxScore = in.readFloat();
            SortField[] fields = new SortField[in.readVInt()];
            for (int i = 0; i < fields.length; ++i) {
                String field = null;
                if (in.readBoolean()) {
                    field = in.readString();
                }
                SortField.Type sortType = Lucene.readSortType(in);
                Object missingValue = Lucene.readMissingValue(in);
                boolean reverse = in.readBoolean();
                fields[i] = new SortField(field, sortType, reverse);
                if (missingValue == null) continue;
                fields[i].setMissingValue(missingValue);
            }
            ScoreDoc[] fieldDocs = new FieldDoc[in.readVInt()];
            for (int i = 0; i < fieldDocs.length; ++i) {
                fieldDocs[i] = Lucene.readFieldDoc(in);
            }
            return new TopFieldDocs(totalHits, fieldDocs, fields, maxScore);
        }
        int totalHits = in.readVInt();
        float maxScore = in.readFloat();
        ScoreDoc[] scoreDocs = new ScoreDoc[in.readVInt()];
        for (int i = 0; i < scoreDocs.length; ++i) {
            scoreDocs[i] = new ScoreDoc(in.readVInt(), in.readFloat());
        }
        return new TopDocs(totalHits, scoreDocs, maxScore);
    }

    public static FieldDoc readFieldDoc(StreamInput in) throws IOException {
        Object[] cFields = new Comparable[in.readVInt()];
        for (int j = 0; j < cFields.length; ++j) {
            byte type = in.readByte();
            if (type == 0) {
                cFields[j] = null;
                continue;
            }
            if (type == 1) {
                cFields[j] = in.readString();
                continue;
            }
            if (type == 2) {
                cFields[j] = in.readInt();
                continue;
            }
            if (type == 3) {
                cFields[j] = in.readLong();
                continue;
            }
            if (type == 4) {
                cFields[j] = Float.valueOf(in.readFloat());
                continue;
            }
            if (type == 5) {
                cFields[j] = in.readDouble();
                continue;
            }
            if (type == 6) {
                cFields[j] = in.readByte();
                continue;
            }
            if (type == 7) {
                cFields[j] = in.readShort();
                continue;
            }
            if (type == 8) {
                cFields[j] = in.readBoolean();
                continue;
            }
            if (type == 9) {
                cFields[j] = in.readBytesRef();
                continue;
            }
            throw new IOException("Can't match type [" + type + "]");
        }
        return new FieldDoc(in.readVInt(), in.readFloat(), cFields);
    }

    public static ScoreDoc readScoreDoc(StreamInput in) throws IOException {
        return new ScoreDoc(in.readVInt(), in.readFloat());
    }

    public static void writeTopDocs(StreamOutput out, TopDocs topDocs) throws IOException {
        if (topDocs instanceof TopFieldDocs) {
            out.writeBoolean(true);
            TopFieldDocs topFieldDocs = (TopFieldDocs)topDocs;
            out.writeVInt(topDocs.totalHits);
            out.writeFloat(topDocs.getMaxScore());
            out.writeVInt(topFieldDocs.fields.length);
            for (SortField sortField : topFieldDocs.fields) {
                if (sortField.getClass() == GEO_DISTANCE_SORT_TYPE_CLASS) {
                    SortField newSortField = new SortField(sortField.getField(), SortField.Type.DOUBLE);
                    newSortField.setMissingValue(sortField.getMissingValue());
                    sortField = newSortField;
                }
                if (sortField.getClass() != SortField.class) {
                    throw new IllegalArgumentException("Cannot serialize SortField impl [" + sortField + "]");
                }
                if (sortField.getField() == null) {
                    out.writeBoolean(false);
                } else {
                    out.writeBoolean(true);
                    out.writeString(sortField.getField());
                }
                if (sortField.getComparatorSource() != null) {
                    IndexFieldData.XFieldComparatorSource comparatorSource = (IndexFieldData.XFieldComparatorSource)sortField.getComparatorSource();
                    Lucene.writeSortType(out, comparatorSource.reducedType());
                    Lucene.writeMissingValue(out, comparatorSource.missingValue(sortField.getReverse()));
                } else {
                    Lucene.writeSortType(out, sortField.getType());
                    Lucene.writeMissingValue(out, sortField.getMissingValue());
                }
                out.writeBoolean(sortField.getReverse());
            }
            out.writeVInt(topDocs.scoreDocs.length);
            for (ScoreDoc doc : topFieldDocs.scoreDocs) {
                Lucene.writeFieldDoc(out, (FieldDoc)doc);
            }
        } else {
            out.writeBoolean(false);
            out.writeVInt(topDocs.totalHits);
            out.writeFloat(topDocs.getMaxScore());
            out.writeVInt(topDocs.scoreDocs.length);
            for (ScoreDoc doc : topDocs.scoreDocs) {
                Lucene.writeScoreDoc(out, doc);
            }
        }
    }

    private static void writeMissingValue(StreamOutput out, Object missingValue) throws IOException {
        if (missingValue == SortField.STRING_FIRST) {
            out.writeByte((byte)1);
        } else if (missingValue == SortField.STRING_LAST) {
            out.writeByte((byte)2);
        } else {
            out.writeByte((byte)0);
            out.writeGenericValue(missingValue);
        }
    }

    private static Object readMissingValue(StreamInput in) throws IOException {
        byte id = in.readByte();
        switch (id) {
            case 0: {
                return in.readGenericValue();
            }
            case 1: {
                return SortField.STRING_FIRST;
            }
            case 2: {
                return SortField.STRING_LAST;
            }
        }
        throw new IOException("Unknown missing value id: " + id);
    }

    public static void writeFieldDoc(StreamOutput out, FieldDoc fieldDoc) throws IOException {
        out.writeVInt(fieldDoc.fields.length);
        for (Object field : fieldDoc.fields) {
            if (field == null) {
                out.writeByte((byte)0);
                continue;
            }
            Class<?> type = field.getClass();
            if (type == String.class) {
                out.writeByte((byte)1);
                out.writeString((String)field);
                continue;
            }
            if (type == Integer.class) {
                out.writeByte((byte)2);
                out.writeInt((Integer)field);
                continue;
            }
            if (type == Long.class) {
                out.writeByte((byte)3);
                out.writeLong((Long)field);
                continue;
            }
            if (type == Float.class) {
                out.writeByte((byte)4);
                out.writeFloat(((Float)field).floatValue());
                continue;
            }
            if (type == Double.class) {
                out.writeByte((byte)5);
                out.writeDouble((Double)field);
                continue;
            }
            if (type == Byte.class) {
                out.writeByte((byte)6);
                out.writeByte((Byte)field);
                continue;
            }
            if (type == Short.class) {
                out.writeByte((byte)7);
                out.writeShort((Short)field);
                continue;
            }
            if (type == Boolean.class) {
                out.writeByte((byte)8);
                out.writeBoolean((Boolean)field);
                continue;
            }
            if (type == BytesRef.class) {
                out.writeByte((byte)9);
                out.writeBytesRef((BytesRef)field);
                continue;
            }
            throw new IOException("Can't handle sort field value of type [" + type + "]");
        }
        out.writeVInt(fieldDoc.doc);
        out.writeFloat(fieldDoc.score);
    }

    public static void writeScoreDoc(StreamOutput out, ScoreDoc scoreDoc) throws IOException {
        if (!scoreDoc.getClass().equals(ScoreDoc.class)) {
            throw new IllegalArgumentException("This method can only be used to serialize a ScoreDoc, not a " + scoreDoc.getClass());
        }
        out.writeVInt(scoreDoc.doc);
        out.writeFloat(scoreDoc.score);
    }

    public static SortField.Type readSortType(StreamInput in) throws IOException {
        return SortField.Type.values()[in.readVInt()];
    }

    public static void writeSortType(StreamOutput out, SortField.Type sortType) throws IOException {
        out.writeVInt(sortType.ordinal());
    }

    public static Explanation readExplanation(StreamInput in) throws IOException {
        boolean match = in.readBoolean();
        String description = in.readString();
        Explanation[] subExplanations = new Explanation[in.readVInt()];
        for (int i = 0; i < subExplanations.length; ++i) {
            subExplanations[i] = Lucene.readExplanation(in);
        }
        if (match) {
            return Explanation.match(in.readFloat(), description, subExplanations);
        }
        return Explanation.noMatch(description, subExplanations);
    }

    public static void writeExplanation(StreamOutput out, Explanation explanation) throws IOException {
        out.writeBoolean(explanation.isMatch());
        out.writeString(explanation.getDescription());
        Explanation[] subExplanations = explanation.getDetails();
        out.writeVInt(subExplanations.length);
        for (Explanation subExp : subExplanations) {
            Lucene.writeExplanation(out, subExp);
        }
        if (explanation.isMatch()) {
            out.writeFloat(explanation.getValue());
        }
    }

    private Lucene() {
    }

    public static final boolean indexExists(Directory directory) throws IOException {
        return DirectoryReader.indexExists(directory);
    }

    public static final boolean waitForIndex(Directory directory, long timeLimitMillis) throws IOException {
        long DELAY = 1000L;
        try {
            for (long waited = 0L; waited < timeLimitMillis; waited += 1000L) {
                if (Lucene.indexExists(directory)) {
                    return true;
                }
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        return Lucene.indexExists(directory);
    }

    public static boolean isCorruptionException(Throwable t) {
        return ExceptionsHelper.unwrapCorruption(t) != null;
    }

    public static Version parseVersionLenient(String toParse, Version defaultValue) {
        return LenientParser.parse(toParse, defaultValue);
    }

    public static Scorer illegalScorer(final String message) {
        return new Scorer(null){

            @Override
            public float score() throws IOException {
                throw new IllegalStateException(message);
            }

            @Override
            public int freq() throws IOException {
                throw new IllegalStateException(message);
            }

            @Override
            public int docID() {
                throw new IllegalStateException(message);
            }

            @Override
            public DocIdSetIterator iterator() {
                throw new IllegalStateException(message);
            }
        };
    }

    public static Bits asSequentialAccessBits(final int maxDoc, @Nullable Scorer scorer) throws IOException {
        if (scorer == null) {
            return new Bits.MatchNoBits(maxDoc);
        }
        final TwoPhaseIterator twoPhase = scorer.twoPhaseIterator();
        final DocIdSetIterator iterator = twoPhase == null ? scorer.iterator() : twoPhase.approximation();
        return new Bits(){
            int previous = -1;
            boolean previousMatched = false;

            @Override
            public boolean get(int index) {
                if (index < 0 || index >= maxDoc) {
                    throw new IndexOutOfBoundsException(index + " is out of bounds: [" + 0 + "-" + maxDoc + "[");
                }
                if (index < this.previous) {
                    throw new IllegalArgumentException("This Bits instance can only be consumed in order. Got called on [" + index + "] while previously called on [" + this.previous + "]");
                }
                if (index == this.previous) {
                    return this.previousMatched;
                }
                this.previous = index;
                int doc = iterator.docID();
                if (doc < index) {
                    try {
                        doc = iterator.advance(index);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Cannot advance iterator", e);
                    }
                }
                if (index == doc) {
                    try {
                        this.previousMatched = twoPhase == null || twoPhase.matches();
                        return this.previousMatched;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Cannot validate match", e);
                    }
                }
                this.previousMatched = false;
                return false;
            }

            @Override
            public int length() {
                return maxDoc;
            }
        };
    }

    static {
        Deprecated annotation = PostingsFormat.forName(LATEST_POSTINGS_FORMAT).getClass().getAnnotation(Deprecated.class);
        assert (annotation == null) : "PostingsFromat Lucene50 is deprecated";
        annotation = DocValuesFormat.forName(LATEST_DOC_VALUES_FORMAT).getClass().getAnnotation(Deprecated.class);
        assert (annotation == null) : "DocValuesFormat Lucene54 is deprecated";
        STANDARD_ANALYZER = new NamedAnalyzer("_standard", AnalyzerScope.GLOBAL, new StandardAnalyzer());
        KEYWORD_ANALYZER = new NamedAnalyzer("_keyword", AnalyzerScope.GLOBAL, new KeywordAnalyzer());
        EMPTY_SCORE_DOCS = new ScoreDoc[0];
        EMPTY_TOP_DOCS = new TopDocs(0, EMPTY_SCORE_DOCS, 0.0f);
        GEO_DISTANCE_SORT_TYPE_CLASS = LatLonDocValuesField.newDistanceSort("some_geo_field", 0.0, 0.0).getClass();
    }

    private static final class CommitPoint
    extends IndexCommit {
        private String segmentsFileName;
        private final Collection<String> files;
        private final Directory dir;
        private final long generation;
        private final Map<String, String> userData;
        private final int segmentCount;

        private CommitPoint(SegmentInfos infos, Directory dir) throws IOException {
            this.segmentsFileName = infos.getSegmentsFileName();
            this.dir = dir;
            this.userData = infos.getUserData();
            this.files = Collections.unmodifiableCollection(infos.files(true));
            this.generation = infos.getGeneration();
            this.segmentCount = infos.size();
        }

        public String toString() {
            return "DirectoryReader.ReaderCommit(" + this.segmentsFileName + ")";
        }

        @Override
        public int getSegmentCount() {
            return this.segmentCount;
        }

        @Override
        public String getSegmentsFileName() {
            return this.segmentsFileName;
        }

        @Override
        public Collection<String> getFileNames() {
            return this.files;
        }

        @Override
        public Directory getDirectory() {
            return this.dir;
        }

        @Override
        public long getGeneration() {
            return this.generation;
        }

        @Override
        public boolean isDeleted() {
            return false;
        }

        @Override
        public Map<String, String> getUserData() {
            return this.userData;
        }

        @Override
        public void delete() {
            throw new UnsupportedOperationException("This IndexCommit does not support deletions");
        }
    }

    @SuppressForbidden(reason="Version#parseLeniently() used in a central place")
    private static final class LenientParser {
        private LenientParser() {
        }

        public static Version parse(String toParse, Version defaultValue) {
            if (Strings.hasLength(toParse)) {
                try {
                    return Version.parseLeniently(toParse);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return defaultValue;
        }
    }

    public static final class EarlyTerminatingCollector
    extends SimpleCollector {
        private final int maxCountHits;
        private final Collector delegate;
        private int count = 0;
        private LeafCollector leafCollector;

        EarlyTerminatingCollector(Collector delegate, int maxCountHits) {
            this.maxCountHits = maxCountHits;
            this.delegate = Objects.requireNonNull(delegate);
        }

        public int count() {
            return this.count;
        }

        public boolean exists() {
            return this.count > 0;
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.leafCollector.setScorer(scorer);
        }

        @Override
        public void collect(int doc) throws IOException {
            this.leafCollector.collect(doc);
            if (++this.count >= this.maxCountHits) {
                throw new EarlyTerminationException("early termination [CountBased]");
            }
        }

        @Override
        public void doSetNextReader(LeafReaderContext atomicReaderContext) throws IOException {
            this.leafCollector = this.delegate.getLeafCollector(atomicReaderContext);
        }

        @Override
        public boolean needsScores() {
            return this.delegate.needsScores();
        }
    }

    public static final class EarlyTerminationException
    extends ElasticsearchException {
        public EarlyTerminationException(String msg) {
            super(msg, new Object[0]);
        }

        public EarlyTerminationException(StreamInput in) throws IOException {
            super(in);
        }
    }
}

