/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import java.util.List;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class SameShardAllocationDecider
extends AllocationDecider {
    public static final String NAME = "same_shard";
    public static final Setting<Boolean> CLUSTER_ROUTING_ALLOCATION_SAME_HOST_SETTING = Setting.boolSetting("cluster.routing.allocation.same_shard.host", false, Setting.Property.NodeScope);
    private final boolean sameHost;

    public SameShardAllocationDecider(Settings settings) {
        super(settings);
        this.sameHost = CLUSTER_ROUTING_ALLOCATION_SAME_HOST_SETTING.get(settings);
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        List<ShardRouting> assignedShards = allocation.routingNodes().assignedShards(shardRouting.shardId());
        for (ShardRouting assignedShard : assignedShards) {
            if (!node.nodeId().equals(assignedShard.currentNodeId())) continue;
            return allocation.decision(Decision.NO, NAME, "the shard cannot be allocated on the same node id [%s] on which it already exists", node.nodeId());
        }
        if (this.sameHost && node.node() != null) {
            for (RoutingNode checkNode : allocation.routingNodes()) {
                if (checkNode.node() == null) continue;
                boolean checkNodeOnSameHost = false;
                if (Strings.hasLength(checkNode.node().getHostAddress()) && Strings.hasLength(node.node().getHostAddress())) {
                    if (checkNode.node().getHostAddress().equals(node.node().getHostAddress())) {
                        checkNodeOnSameHost = true;
                    }
                } else if (Strings.hasLength(checkNode.node().getHostName()) && Strings.hasLength(node.node().getHostName()) && checkNode.node().getHostName().equals(node.node().getHostName())) {
                    checkNodeOnSameHost = true;
                }
                if (!checkNodeOnSameHost) continue;
                for (ShardRouting assignedShard : assignedShards) {
                    if (!checkNode.nodeId().equals(assignedShard.currentNodeId())) continue;
                    return allocation.decision(Decision.NO, NAME, "shard cannot be allocated on the same host [%s] on which it already exists", node.nodeId());
                }
            }
        }
        return allocation.decision(Decision.YES, NAME, "shard is not allocated to same node or host", new Object[0]);
    }
}

