/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.TimeoutClusterStateListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;

public class ClusterStateObserver {
    protected final Logger logger;
    public final ChangePredicate MATCH_ALL_CHANGES_PREDICATE = new EventPredicate(){

        @Override
        public boolean apply(ClusterChangedEvent changedEvent) {
            return changedEvent.previousState().version() != changedEvent.state().version();
        }
    };
    private final ClusterService clusterService;
    private final ThreadContext contextHolder;
    volatile TimeValue timeOutValue;
    final AtomicReference<ObservedState> lastObservedState;
    final TimeoutClusterStateListener clusterStateListener = new ObserverClusterStateListener();
    final AtomicReference<ObservingContext> observingContext = new AtomicReference<Object>(null);
    volatile Long startTimeNS;
    volatile boolean timedOut;

    public ClusterStateObserver(ClusterService clusterService, Logger logger, ThreadContext contextHolder) {
        this(clusterService, new TimeValue(60000L), logger, contextHolder);
    }

    public ClusterStateObserver(ClusterService clusterService, @Nullable TimeValue timeout, Logger logger, ThreadContext contextHolder) {
        this.clusterService = clusterService;
        this.lastObservedState = new AtomicReference<ObservedState>(new ObservedState(clusterService.state()));
        this.timeOutValue = timeout;
        if (this.timeOutValue != null) {
            this.startTimeNS = System.nanoTime();
        }
        this.logger = logger;
        this.contextHolder = contextHolder;
    }

    public ClusterState observedState() {
        ObservedState state = this.lastObservedState.get();
        assert (state != null);
        return state.clusterState;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public void waitForNextChange(Listener listener) {
        this.waitForNextChange(listener, this.MATCH_ALL_CHANGES_PREDICATE);
    }

    public void waitForNextChange(Listener listener, @Nullable TimeValue timeOutValue) {
        this.waitForNextChange(listener, this.MATCH_ALL_CHANGES_PREDICATE, timeOutValue);
    }

    public void waitForNextChange(Listener listener, ChangePredicate changePredicate) {
        this.waitForNextChange(listener, changePredicate, null);
    }

    public void waitForNextChange(Listener listener, ChangePredicate changePredicate, @Nullable TimeValue timeOutValue) {
        Long timeoutTimeLeftMS;
        if (this.observingContext.get() != null) {
            throw new ElasticsearchException("already waiting for a cluster state change", new Object[0]);
        }
        if (timeOutValue == null) {
            timeOutValue = this.timeOutValue;
            if (timeOutValue != null) {
                long timeSinceStartMS = TimeValue.nsecToMSec(System.nanoTime() - this.startTimeNS);
                timeoutTimeLeftMS = timeOutValue.millis() - timeSinceStartMS;
                if (timeoutTimeLeftMS <= 0L) {
                    this.logger.trace("observer timed out. notifying listener. timeout setting [{}], time since start [{}]", (Object)timeOutValue, (Object)new TimeValue(timeSinceStartMS));
                    this.timedOut = true;
                    this.lastObservedState.set(new ObservedState(this.clusterService.state()));
                    listener.onTimeout(timeOutValue);
                    return;
                }
            } else {
                timeoutTimeLeftMS = null;
            }
        } else {
            this.startTimeNS = System.nanoTime();
            this.timeOutValue = timeOutValue;
            timeoutTimeLeftMS = timeOutValue.millis();
            this.timedOut = false;
        }
        ObservedState newState = new ObservedState(this.clusterService.state());
        ObservedState lastState = this.lastObservedState.get();
        if (changePredicate.apply(lastState.clusterState, lastState.status, newState.clusterState, newState.status)) {
            this.logger.trace("observer: sampled state accepted by predicate ({})", (Object)newState);
            this.lastObservedState.set(newState);
            listener.onNewClusterState(newState.clusterState);
        } else {
            this.logger.trace("observer: sampled state rejected by predicate ({}). adding listener to ClusterService", (Object)newState);
            ObservingContext context = new ObservingContext(new ContextPreservingListener(listener, this.contextHolder.newStoredContext()), changePredicate);
            if (!this.observingContext.compareAndSet(null, context)) {
                throw new ElasticsearchException("already waiting for a cluster state change", new Object[0]);
            }
            this.clusterService.add(timeoutTimeLeftMS == null ? null : new TimeValue(timeoutTimeLeftMS), this.clusterStateListener);
        }
    }

    public void reset(ClusterState toState) {
        if (this.observingContext.getAndSet(null) != null) {
            this.clusterService.remove(this.clusterStateListener);
        }
        this.lastObservedState.set(new ObservedState(toState));
    }

    private static final class ContextPreservingListener
    implements Listener {
        private final Listener delegate;
        private final ThreadContext.StoredContext tempContext;

        private ContextPreservingListener(Listener delegate, ThreadContext.StoredContext storedContext) {
            this.tempContext = storedContext;
            this.delegate = delegate;
        }

        @Override
        public void onNewClusterState(ClusterState state) {
            this.tempContext.restore();
            this.delegate.onNewClusterState(state);
        }

        @Override
        public void onClusterServiceClose() {
            this.tempContext.restore();
            this.delegate.onClusterServiceClose();
        }

        @Override
        public void onTimeout(TimeValue timeout) {
            this.tempContext.restore();
            this.delegate.onTimeout(timeout);
        }
    }

    static class ObservedState {
        public final ClusterState clusterState;
        public final ClusterState.ClusterStateStatus status;

        public ObservedState(ClusterState clusterState) {
            this.clusterState = clusterState;
            this.status = clusterState.status();
        }

        public String toString() {
            return "version [" + this.clusterState.version() + "], status [" + (Object)((Object)this.status) + "]";
        }
    }

    static class ObservingContext {
        public final Listener listener;
        public final ChangePredicate changePredicate;

        public ObservingContext(Listener listener, ChangePredicate changePredicate) {
            this.listener = listener;
            this.changePredicate = changePredicate;
        }
    }

    public static abstract class EventPredicate
    implements ChangePredicate {
        @Override
        public boolean apply(ClusterState previousState, ClusterState.ClusterStateStatus previousStatus, ClusterState newState, ClusterState.ClusterStateStatus newStatus) {
            return previousState != newState || previousStatus != newStatus;
        }
    }

    public static abstract class ValidationPredicate
    implements ChangePredicate {
        @Override
        public boolean apply(ClusterState previousState, ClusterState.ClusterStateStatus previousStatus, ClusterState newState, ClusterState.ClusterStateStatus newStatus) {
            return (previousState != newState || previousStatus != newStatus) && this.validate(newState);
        }

        protected abstract boolean validate(ClusterState var1);

        @Override
        public boolean apply(ClusterChangedEvent changedEvent) {
            return changedEvent.previousState().version() != changedEvent.state().version() && this.validate(changedEvent.state());
        }
    }

    public static interface ChangePredicate {
        public boolean apply(ClusterState var1, ClusterState.ClusterStateStatus var2, ClusterState var3, ClusterState.ClusterStateStatus var4);

        public boolean apply(ClusterChangedEvent var1);
    }

    public static interface Listener {
        public void onNewClusterState(ClusterState var1);

        public void onClusterServiceClose();

        public void onTimeout(TimeValue var1);
    }

    class ObserverClusterStateListener
    implements TimeoutClusterStateListener {
        ObserverClusterStateListener() {
        }

        @Override
        public void clusterChanged(ClusterChangedEvent event) {
            ObservingContext context = ClusterStateObserver.this.observingContext.get();
            if (context == null) {
                return;
            }
            if (context.changePredicate.apply(event)) {
                if (ClusterStateObserver.this.observingContext.compareAndSet(context, null)) {
                    ClusterStateObserver.this.clusterService.remove(this);
                    ObservedState state = new ObservedState(event.state());
                    ClusterStateObserver.this.logger.trace("observer: accepting cluster state change ({})", (Object)state);
                    ClusterStateObserver.this.lastObservedState.set(state);
                    context.listener.onNewClusterState(state.clusterState);
                } else {
                    ClusterStateObserver.this.logger.trace("observer: predicate approved change but observing context has changed - ignoring (new cluster state version [{}])", (Object)event.state().version());
                }
            } else {
                ClusterStateObserver.this.logger.trace("observer: predicate rejected change (new cluster state version [{}])", (Object)event.state().version());
            }
        }

        @Override
        public void postAdded() {
            ObservingContext context = ClusterStateObserver.this.observingContext.get();
            if (context == null) {
                return;
            }
            ObservedState newState = new ObservedState(ClusterStateObserver.this.clusterService.state());
            ObservedState lastState = ClusterStateObserver.this.lastObservedState.get();
            if (context.changePredicate.apply(lastState.clusterState, lastState.status, newState.clusterState, newState.status)) {
                if (ClusterStateObserver.this.observingContext.compareAndSet(context, null)) {
                    ClusterStateObserver.this.logger.trace("observer: post adding listener: accepting current cluster state ({})", (Object)newState);
                    ClusterStateObserver.this.clusterService.remove(this);
                    ClusterStateObserver.this.lastObservedState.set(newState);
                    context.listener.onNewClusterState(newState.clusterState);
                } else {
                    ClusterStateObserver.this.logger.trace("observer: postAdded - predicate approved state but observing context has changed - ignoring ({})", (Object)newState);
                }
            } else {
                ClusterStateObserver.this.logger.trace("observer: postAdded - predicate rejected state ({})", (Object)newState);
            }
        }

        @Override
        public void onClose() {
            ObservingContext context = ClusterStateObserver.this.observingContext.getAndSet(null);
            if (context != null) {
                ClusterStateObserver.this.logger.trace("observer: cluster service closed. notifying listener.");
                ClusterStateObserver.this.clusterService.remove(this);
                context.listener.onClusterServiceClose();
            }
        }

        @Override
        public void onTimeout(TimeValue timeout) {
            ObservingContext context = ClusterStateObserver.this.observingContext.getAndSet(null);
            if (context != null) {
                ClusterStateObserver.this.clusterService.remove(this);
                long timeSinceStartMS = TimeValue.nsecToMSec(System.nanoTime() - ClusterStateObserver.this.startTimeNS);
                ClusterStateObserver.this.logger.trace("observer: timeout notification from cluster service. timeout setting [{}], time since start [{}]", (Object)ClusterStateObserver.this.timeOutValue, (Object)new TimeValue(timeSinceStartMS));
                ClusterStateObserver.this.lastObservedState.set(new ObservedState(ClusterStateObserver.this.clusterService.state()));
                ClusterStateObserver.this.timedOut = true;
                context.listener.onTimeout(ClusterStateObserver.this.timeOutValue);
            }
        }
    }
}

