/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.carrotsearch.hppc.IntArrayList;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.carrotsearch.hppc.ObjectObjectHashMap;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.Term;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.CollectionStatistics;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.FieldDoc;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.ScoreDoc;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Sort;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.SortField;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.TermStatistics;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.TopDocs;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.TopFieldDocs;
import org.elasticsearch.common.collect.HppcMaps;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.pipeline.SiblingPipelineAggregator;
import org.elasticsearch.search.dfs.AggregatedDfs;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.FetchSearchResultProvider;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.InternalSearchHits;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.profile.ProfileShardResult;
import org.elasticsearch.search.profile.SearchProfileShardResults;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.query.QuerySearchResultProvider;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.completion.CompletionSuggestion;

public class SearchPhaseController
extends AbstractComponent {
    private static final Comparator<AtomicArray.Entry<? extends QuerySearchResultProvider>> QUERY_RESULT_ORDERING = (o1, o2) -> {
        int i = ((QuerySearchResultProvider)o1.value).shardTarget().index().compareTo(((QuerySearchResultProvider)o2.value).shardTarget().index());
        if (i == 0) {
            i = ((QuerySearchResultProvider)o1.value).shardTarget().shardId().id() - ((QuerySearchResultProvider)o2.value).shardTarget().shardId().id();
        }
        return i;
    };
    private static final ScoreDoc[] EMPTY_DOCS = new ScoreDoc[0];
    private final BigArrays bigArrays;
    private final ScriptService scriptService;

    SearchPhaseController(Settings settings, BigArrays bigArrays, ScriptService scriptService) {
        super(settings);
        this.bigArrays = bigArrays;
        this.scriptService = scriptService;
    }

    public AggregatedDfs aggregateDfs(AtomicArray<DfsSearchResult> results) {
        ObjectObjectHashMap<Term, TermStatistics> termStatistics = HppcMaps.newNoNullKeysMap();
        ObjectObjectHashMap<String, CollectionStatistics> fieldStatistics = HppcMaps.newNoNullKeysMap();
        long aggMaxDoc = 0L;
        for (AtomicArray.Entry<DfsSearchResult> lEntry : results.asList()) {
            Term[] terms = ((DfsSearchResult)lEntry.value).terms();
            TermStatistics[] stats = ((DfsSearchResult)lEntry.value).termStatistics();
            assert (terms.length == stats.length);
            for (int i = 0; i < terms.length; ++i) {
                assert (terms[i] != null);
                TermStatistics existing = termStatistics.get(terms[i]);
                if (existing != null) {
                    assert (terms[i].bytes().equals(existing.term()));
                    termStatistics.put(terms[i], new TermStatistics(existing.term(), existing.docFreq() + stats[i].docFreq(), SearchPhaseController.optionalSum(existing.totalTermFreq(), stats[i].totalTermFreq())));
                    continue;
                }
                termStatistics.put(terms[i], stats[i]);
            }
            assert (!((DfsSearchResult)lEntry.value).fieldStatistics().containsKey(null));
            Object[] keys = ((DfsSearchResult)lEntry.value).fieldStatistics().keys;
            Object[] values = ((DfsSearchResult)lEntry.value).fieldStatistics().values;
            for (int i = 0; i < keys.length; ++i) {
                if (keys[i] == null) continue;
                String key = (String)keys[i];
                CollectionStatistics value = (CollectionStatistics)values[i];
                assert (key != null);
                CollectionStatistics existing = fieldStatistics.get(key);
                if (existing != null) {
                    CollectionStatistics merged = new CollectionStatistics(key, existing.maxDoc() + value.maxDoc(), SearchPhaseController.optionalSum(existing.docCount(), value.docCount()), SearchPhaseController.optionalSum(existing.sumTotalTermFreq(), value.sumTotalTermFreq()), SearchPhaseController.optionalSum(existing.sumDocFreq(), value.sumDocFreq()));
                    fieldStatistics.put(key, merged);
                    continue;
                }
                fieldStatistics.put(key, value);
            }
            aggMaxDoc += (long)((DfsSearchResult)lEntry.value).maxDoc();
        }
        return new AggregatedDfs(termStatistics, fieldStatistics, aggMaxDoc);
    }

    private static long optionalSum(long left, long right) {
        return Math.min(left, right) == -1L ? -1L : left + right;
    }

    /*
     * WARNING - void declaration
     */
    public ScoreDoc[] sortDocs(boolean ignoreFrom, AtomicArray<? extends QuerySearchResultProvider> resultsArr) throws IOException {
        TopDocs mergedTopDocs;
        List<AtomicArray.Entry<? extends QuerySearchResultProvider>> results = resultsArr.asList();
        if (results.isEmpty()) {
            return EMPTY_DOCS;
        }
        boolean canOptimize = false;
        QuerySearchResult result = null;
        int shardIndex = -1;
        if (results.size() == 1) {
            canOptimize = true;
            result = ((QuerySearchResultProvider)results.get((int)0).value).queryResult();
            shardIndex = results.get((int)0).index;
        } else {
            for (AtomicArray.Entry<? extends QuerySearchResultProvider> entry : results) {
                if (!((QuerySearchResultProvider)entry.value).queryResult().hasHits()) continue;
                if (result != null) {
                    canOptimize = false;
                    break;
                }
                canOptimize = true;
                result = ((QuerySearchResultProvider)entry.value).queryResult();
                shardIndex = entry.index;
            }
        }
        if (canOptimize) {
            ScoreDoc[] docs;
            List<Object> completionSuggestions;
            int offset = result.from();
            if (ignoreFrom) {
                offset = 0;
            }
            ScoreDoc[] scoreDocs = result.topDocs().scoreDocs;
            int numSuggestDocs = 0;
            Suggest suggest = result.queryResult().suggest();
            if (suggest != null) {
                completionSuggestions = suggest.filter(CompletionSuggestion.class);
                for (CompletionSuggestion completionSuggestion : completionSuggestions) {
                    numSuggestDocs += completionSuggestion.getOptions().size();
                }
            } else {
                completionSuggestions = Collections.emptyList();
            }
            int docsOffset = 0;
            if (scoreDocs.length == 0 || scoreDocs.length < offset) {
                docs = new ScoreDoc[numSuggestDocs];
            } else {
                void var15_34;
                int n;
                int n2 = result.size();
                if (scoreDocs.length - offset < n2) {
                    n = scoreDocs.length - offset;
                }
                docs = new ScoreDoc[n + numSuggestDocs];
                boolean bl = false;
                while (var15_34 < n) {
                    ScoreDoc scoreDoc = scoreDocs[offset + var15_34];
                    scoreDoc.shardIndex = shardIndex;
                    docs[var15_34] = scoreDoc;
                    ++docsOffset;
                    ++var15_34;
                }
            }
            for (CompletionSuggestion completionSuggestion : completionSuggestions) {
                for (CompletionSuggestion.Entry.Option option : completionSuggestion.getOptions()) {
                    ScoreDoc doc = option.getDoc();
                    doc.shardIndex = shardIndex;
                    docs[docsOffset++] = doc;
                }
            }
            return docs;
        }
        AtomicArray.Entry[] sortedResults = results.toArray(new AtomicArray.Entry[results.size()]);
        Arrays.sort(sortedResults, QUERY_RESULT_ORDERING);
        QuerySearchResultProvider firstResult = (QuerySearchResultProvider)sortedResults[0].value;
        int topN = SearchPhaseController.topN(results);
        int from = firstResult.queryResult().from();
        if (ignoreFrom) {
            from = 0;
        }
        if (firstResult.queryResult().topDocs() instanceof TopFieldDocs) {
            void var15_38;
            TopFieldDocs firstTopDocs = (TopFieldDocs)firstResult.queryResult().topDocs();
            Sort sort = new Sort(firstTopDocs.fields);
            TopFieldDocs[] topFieldDocsArray = new TopFieldDocs[resultsArr.length()];
            for (AtomicArray.Entry sortedResult : sortedResults) {
                TopDocs topDocs = ((QuerySearchResultProvider)sortedResult.value).queryResult().topDocs();
                topFieldDocsArray[sortedResult.index] = (TopFieldDocs)topDocs;
            }
            boolean bl = false;
            while (var15_38 < topFieldDocsArray.length) {
                if (topFieldDocsArray[var15_38] == null) {
                    topFieldDocsArray[var15_38] = new TopFieldDocs(0, new FieldDoc[0], sort.getSort(), Float.NaN);
                }
                ++var15_38;
            }
            mergedTopDocs = TopDocs.merge(sort, from, topN, topFieldDocsArray);
        } else {
            void var15_40;
            TopDocs[] shardTopDocs = new TopDocs[resultsArr.length()];
            AtomicArray.Entry[] sort = sortedResults;
            int n = sort.length;
            boolean bl = false;
            while (var15_40 < n) {
                TopDocs topDocs;
                AtomicArray.Entry sortedResult = sort[var15_40];
                shardTopDocs[sortedResult.index] = topDocs = ((QuerySearchResultProvider)sortedResult.value).queryResult().topDocs();
                ++var15_40;
            }
            for (int i = 0; i < shardTopDocs.length; ++i) {
                if (shardTopDocs[i] != null) continue;
                shardTopDocs[i] = Lucene.EMPTY_TOP_DOCS;
            }
            mergedTopDocs = TopDocs.merge(from, topN, shardTopDocs);
        }
        ScoreDoc[] scoreDocs = mergedTopDocs.scoreDocs;
        HashMap<String, List> groupedCompletionSuggestions = new HashMap<String, List>();
        for (AtomicArray.Entry sortedResult : sortedResults) {
            Suggest shardSuggest = ((QuerySearchResultProvider)sortedResult.value).queryResult().suggest();
            if (shardSuggest == null) continue;
            for (CompletionSuggestion suggestion : shardSuggest.filter(CompletionSuggestion.class)) {
                suggestion.setShardIndex(sortedResult.index);
                List suggestions = groupedCompletionSuggestions.computeIfAbsent(suggestion.getName(), s -> new ArrayList());
                suggestions.add(suggestion);
            }
        }
        if (!groupedCompletionSuggestions.isEmpty()) {
            void var14_30;
            boolean bl = false;
            ArrayList<Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>>> arrayList = new ArrayList<Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>>>(groupedCompletionSuggestions.size());
            for (List groupedSuggestions : groupedCompletionSuggestions.values()) {
                CompletionSuggestion completionSuggestion = CompletionSuggestion.reduceTo(groupedSuggestions);
                assert (completionSuggestion != null);
                var14_30 += completionSuggestion.getOptions().size();
                arrayList.add(completionSuggestion);
            }
            scoreDocs = new ScoreDoc[mergedTopDocs.scoreDocs.length + var14_30];
            System.arraycopy(mergedTopDocs.scoreDocs, 0, scoreDocs, 0, mergedTopDocs.scoreDocs.length);
            int offset = mergedTopDocs.scoreDocs.length;
            Suggest suggestions = new Suggest(arrayList);
            for (CompletionSuggestion completionSuggestion : suggestions.filter(CompletionSuggestion.class)) {
                for (CompletionSuggestion.Entry.Option option : completionSuggestion.getOptions()) {
                    scoreDocs[offset++] = option.getDoc();
                }
            }
        }
        return scoreDocs;
    }

    public ScoreDoc[] getLastEmittedDocPerShard(List<? extends AtomicArray.Entry<? extends QuerySearchResultProvider>> queryResults, ScoreDoc[] sortedScoreDocs, int numShards) {
        ScoreDoc[] lastEmittedDocPerShard = new ScoreDoc[numShards];
        if (!queryResults.isEmpty()) {
            long fetchHits = 0L;
            for (AtomicArray.Entry<? extends QuerySearchResultProvider> entry : queryResults) {
                fetchHits += (long)((QuerySearchResultProvider)entry.value).queryResult().topDocs().scoreDocs.length;
            }
            long size = Math.min(fetchHits, (long)SearchPhaseController.topN(queryResults));
            int sortedDocsIndex = 0;
            while ((long)sortedDocsIndex < size) {
                ScoreDoc scoreDoc;
                lastEmittedDocPerShard[scoreDoc.shardIndex] = scoreDoc = sortedScoreDocs[sortedDocsIndex];
                ++sortedDocsIndex;
            }
        }
        return lastEmittedDocPerShard;
    }

    public void fillDocIdsToLoad(AtomicArray<IntArrayList> docIdsToLoad, ScoreDoc[] shardDocs) {
        for (ScoreDoc shardDoc : shardDocs) {
            IntArrayList shardDocIdsToLoad = docIdsToLoad.get(shardDoc.shardIndex);
            if (shardDocIdsToLoad == null) {
                shardDocIdsToLoad = new IntArrayList();
                docIdsToLoad.set(shardDoc.shardIndex, shardDocIdsToLoad);
            }
            shardDocIdsToLoad.add(shardDoc.doc);
        }
    }

    public InternalSearchResponse merge(boolean ignoreFrom, ScoreDoc[] sortedDocs, AtomicArray<? extends QuerySearchResultProvider> queryResultsArr, AtomicArray<? extends FetchSearchResultProvider> fetchResultsArr) {
        List<AtomicArray.Entry<? extends QuerySearchResultProvider>> queryResults = queryResultsArr.asList();
        List<AtomicArray.Entry<? extends FetchSearchResultProvider>> fetchResults = fetchResultsArr.asList();
        if (queryResults.isEmpty()) {
            return InternalSearchResponse.empty();
        }
        QuerySearchResult firstResult = ((QuerySearchResultProvider)queryResults.get((int)0).value).queryResult();
        boolean sorted = false;
        int sortScoreIndex = -1;
        if (firstResult.topDocs() instanceof TopFieldDocs) {
            sorted = true;
            TopFieldDocs fieldDocs = (TopFieldDocs)firstResult.queryResult().topDocs();
            for (int i = 0; i < fieldDocs.fields.length; ++i) {
                if (fieldDocs.fields[i].getType() != SortField.Type.SCORE) continue;
                sortScoreIndex = i;
            }
        }
        long totalHits = 0L;
        long fetchHits = 0L;
        float maxScore = Float.NEGATIVE_INFINITY;
        boolean timedOut = false;
        Boolean terminatedEarly = null;
        for (AtomicArray.Entry<? extends QuerySearchResultProvider> entry : queryResults) {
            QuerySearchResult result = ((QuerySearchResultProvider)entry.value).queryResult();
            if (result.searchTimedOut()) {
                timedOut = true;
            }
            if (result.terminatedEarly() != null) {
                if (terminatedEarly == null) {
                    terminatedEarly = result.terminatedEarly();
                } else if (result.terminatedEarly().booleanValue()) {
                    terminatedEarly = true;
                }
            }
            totalHits += (long)result.topDocs().totalHits;
            fetchHits += (long)result.topDocs().scoreDocs.length;
            if (Float.isNaN(result.topDocs().getMaxScore())) continue;
            maxScore = Math.max(maxScore, result.topDocs().getMaxScore());
        }
        if (Float.isInfinite(maxScore)) {
            maxScore = Float.NaN;
        }
        for (AtomicArray.Entry<SearchPhaseResult> entry : fetchResults) {
            ((FetchSearchResultProvider)entry.value).fetchResult().initCounter();
        }
        int from = ignoreFrom ? 0 : firstResult.queryResult().from();
        int n = (int)Math.min(fetchHits - (long)from, (long)SearchPhaseController.topN(queryResults));
        ArrayList<Object> hits = new ArrayList<Object>();
        if (!fetchResults.isEmpty()) {
            for (int i = 0; i < n; ++i) {
                FetchSearchResult fetchSearchResult;
                int n2;
                ScoreDoc shardDoc = sortedDocs[i];
                FetchSearchResultProvider fetchResultProvider = fetchResultsArr.get(shardDoc.shardIndex);
                if (fetchResultProvider == null || (n2 = (fetchSearchResult = fetchResultProvider.fetchResult()).counterGetAndIncrement()) >= fetchSearchResult.hits().internalHits().length) continue;
                InternalSearchHit searchHit = fetchSearchResult.hits().internalHits()[n2];
                searchHit.score(shardDoc.score);
                searchHit.shard(fetchSearchResult.shardTarget());
                if (sorted) {
                    FieldDoc fieldDoc = (FieldDoc)shardDoc;
                    searchHit.sortValues(fieldDoc.fields, firstResult.sortValueFormats());
                    if (sortScoreIndex != -1) {
                        searchHit.score(((Number)fieldDoc.fields[sortScoreIndex]).floatValue());
                    }
                }
                hits.add(searchHit);
            }
        }
        Suggest suggest = null;
        if (firstResult.suggest() != null) {
            HashMap<String, List<Suggest.Suggestion>> groupedSuggestions = new HashMap<String, List<Suggest.Suggestion>>();
            for (AtomicArray.Entry entry : queryResults) {
                Suggest suggest2 = ((QuerySearchResultProvider)entry.value).queryResult().suggest();
                if (suggest2 == null) continue;
                for (Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>> suggestion : suggest2) {
                    List suggestionList = groupedSuggestions.computeIfAbsent(suggestion.getName(), s -> new ArrayList());
                    suggestionList.add(suggestion);
                }
            }
            if (!groupedSuggestions.isEmpty()) {
                suggest = new Suggest(Suggest.reduce(groupedSuggestions));
                if (!fetchResults.isEmpty()) {
                    int currentOffset = n;
                    for (CompletionSuggestion completionSuggestion : suggest.filter(CompletionSuggestion.class)) {
                        List<CompletionSuggestion.Entry.Option> suggestionOptions = completionSuggestion.getOptions();
                        for (int scoreDocIndex = currentOffset; scoreDocIndex < currentOffset + suggestionOptions.size(); ++scoreDocIndex) {
                            FetchSearchResult fetchResult;
                            int fetchResultIndex;
                            ScoreDoc shardDoc = sortedDocs[scoreDocIndex];
                            FetchSearchResultProvider fetchSearchResultProvider = fetchResultsArr.get(shardDoc.shardIndex);
                            if (fetchSearchResultProvider == null || (fetchResultIndex = (fetchResult = fetchSearchResultProvider.fetchResult()).counterGetAndIncrement()) >= fetchResult.hits().internalHits().length) continue;
                            InternalSearchHit hit = fetchResult.hits().internalHits()[fetchResultIndex];
                            CompletionSuggestion.Entry.Option suggestOption = suggestionOptions.get(scoreDocIndex - currentOffset);
                            hit.score(shardDoc.score);
                            hit.shard(fetchResult.shardTarget());
                            suggestOption.setHit(hit);
                        }
                        currentOffset += suggestionOptions.size();
                    }
                    assert (currentOffset == sortedDocs.length) : "expected no more score doc slices";
                }
            }
        }
        InternalAggregations aggregations = null;
        if (firstResult.aggregations() != null && firstResult.aggregations().asList() != null) {
            ArrayList<InternalAggregations> aggregationsList = new ArrayList<InternalAggregations>(queryResults.size());
            for (AtomicArray.Entry<? extends QuerySearchResultProvider> entry : queryResults) {
                aggregationsList.add((InternalAggregations)((QuerySearchResultProvider)entry.value).queryResult().aggregations());
            }
            InternalAggregation.ReduceContext reduceContext = new InternalAggregation.ReduceContext(this.bigArrays, this.scriptService);
            aggregations = InternalAggregations.reduce(aggregationsList, reduceContext);
            List<SiblingPipelineAggregator> list = firstResult.pipelineAggregators();
            if (list != null) {
                List<InternalAggregation> newAggs = StreamSupport.stream(aggregations.spliterator(), false).map(p -> (InternalAggregation)p).collect(Collectors.toList());
                for (SiblingPipelineAggregator pipelineAggregator : list) {
                    InternalAggregation newAgg = pipelineAggregator.doReduce(new InternalAggregations(newAggs), reduceContext);
                    newAggs.add(newAgg);
                }
                aggregations = new InternalAggregations(newAggs);
            }
        }
        SearchProfileShardResults shardResults = null;
        if (firstResult.profileResults() != null) {
            HashMap<String, ProfileShardResult> hashMap = new HashMap<String, ProfileShardResult>(queryResults.size());
            for (AtomicArray.Entry<? extends QuerySearchResultProvider> entry : queryResults) {
                String key = ((QuerySearchResultProvider)entry.value).queryResult().shardTarget().toString();
                hashMap.put(key, ((QuerySearchResultProvider)entry.value).queryResult().profileResults());
            }
            shardResults = new SearchProfileShardResults(hashMap);
        }
        InternalSearchHits internalSearchHits = new InternalSearchHits(hits.toArray(new InternalSearchHit[hits.size()]), totalHits, maxScore);
        return new InternalSearchResponse(internalSearchHits, aggregations, suggest, shardResults, timedOut, terminatedEarly);
    }

    private static int topN(List<? extends AtomicArray.Entry<? extends QuerySearchResultProvider>> queryResults) {
        QuerySearchResultProvider firstResult = (QuerySearchResultProvider)queryResults.get((int)0).value;
        int topN = firstResult.queryResult().size();
        if (firstResult.includeFetch()) {
            topN *= queryResults.size();
        }
        return topN;
    }
}

