/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.storedscripts;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class DeleteStoredScriptRequest
extends AcknowledgedRequest<DeleteStoredScriptRequest> {
    private String id;
    private String scriptLang;

    DeleteStoredScriptRequest() {
    }

    public DeleteStoredScriptRequest(String scriptLang, String id) {
        this.scriptLang = scriptLang;
        this.id = id;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.id == null) {
            validationException = ValidateActions.addValidationError("id is missing", validationException);
        } else if (this.id.contains("#")) {
            validationException = ValidateActions.addValidationError("id can't contain: '#'", validationException);
        }
        if (this.scriptLang == null) {
            validationException = ValidateActions.addValidationError("lang is missing", validationException);
        } else if (this.scriptLang.contains("#")) {
            validationException = ValidateActions.addValidationError("lang can't contain: '#'", validationException);
        }
        return validationException;
    }

    public String scriptLang() {
        return this.scriptLang;
    }

    public DeleteStoredScriptRequest scriptLang(String type) {
        this.scriptLang = type;
        return this;
    }

    public String id() {
        return this.id;
    }

    public DeleteStoredScriptRequest id(String id) {
        this.id = id;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.scriptLang = in.readString();
        this.id = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.scriptLang);
        out.writeString(this.id);
    }

    public String toString() {
        return "delete script {[" + this.scriptLang + "][" + this.id + "]}";
    }
}

