/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.allocation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.CorruptIndexException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.allocation.ClusterAllocationExplainRequest;
import org.elasticsearch.action.admin.cluster.allocation.ClusterAllocationExplainResponse;
import org.elasticsearch.action.admin.cluster.allocation.ClusterAllocationExplanation;
import org.elasticsearch.action.admin.cluster.allocation.NodeExplanation;
import org.elasticsearch.action.admin.indices.shards.IndicesShardStoresRequest;
import org.elasticsearch.action.admin.indices.shards.IndicesShardStoresResponse;
import org.elasticsearch.action.admin.indices.shards.TransportIndicesShardStoresAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.ImmutableOpenIntMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.gateway.GatewayAllocator;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportClusterAllocationExplainAction
extends TransportMasterNodeAction<ClusterAllocationExplainRequest, ClusterAllocationExplainResponse> {
    private final ClusterInfoService clusterInfoService;
    private final AllocationDeciders allocationDeciders;
    private final ShardsAllocator shardAllocator;
    private final TransportIndicesShardStoresAction shardStoresAction;
    private final GatewayAllocator gatewayAllocator;

    @Inject
    public TransportClusterAllocationExplainAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterInfoService clusterInfoService, AllocationDeciders allocationDeciders, ShardsAllocator shardAllocator, TransportIndicesShardStoresAction shardStoresAction, GatewayAllocator gatewayAllocator) {
        super(settings, "cluster:monitor/allocation/explain", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, ClusterAllocationExplainRequest::new);
        this.clusterInfoService = clusterInfoService;
        this.allocationDeciders = allocationDeciders;
        this.shardAllocator = shardAllocator;
        this.shardStoresAction = shardStoresAction;
        this.gatewayAllocator = gatewayAllocator;
    }

    @Override
    protected String executor() {
        return "management";
    }

    @Override
    protected ClusterBlockException checkBlock(ClusterAllocationExplainRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected ClusterAllocationExplainResponse newResponse() {
        return new ClusterAllocationExplainResponse();
    }

    public static Decision tryShardOnNode(ShardRouting shard, RoutingNode node, RoutingAllocation allocation, boolean includeYesDecisions) {
        Decision d = allocation.deciders().canAllocate(shard, node, allocation);
        if (includeYesDecisions) {
            return d;
        }
        Decision.Multi nonYesDecisions = new Decision.Multi();
        List<Decision> decisions = d.getDecisions();
        for (Decision decision : decisions) {
            if (decision.type() == Decision.Type.YES) continue;
            nonYesDecisions.add(decision);
        }
        return nonYesDecisions;
    }

    public static NodeExplanation calculateNodeExplanation(ShardRouting shard, IndexMetaData indexMetaData, DiscoveryNode node, Decision nodeDecision, Float nodeWeight, IndicesShardStoresResponse.StoreStatus storeStatus, String assignedNodeId, Set<String> activeAllocationIds, boolean hasPendingAsyncFetch) {
        String finalExplanation;
        ClusterAllocationExplanation.FinalDecision finalDecision;
        Exception storeErr;
        ClusterAllocationExplanation.StoreCopy storeCopy = storeStatus == null ? ClusterAllocationExplanation.StoreCopy.NONE : ((storeErr = storeStatus.getStoreException()) != null ? (ExceptionsHelper.unwrapCause(storeErr) instanceof CorruptIndexException ? ClusterAllocationExplanation.StoreCopy.CORRUPT : ClusterAllocationExplanation.StoreCopy.IO_ERROR) : (activeAllocationIds.isEmpty() ? ClusterAllocationExplanation.StoreCopy.UNKNOWN : (activeAllocationIds.contains(storeStatus.getAllocationId()) ? ClusterAllocationExplanation.StoreCopy.AVAILABLE : ClusterAllocationExplanation.StoreCopy.STALE)));
        if (node.getId().equals(assignedNodeId)) {
            finalDecision = ClusterAllocationExplanation.FinalDecision.ALREADY_ASSIGNED;
            finalExplanation = "the shard is already assigned to this node";
        } else if (shard.unassigned() && !shard.primary() && shard.unassignedInfo().getReason() != UnassignedInfo.Reason.INDEX_CREATED && nodeDecision.type() != Decision.Type.YES) {
            finalExplanation = "the shard cannot be assigned because allocation deciders return a " + nodeDecision.type().name() + " decision";
            finalDecision = ClusterAllocationExplanation.FinalDecision.NO;
        } else if (shard.unassigned() && !shard.primary() && shard.unassignedInfo().getReason() != UnassignedInfo.Reason.INDEX_CREATED && hasPendingAsyncFetch) {
            finalExplanation = "the shard's state is still being fetched so it cannot be allocated";
            finalDecision = ClusterAllocationExplanation.FinalDecision.NO;
        } else if (shard.primary() && shard.unassigned() && (shard.recoverySource().getType() == RecoverySource.Type.EXISTING_STORE || shard.recoverySource().getType() == RecoverySource.Type.SNAPSHOT) && hasPendingAsyncFetch) {
            finalExplanation = "the shard's state is still being fetched so it cannot be allocated";
            finalDecision = ClusterAllocationExplanation.FinalDecision.NO;
        } else if (shard.primary() && shard.unassigned() && shard.recoverySource().getType() == RecoverySource.Type.EXISTING_STORE && storeCopy == ClusterAllocationExplanation.StoreCopy.STALE) {
            finalExplanation = "the copy of the shard is stale, allocation ids do not match";
            finalDecision = ClusterAllocationExplanation.FinalDecision.NO;
        } else if (shard.primary() && shard.unassigned() && shard.recoverySource().getType() == RecoverySource.Type.EXISTING_STORE && storeCopy == ClusterAllocationExplanation.StoreCopy.NONE) {
            finalExplanation = "there is no copy of the shard available";
            finalDecision = ClusterAllocationExplanation.FinalDecision.NO;
        } else if (shard.primary() && shard.unassigned() && shard.recoverySource().getType() == RecoverySource.Type.EXISTING_STORE && storeCopy == ClusterAllocationExplanation.StoreCopy.CORRUPT) {
            finalExplanation = "the copy of the shard is corrupt";
            finalDecision = ClusterAllocationExplanation.FinalDecision.NO;
        } else if (shard.primary() && shard.unassigned() && shard.recoverySource().getType() == RecoverySource.Type.EXISTING_STORE && storeCopy == ClusterAllocationExplanation.StoreCopy.IO_ERROR) {
            finalExplanation = "the copy of the shard cannot be read";
            finalDecision = ClusterAllocationExplanation.FinalDecision.NO;
        } else if (nodeDecision.type() == Decision.Type.NO) {
            finalDecision = ClusterAllocationExplanation.FinalDecision.NO;
            finalExplanation = "the shard cannot be assigned because one or more allocation decider returns a 'NO' decision";
        } else {
            finalDecision = ClusterAllocationExplanation.FinalDecision.YES;
            finalExplanation = storeCopy == ClusterAllocationExplanation.StoreCopy.AVAILABLE ? "the shard can be assigned and the node contains a valid copy of the shard data" : "the shard can be assigned";
        }
        return new NodeExplanation(node, nodeDecision, nodeWeight, storeStatus, finalDecision, finalExplanation, storeCopy);
    }

    public static ClusterAllocationExplanation explainShard(ShardRouting shard, RoutingAllocation allocation, RoutingNodes routingNodes, boolean includeYesDecisions, ShardsAllocator shardAllocator, List<IndicesShardStoresResponse.StoreStatus> shardStores, GatewayAllocator gatewayAllocator, ClusterInfo clusterInfo) {
        allocation.debugDecision(true);
        UnassignedInfo ui = shard.unassignedInfo();
        HashMap<DiscoveryNode, Decision> nodeToDecision = new HashMap<DiscoveryNode, Decision>();
        for (RoutingNode node : routingNodes) {
            DiscoveryNode discoNode = node.node();
            if (!discoNode.isDataNode()) continue;
            Decision d = TransportClusterAllocationExplainAction.tryShardOnNode(shard, node, allocation, includeYesDecisions);
            nodeToDecision.put(discoNode, d);
        }
        long remainingDelayMillis = 0L;
        MetaData metadata = allocation.metaData();
        IndexMetaData indexMetaData = metadata.index(shard.index());
        long allocationDelayMillis = UnassignedInfo.INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING.get(indexMetaData.getSettings()).getMillis();
        if (ui != null && ui.isDelayed()) {
            long remainingDelayNanos = ui.getRemainingDelay(System.nanoTime(), indexMetaData.getSettings());
            remainingDelayMillis = TimeValue.timeValueNanos(remainingDelayNanos).millis();
        }
        Map<DiscoveryNode, Float> weights = shardAllocator.weighShard(allocation, shard);
        HashMap<DiscoveryNode, IndicesShardStoresResponse.StoreStatus> nodeToStatus = new HashMap<DiscoveryNode, IndicesShardStoresResponse.StoreStatus>(shardStores.size());
        for (IndicesShardStoresResponse.StoreStatus status : shardStores) {
            nodeToStatus.put(status.getNode(), status);
        }
        HashMap<DiscoveryNode, NodeExplanation> explanations = new HashMap<DiscoveryNode, NodeExplanation>(shardStores.size());
        for (Map.Entry entry : nodeToDecision.entrySet()) {
            DiscoveryNode node = (DiscoveryNode)entry.getKey();
            Decision decision = (Decision)entry.getValue();
            Float weight = weights.get(node);
            IndicesShardStoresResponse.StoreStatus storeStatus = (IndicesShardStoresResponse.StoreStatus)nodeToStatus.get(node);
            NodeExplanation nodeExplanation = TransportClusterAllocationExplainAction.calculateNodeExplanation(shard, indexMetaData, node, decision, weight, storeStatus, shard.currentNodeId(), indexMetaData.inSyncAllocationIds(shard.getId()), allocation.hasPendingAsyncFetch());
            explanations.put(node, nodeExplanation);
        }
        return new ClusterAllocationExplanation(shard.shardId(), shard.primary(), shard.currentNodeId(), allocationDelayMillis, remainingDelayMillis, ui, gatewayAllocator.hasFetchPending(shard.shardId(), shard.primary()), explanations, clusterInfo);
    }

    @Override
    protected void masterOperation(final ClusterAllocationExplainRequest request, ClusterState state, final ActionListener<ClusterAllocationExplainResponse> listener) {
        ShardRouting foundShard;
        RoutingAllocation allocation;
        ClusterInfo clusterInfo;
        RoutingNodes routingNodes;
        block6: {
            block5: {
                routingNodes = state.getRoutingNodes();
                clusterInfo = this.clusterInfoService.getClusterInfo();
                allocation = new RoutingAllocation(this.allocationDeciders, routingNodes, state, clusterInfo, System.nanoTime(), false);
                foundShard = null;
                if (!request.useAnyUnassignedShard()) break block5;
                RoutingNodes.UnassignedShards.UnassignedIterator ui = routingNodes.unassigned().iterator();
                if (!ui.hasNext()) break block6;
                foundShard = ui.next();
                break block6;
            }
            String index = request.getIndex();
            int shard = request.getShard();
            if (request.isPrimary().booleanValue()) {
                foundShard = allocation.routingTable().shardRoutingTable(index, shard).primaryShard();
            } else {
                List<ShardRouting> replicaShardRoutings = allocation.routingTable().shardRoutingTable(index, shard).replicaShards();
                if (replicaShardRoutings.size() > 0) {
                    foundShard = replicaShardRoutings.get(0);
                    for (ShardRouting replica : replicaShardRoutings) {
                        if (!replica.unassigned()) continue;
                        foundShard = replica;
                        break;
                    }
                }
            }
        }
        if (foundShard == null) {
            listener.onFailure(new ElasticsearchException("unable to find any shards to explain [{}] in the routing table", request));
            return;
        }
        final ShardRouting shardRouting = foundShard;
        this.logger.debug("explaining the allocation for [{}], found shard [{}]", (Object)request, (Object)shardRouting);
        this.getShardStores(shardRouting, new ActionListener<IndicesShardStoresResponse>(){

            @Override
            public void onResponse(IndicesShardStoresResponse shardStoreResponse) {
                ImmutableOpenIntMap<List<IndicesShardStoresResponse.StoreStatus>> shardStatuses = shardStoreResponse.getStoreStatuses().get(shardRouting.getIndexName());
                List<IndicesShardStoresResponse.StoreStatus> shardStoreStatus = shardStatuses.get(shardRouting.id());
                ClusterAllocationExplanation cae = TransportClusterAllocationExplainAction.explainShard(shardRouting, allocation, routingNodes, request.includeYesDecisions(), TransportClusterAllocationExplainAction.this.shardAllocator, shardStoreStatus, TransportClusterAllocationExplainAction.this.gatewayAllocator, request.includeDiskInfo() ? clusterInfo : null);
                listener.onResponse(new ClusterAllocationExplainResponse(cae));
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    private void getShardStores(ShardRouting shard, ActionListener<IndicesShardStoresResponse> listener) {
        IndicesShardStoresRequest request = new IndicesShardStoresRequest(shard.getIndexName());
        request.shardStatuses("all");
        this.shardStoresAction.execute(request, listener);
    }
}

