/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.channel.socket.http;

import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.buffer.ChannelBufferFactory;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.channel.ChannelPipelineFactory;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.channel.socket.SocketChannelConfig;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.channel.socket.http.HttpTunnelingClientSocketChannel;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.util.internal.ConversionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpTunnelingSocketChannelConfig
implements SocketChannelConfig {
    private final HttpTunnelingClientSocketChannel channel;
    private volatile String serverName;
    private volatile String serverPath = "/netty-tunnel";
    private volatile SSLContext sslContext;
    private volatile String[] enabledSslCipherSuites;
    private volatile String[] enabledSslProtocols;
    private volatile boolean enableSslSessionCreation = true;

    HttpTunnelingSocketChannelConfig(HttpTunnelingClientSocketChannel channel) {
        this.channel = channel;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerPath() {
        return this.serverPath;
    }

    public void setServerPath(String serverPath) {
        if (serverPath == null) {
            throw new NullPointerException("serverPath");
        }
        this.serverPath = serverPath;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public String[] getEnabledSslCipherSuites() {
        String[] suites = this.enabledSslCipherSuites;
        if (suites == null) {
            return null;
        }
        return (String[])suites.clone();
    }

    public void setEnabledSslCipherSuites(String[] suites) {
        this.enabledSslCipherSuites = suites == null ? null : (String[])suites.clone();
    }

    public String[] getEnabledSslProtocols() {
        String[] protocols = this.enabledSslProtocols;
        if (protocols == null) {
            return null;
        }
        return (String[])protocols.clone();
    }

    public void setEnabledSslProtocols(String[] protocols) {
        this.enabledSslProtocols = protocols == null ? null : (String[])protocols.clone();
    }

    public boolean isEnableSslSessionCreation() {
        return this.enableSslSessionCreation;
    }

    public void setEnableSslSessionCreation(boolean flag) {
        this.enableSslSessionCreation = flag;
    }

    @Override
    public void setOptions(Map<String, Object> options) {
        for (Map.Entry<String, Object> e : options.entrySet()) {
            this.setOption(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean setOption(String key, Object value) {
        if (this.channel.realChannel.getConfig().setOption(key, value)) {
            return true;
        }
        if ("serverName".equals(key)) {
            this.setServerName(String.valueOf(value));
        } else if ("serverPath".equals(key)) {
            this.setServerPath(String.valueOf(value));
        } else if ("sslContext".equals(key)) {
            this.setSslContext((SSLContext)value);
        } else if ("enabledSslCipherSuites".equals(key)) {
            this.setEnabledSslCipherSuites(ConversionUtil.toStringArray(value));
        } else if ("enabledSslProtocols".equals(key)) {
            this.setEnabledSslProtocols(ConversionUtil.toStringArray(value));
        } else if ("enableSslSessionCreation".equals(key)) {
            this.setEnableSslSessionCreation(ConversionUtil.toBoolean(value));
        } else {
            return false;
        }
        return true;
    }

    @Override
    public int getReceiveBufferSize() {
        return this.channel.realChannel.getConfig().getReceiveBufferSize();
    }

    @Override
    public int getSendBufferSize() {
        return this.channel.realChannel.getConfig().getSendBufferSize();
    }

    @Override
    public int getSoLinger() {
        return this.channel.realChannel.getConfig().getSoLinger();
    }

    @Override
    public int getTrafficClass() {
        return this.channel.realChannel.getConfig().getTrafficClass();
    }

    @Override
    public boolean isKeepAlive() {
        return this.channel.realChannel.getConfig().isKeepAlive();
    }

    @Override
    public boolean isReuseAddress() {
        return this.channel.realChannel.getConfig().isReuseAddress();
    }

    @Override
    public boolean isTcpNoDelay() {
        return this.channel.realChannel.getConfig().isTcpNoDelay();
    }

    @Override
    public void setKeepAlive(boolean keepAlive) {
        this.channel.realChannel.getConfig().setKeepAlive(keepAlive);
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.channel.realChannel.getConfig().setPerformancePreferences(connectionTime, latency, bandwidth);
    }

    @Override
    public void setReceiveBufferSize(int receiveBufferSize) {
        this.channel.realChannel.getConfig().setReceiveBufferSize(receiveBufferSize);
    }

    @Override
    public void setReuseAddress(boolean reuseAddress) {
        this.channel.realChannel.getConfig().setReuseAddress(reuseAddress);
    }

    @Override
    public void setSendBufferSize(int sendBufferSize) {
        this.channel.realChannel.getConfig().setSendBufferSize(sendBufferSize);
    }

    @Override
    public void setSoLinger(int soLinger) {
        this.channel.realChannel.getConfig().setSoLinger(soLinger);
    }

    @Override
    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.channel.realChannel.getConfig().setTcpNoDelay(tcpNoDelay);
    }

    @Override
    public void setTrafficClass(int trafficClass) {
        this.channel.realChannel.getConfig().setTrafficClass(trafficClass);
    }

    @Override
    public ChannelBufferFactory getBufferFactory() {
        return this.channel.realChannel.getConfig().getBufferFactory();
    }

    @Override
    public int getConnectTimeoutMillis() {
        return this.channel.realChannel.getConfig().getConnectTimeoutMillis();
    }

    @Override
    public ChannelPipelineFactory getPipelineFactory() {
        return this.channel.realChannel.getConfig().getPipelineFactory();
    }

    @Override
    public void setBufferFactory(ChannelBufferFactory bufferFactory) {
        this.channel.realChannel.getConfig().setBufferFactory(bufferFactory);
    }

    @Override
    public void setConnectTimeoutMillis(int connectTimeoutMillis) {
        this.channel.realChannel.getConfig().setConnectTimeoutMillis(connectTimeoutMillis);
    }

    @Override
    public void setPipelineFactory(ChannelPipelineFactory pipelineFactory) {
        this.channel.realChannel.getConfig().setPipelineFactory(pipelineFactory);
    }
}

