/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Accountable;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.FixedBitSet;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.MutableBits;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.SparseFixedBitSet;

public abstract class BitSet
implements MutableBits,
Accountable {
    public static BitSet of(DocIdSetIterator it, int maxDoc) throws IOException {
        int threshold;
        long cost = it.cost();
        BitSet set = cost < (long)(threshold = maxDoc >>> 7) ? new SparseFixedBitSet(maxDoc) : new FixedBitSet(maxDoc);
        set.or(it);
        return set;
    }

    public abstract void set(int var1);

    public abstract void clear(int var1, int var2);

    public abstract int cardinality();

    public int approximateCardinality() {
        return this.cardinality();
    }

    public abstract int prevSetBit(int var1);

    public abstract int nextSetBit(int var1);

    protected final void assertUnpositioned(DocIdSetIterator iter) {
        if (iter.docID() != -1) {
            throw new IllegalStateException("This operation only works with an unpositioned iterator, got current position = " + iter.docID());
        }
    }

    public void or(DocIdSetIterator iter) throws IOException {
        this.assertUnpositioned(iter);
        int doc = iter.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            this.set(doc);
            doc = iter.nextDoc();
        }
    }
}

