/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial3d.geom;

import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial3d.geom.BaseXYZSolid;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial3d.geom.GeoShape;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial3d.geom.Plane;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial3d.geom.PlanetModel;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial3d.geom.SidedPlane;

class XdYdZSolid
extends BaseXYZSolid {
    protected final GeoPoint[] surfacePoints;

    public XdYdZSolid(PlanetModel planetModel, double minX, double maxX, double Y, double Z) {
        super(planetModel);
        if (maxX - minX < 1.0E-12) {
            throw new IllegalArgumentException("X values in wrong order or identical");
        }
        Plane yPlane = new Plane(yUnitVector, -Y);
        Plane zPlane = new Plane(zUnitVector, -Z);
        SidedPlane minXPlane = new SidedPlane(maxX, 0.0, 0.0, xUnitVector, -minX);
        SidedPlane maxXPlane = new SidedPlane(minX, 0.0, 0.0, xUnitVector, -maxX);
        this.surfacePoints = yPlane.findIntersections(planetModel, zPlane, minXPlane, maxXPlane);
    }

    @Override
    protected GeoPoint[] getEdgePoints() {
        return this.surfacePoints;
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        for (GeoPoint p : this.surfacePoints) {
            if (!p.isIdentical(x, y, z)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getRelationship(GeoShape path) {
        int insideRectangle = this.isShapeInsideArea(path);
        if (insideRectangle == 1) {
            return 2;
        }
        int insideShape = this.isAreaInsideShape(path);
        if (insideShape == 1) {
            return 2;
        }
        if (insideRectangle == 0 && insideShape == 0) {
            return 2;
        }
        if (insideRectangle == 0) {
            return 1;
        }
        if (insideShape == 0) {
            return 0;
        }
        return 3;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof XdYdZSolid)) {
            return false;
        }
        XdYdZSolid other = (XdYdZSolid)o;
        if (!super.equals(other) || this.surfacePoints.length != other.surfacePoints.length) {
            return false;
        }
        for (int i = 0; i < this.surfacePoints.length; ++i) {
            if (this.surfacePoints[i].equals(other.surfacePoints[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        for (GeoPoint p : this.surfacePoints) {
            result = 31 * result + p.hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (GeoPoint p : this.surfacePoints) {
            sb.append(" ").append(p).append(" ");
        }
        return "XdYdZSolid: {planetmodel=" + this.planetModel + ", " + sb.toString() + "}";
    }
}

