/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.uhighlight;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.PostingsEnum;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.TermsEnum;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.spans.Spans;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.uhighlight.MultiTermHighlighting;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.uhighlight.OffsetsEnum;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.uhighlight.PhraseHelper;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.uhighlight.UnifiedHighlighter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.automaton.CharacterRunAutomaton;

public abstract class FieldOffsetStrategy {
    protected final String field;
    protected BytesRef[] terms;
    protected PhraseHelper strictPhrases;
    protected CharacterRunAutomaton[] automata;

    public FieldOffsetStrategy(String field, BytesRef[] queryTerms, PhraseHelper phraseHelper, CharacterRunAutomaton[] automata) {
        this.field = field;
        this.terms = queryTerms;
        this.strictPhrases = phraseHelper;
        this.automata = automata;
    }

    public String getField() {
        return this.field;
    }

    public abstract UnifiedHighlighter.OffsetSource getOffsetSource();

    public abstract List<OffsetsEnum> getOffsetsEnums(IndexReader var1, int var2, String var3) throws IOException;

    protected List<OffsetsEnum> createOffsetsEnums(LeafReader leafReader, int doc, TokenStream tokenStream) throws IOException {
        List<OffsetsEnum> offsetsEnums = this.createOffsetsEnumsFromReader(leafReader, doc);
        if (this.automata.length > 0) {
            offsetsEnums.add(this.createOffsetsEnumFromTokenStream(doc, tokenStream));
        }
        return offsetsEnums;
    }

    protected List<OffsetsEnum> createOffsetsEnumsFromReader(LeafReader atomicReader, int doc) throws IOException {
        Terms termsIndex;
        Map<BytesRef, Spans> strictPhrasesTermToSpans = this.strictPhrases.getTermToSpans(atomicReader, doc);
        List<BytesRef> sourceTerms = this.strictPhrases.expandTermsIfRewrite(this.terms, strictPhrasesTermToSpans);
        ArrayList<OffsetsEnum> offsetsEnums = new ArrayList<OffsetsEnum>(sourceTerms.size() + 1);
        Terms terms = termsIndex = atomicReader == null || sourceTerms.isEmpty() ? null : atomicReader.terms(this.field);
        if (termsIndex != null) {
            TermsEnum termsEnum = termsIndex.iterator();
            for (BytesRef term : sourceTerms) {
                if (!termsEnum.seekExact(term)) continue;
                PostingsEnum postingsEnum = termsEnum.postings(null, 56);
                if (postingsEnum == null) {
                    throw new IllegalArgumentException("field '" + this.field + "' was indexed without offsets, cannot highlight");
                }
                if (doc != postingsEnum.advance(doc) || (postingsEnum = this.strictPhrases.filterPostings(term, postingsEnum, strictPhrasesTermToSpans.get(term))) == null) continue;
                offsetsEnums.add(new OffsetsEnum(term, postingsEnum));
            }
        }
        return offsetsEnums;
    }

    protected OffsetsEnum createOffsetsEnumFromTokenStream(int doc, TokenStream tokenStream) throws IOException {
        assert (tokenStream != null);
        PostingsEnum mtqPostingsEnum = MultiTermHighlighting.getDocsEnum(tokenStream, this.automata);
        assert (mtqPostingsEnum instanceof Closeable);
        mtqPostingsEnum.advance(doc);
        return new OffsetsEnum(null, mtqPostingsEnum);
    }
}

