/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.suggest.document;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.BulkScorer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.CollectionTerminatedException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Weight;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.suggest.document.CompletionQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.suggest.document.TopSuggestDocs;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.suggest.document.TopSuggestDocsCollector;

public class SuggestIndexSearcher
extends IndexSearcher {
    public SuggestIndexSearcher(IndexReader reader) {
        super(reader);
    }

    public TopSuggestDocs suggest(CompletionQuery query, int n) throws IOException {
        TopSuggestDocsCollector collector = new TopSuggestDocsCollector(n);
        this.suggest(query, collector);
        return collector.get();
    }

    public void suggest(CompletionQuery query, TopSuggestDocsCollector collector) throws IOException {
        query = (CompletionQuery)query.rewrite(this.getIndexReader());
        Weight weight = query.createWeight(this, collector.needsScores());
        for (LeafReaderContext context : this.getIndexReader().leaves()) {
            BulkScorer scorer = weight.bulkScorer(context);
            if (scorer == null) continue;
            try {
                scorer.score(collector.getLeafCollector(context), context.reader().getLiveDocs());
            }
            catch (CollectionTerminatedException collectionTerminatedException) {}
        }
    }
}

