/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.spell;

import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.spell.StringDistance;

public class NGramDistance
implements StringDistance {
    private int n;

    public NGramDistance(int size) {
        this.n = size;
    }

    public NGramDistance() {
        this(2);
    }

    @Override
    public float getDistance(String source, String target) {
        int i;
        int sl = source.length();
        int tl = target.length();
        if (sl == 0 || tl == 0) {
            if (sl == tl) {
                return 1.0f;
            }
            return 0.0f;
        }
        int cost = 0;
        if (sl < this.n || tl < this.n) {
            int ni = Math.min(sl, tl);
            for (int i2 = 0; i2 < ni; ++i2) {
                if (source.charAt(i2) != target.charAt(i2)) continue;
                ++cost;
            }
            return (float)cost / (float)Math.max(sl, tl);
        }
        char[] sa = new char[sl + this.n - 1];
        for (i = 0; i < sa.length; ++i) {
            sa[i] = i < this.n - 1 ? (char)'\u0000' : source.charAt(i - this.n + 1);
        }
        float[] p = new float[sl + 1];
        float[] d = new float[sl + 1];
        char[] t_j = new char[this.n];
        for (i = 0; i <= sl; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= tl; ++j) {
            if (j < this.n) {
                int ti;
                for (ti = 0; ti < this.n - j; ++ti) {
                    t_j[ti] = '\u0000';
                }
                for (ti = this.n - j; ti < this.n; ++ti) {
                    t_j[ti] = target.charAt(ti - (this.n - j));
                }
            } else {
                t_j = target.substring(j - this.n, j).toCharArray();
            }
            d[0] = j;
            for (i = 1; i <= sl; ++i) {
                cost = 0;
                int tn = this.n;
                for (int ni = 0; ni < this.n; ++ni) {
                    if (sa[i - 1 + ni] != t_j[ni]) {
                        ++cost;
                        continue;
                    }
                    if (sa[i - 1 + ni] != '\u0000') continue;
                    --tn;
                }
                float ec = (float)cost / (float)tn;
                d[i] = Math.min(Math.min(d[i - 1] + 1.0f, p[i] + 1.0f), p[i - 1] + ec);
            }
            float[] _d = p;
            p = d;
            d = _d;
        }
        return 1.0f - p[sl] / (float)Math.max(tl, sl);
    }

    public int hashCode() {
        return 1427 * this.n * this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        NGramDistance o = (NGramDistance)obj;
        return o.n == this.n;
    }

    public String toString() {
        return "ngram(" + this.n + ")";
    }
}

