/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.similarities;

import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.similarities.BasicStats;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.similarities.Independence;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.similarities.SimilarityBase;

public class DFISimilarity
extends SimilarityBase {
    private final Independence independence;

    public DFISimilarity(Independence independenceMeasure) {
        this.independence = independenceMeasure;
    }

    @Override
    protected float score(BasicStats stats, float freq, float docLen) {
        float expected = (float)(stats.getTotalTermFreq() + 1L) * docLen / (float)(stats.getNumberOfFieldTokens() + 1L);
        if (freq <= expected) {
            return 0.0f;
        }
        float measure = this.independence.score(freq, expected);
        return stats.getBoost() * (float)DFISimilarity.log2(measure + 1.0f);
    }

    public Independence getIndependence() {
        return this.independence;
    }

    @Override
    public String toString() {
        return "DFI(" + this.independence + ")";
    }
}

