/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.highlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.BinaryDocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.FieldInfos;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.Fields;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.FilterLeafReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.NumericDocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SortedDocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.Term;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.memory.MemoryIndex;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.queries.CommonTermsQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.queries.CustomScoreQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.BooleanClause;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.BooleanQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.BoostQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.ConstantScoreQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.MultiPhraseQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.MultiTermQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.PhraseQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.SynonymQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.TermQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.highlight.OffsetLimitTokenFilter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.highlight.PositionSpan;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.highlight.TermVectorLeafReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.highlight.TokenStreamFromTermVector;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.highlight.WeightedSpanTerm;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.join.ToChildBlockJoinQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.join.ToParentBlockJoinQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.spans.FieldMaskingSpanQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.spans.SpanFirstQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.spans.SpanNotQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.spans.SpanQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.spans.SpanWeight;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.spans.Spans;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Bits;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.IOUtils;

public class WeightedSpanTermExtractor {
    private String fieldName;
    private TokenStream tokenStream;
    private String defaultField;
    private boolean expandMultiTermQuery;
    private boolean cachedTokenStream;
    private boolean wrapToCaching = true;
    private int maxDocCharsToAnalyze;
    private boolean usePayloads = false;
    private LeafReader internalReader = null;

    public WeightedSpanTermExtractor() {
    }

    public WeightedSpanTermExtractor(String defaultField) {
        if (defaultField != null) {
            this.defaultField = defaultField;
        }
    }

    protected void extract(Query query, float boost, Map<String, WeightedSpanTerm> terms) throws IOException {
        if (query instanceof BoostQuery) {
            BoostQuery boostQuery = (BoostQuery)query;
            this.extract(boostQuery.getQuery(), boost * boostQuery.getBoost(), terms);
        } else if (query instanceof BooleanQuery) {
            for (BooleanClause clause : (BooleanQuery)query) {
                if (clause.isProhibited()) continue;
                this.extract(clause.getQuery(), boost, terms);
            }
        } else if (query instanceof PhraseQuery) {
            PhraseQuery phraseQuery = (PhraseQuery)query;
            Term[] phraseQueryTerms = phraseQuery.getTerms();
            if (phraseQueryTerms.length == 1) {
                this.extractWeightedSpanTerms(terms, new SpanTermQuery(phraseQueryTerms[0]), boost);
            } else {
                SpanQuery[] clauses = new SpanQuery[phraseQueryTerms.length];
                for (int i = 0; i < phraseQueryTerms.length; ++i) {
                    clauses[i] = new SpanTermQuery(phraseQueryTerms[i]);
                }
                int positionGaps = 0;
                int[] positions = phraseQuery.getPositions();
                if (positions.length >= 2) {
                    positionGaps = Math.max(0, positions[positions.length - 1] - positions[0] - positions.length + 1);
                }
                boolean inorder = phraseQuery.getSlop() == 0;
                SpanNearQuery sp = new SpanNearQuery(clauses, phraseQuery.getSlop() + positionGaps, inorder);
                this.extractWeightedSpanTerms(terms, sp, boost);
            }
        } else if (query instanceof TermQuery || query instanceof SynonymQuery) {
            this.extractWeightedTerms(terms, query, boost);
        } else if (query instanceof SpanQuery) {
            this.extractWeightedSpanTerms(terms, (SpanQuery)query, boost);
        } else if (query instanceof ConstantScoreQuery) {
            Query q = ((ConstantScoreQuery)query).getQuery();
            if (q != null) {
                this.extract(q, boost, terms);
            }
        } else if (query instanceof CommonTermsQuery) {
            this.extractWeightedTerms(terms, query, boost);
        } else if (query instanceof DisjunctionMaxQuery) {
            for (Query clause : (DisjunctionMaxQuery)query) {
                this.extract(clause, boost, terms);
            }
        } else if (query instanceof ToParentBlockJoinQuery) {
            this.extract(((ToParentBlockJoinQuery)query).getChildQuery(), boost, terms);
        } else if (query instanceof ToChildBlockJoinQuery) {
            this.extract(((ToChildBlockJoinQuery)query).getParentQuery(), boost, terms);
        } else if (query instanceof MultiPhraseQuery) {
            MultiPhraseQuery mpq = (MultiPhraseQuery)query;
            Term[][] termArrays = mpq.getTermArrays();
            int[] positions = mpq.getPositions();
            if (positions.length > 0) {
                int maxPosition = positions[positions.length - 1];
                for (int i = 0; i < positions.length - 1; ++i) {
                    if (positions[i] <= maxPosition) continue;
                    maxPosition = positions[i];
                }
                List[] disjunctLists = new List[maxPosition + 1];
                int distinctPositions = 0;
                for (int i = 0; i < termArrays.length; ++i) {
                    Term[] termArray = termArrays[i];
                    ArrayList<SpanTermQuery> disjuncts = disjunctLists[positions[i]];
                    if (disjuncts == null) {
                        ArrayList<SpanTermQuery> arrayList = new ArrayList<SpanTermQuery>(termArray.length);
                        disjunctLists[positions[i]] = arrayList;
                        disjuncts = arrayList;
                        ++distinctPositions;
                    }
                    for (Term aTermArray : termArray) {
                        disjuncts.add(new SpanTermQuery(aTermArray));
                    }
                }
                int positionGaps = 0;
                int position = 0;
                SpanQuery[] clauses = new SpanQuery[distinctPositions];
                for (List disjuncts : disjunctLists) {
                    if (disjuncts != null) {
                        clauses[position++] = new SpanOrQuery(disjuncts.toArray(new SpanQuery[disjuncts.size()]));
                        continue;
                    }
                    ++positionGaps;
                }
                if (clauses.length == 1) {
                    this.extractWeightedSpanTerms(terms, clauses[0], boost);
                } else {
                    int slop = mpq.getSlop();
                    boolean inorder = slop == 0;
                    SpanNearQuery sp = new SpanNearQuery(clauses, slop + positionGaps, inorder);
                    this.extractWeightedSpanTerms(terms, sp, boost);
                }
            }
        } else if (!(query instanceof MatchAllDocsQuery)) {
            if (query instanceof CustomScoreQuery) {
                this.extract(((CustomScoreQuery)query).getSubQuery(), boost, terms);
            } else if (!this.isQueryUnsupported(query.getClass())) {
                if (!(!(query instanceof MultiTermQuery) || this.expandMultiTermQuery && this.fieldNameComparator(((MultiTermQuery)query).getField()))) {
                    return;
                }
                Query origQuery = query;
                LeafReader reader = this.getLeafContext().reader();
                Query rewritten = query instanceof MultiTermQuery ? MultiTermQuery.SCORING_BOOLEAN_REWRITE.rewrite(reader, (MultiTermQuery)query) : origQuery.rewrite(reader);
                if (rewritten != origQuery) {
                    this.extract(rewritten, boost, terms);
                } else {
                    this.extractUnknownQuery(query, terms);
                }
            }
        }
    }

    protected boolean isQueryUnsupported(Class<? extends Query> clazz) {
        if (clazz.getName().startsWith("org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial.")) {
            return true;
        }
        return clazz.getName().startsWith("org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial3d.");
    }

    protected void extractUnknownQuery(Query query, Map<String, WeightedSpanTerm> terms) throws IOException {
    }

    protected void extractWeightedSpanTerms(Map<String, WeightedSpanTerm> terms, SpanQuery spanQuery, float boost) throws IOException {
        HashSet<String> fieldNames;
        if (this.fieldName == null) {
            fieldNames = new HashSet<String>();
            this.collectSpanQueryFields(spanQuery, fieldNames);
        } else {
            fieldNames = new HashSet(1);
            fieldNames.add(this.fieldName);
        }
        if (this.defaultField != null) {
            fieldNames.add(this.defaultField);
        }
        HashMap<String, SpanQuery> queries = new HashMap<String, SpanQuery>();
        HashSet<Term> nonWeightedTerms = new HashSet<Term>();
        boolean mustRewriteQuery = this.mustRewriteQuery(spanQuery);
        IndexSearcher searcher = new IndexSearcher(this.getLeafContext());
        searcher.setQueryCache(null);
        if (mustRewriteQuery) {
            for (String field : fieldNames) {
                SpanQuery rewrittenQuery = (SpanQuery)spanQuery.rewrite(this.getLeafContext().reader());
                queries.put(field, rewrittenQuery);
                rewrittenQuery.createWeight(searcher, false).extractTerms(nonWeightedTerms);
            }
        } else {
            spanQuery.createWeight(searcher, false).extractTerms(nonWeightedTerms);
        }
        ArrayList<PositionSpan> spanPositions = new ArrayList<PositionSpan>();
        for (String field : fieldNames) {
            SpanQuery q = mustRewriteQuery ? (SpanQuery)queries.get(field) : spanQuery;
            LeafReaderContext context = this.getLeafContext();
            SpanWeight w = (SpanWeight)searcher.createNormalizedWeight(q, false);
            Bits acceptDocs = context.reader().getLiveDocs();
            Spans spans = w.getSpans(context, SpanWeight.Postings.POSITIONS);
            if (spans == null) {
                return;
            }
            while (spans.nextDoc() != Integer.MAX_VALUE) {
                if (acceptDocs != null && !acceptDocs.get(spans.docID())) continue;
                while (spans.nextStartPosition() != Integer.MAX_VALUE) {
                    spanPositions.add(new PositionSpan(spans.startPosition(), spans.endPosition() - 1));
                }
            }
        }
        if (spanPositions.size() == 0) {
            return;
        }
        for (Term queryTerm : nonWeightedTerms) {
            if (!this.fieldNameComparator(queryTerm.field())) continue;
            WeightedSpanTerm weightedSpanTerm = terms.get(queryTerm.text());
            if (weightedSpanTerm == null) {
                weightedSpanTerm = new WeightedSpanTerm(boost, queryTerm.text());
                weightedSpanTerm.addPositionSpans(spanPositions);
                weightedSpanTerm.positionSensitive = true;
                terms.put(queryTerm.text(), weightedSpanTerm);
                continue;
            }
            if (spanPositions.size() <= 0) continue;
            weightedSpanTerm.addPositionSpans(spanPositions);
        }
    }

    protected void extractWeightedTerms(Map<String, WeightedSpanTerm> terms, Query query, float boost) throws IOException {
        HashSet<Term> nonWeightedTerms = new HashSet<Term>();
        IndexSearcher searcher = new IndexSearcher(this.getLeafContext());
        searcher.createNormalizedWeight(query, false).extractTerms(nonWeightedTerms);
        for (Term queryTerm : nonWeightedTerms) {
            if (!this.fieldNameComparator(queryTerm.field())) continue;
            WeightedSpanTerm weightedSpanTerm = new WeightedSpanTerm(boost, queryTerm.text());
            terms.put(queryTerm.text(), weightedSpanTerm);
        }
    }

    protected boolean fieldNameComparator(String fieldNameToCheck) {
        boolean rv = this.fieldName == null || this.fieldName.equals(fieldNameToCheck) || this.defaultField != null && this.defaultField.equals(fieldNameToCheck);
        return rv;
    }

    protected LeafReaderContext getLeafContext() throws IOException {
        if (this.internalReader == null) {
            boolean cacheIt;
            boolean bl = cacheIt = this.wrapToCaching && !(this.tokenStream instanceof CachingTokenFilter);
            if (this.tokenStream instanceof TokenStreamFromTermVector) {
                cacheIt = false;
                Terms termVectorTerms = ((TokenStreamFromTermVector)this.tokenStream).getTermVectorTerms();
                if (termVectorTerms.hasPositions() && termVectorTerms.hasOffsets()) {
                    this.internalReader = new TermVectorLeafReader("shadowed_field", termVectorTerms);
                }
            }
            if (this.internalReader == null) {
                MemoryIndex indexer = new MemoryIndex(true, this.usePayloads);
                if (cacheIt) {
                    assert (!this.cachedTokenStream);
                    this.tokenStream = new CachingTokenFilter(new OffsetLimitTokenFilter(this.tokenStream, this.maxDocCharsToAnalyze));
                    this.cachedTokenStream = true;
                    indexer.addField("shadowed_field", this.tokenStream);
                } else {
                    indexer.addField("shadowed_field", new OffsetLimitTokenFilter(this.tokenStream, this.maxDocCharsToAnalyze));
                }
                IndexSearcher searcher = indexer.createSearcher();
                this.internalReader = ((LeafReaderContext)searcher.getTopReaderContext()).reader();
            }
            this.internalReader = new DelegatingLeafReader(this.internalReader);
        }
        return this.internalReader.getContext();
    }

    public Map<String, WeightedSpanTerm> getWeightedSpanTerms(Query query, float boost, TokenStream tokenStream) throws IOException {
        return this.getWeightedSpanTerms(query, boost, tokenStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, WeightedSpanTerm> getWeightedSpanTerms(Query query, float boost, TokenStream tokenStream, String fieldName) throws IOException {
        this.fieldName = fieldName;
        PositionCheckingMap<String> terms = new PositionCheckingMap<String>();
        this.tokenStream = tokenStream;
        try {
            this.extract(query, boost, terms);
        }
        catch (Throwable throwable) {
            IOUtils.close(this.internalReader);
            throw throwable;
        }
        IOUtils.close(this.internalReader);
        return terms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, WeightedSpanTerm> getWeightedSpanTermsWithScores(Query query, float boost, TokenStream tokenStream, String fieldName, IndexReader reader) throws IOException {
        this.fieldName = fieldName != null ? fieldName : null;
        this.tokenStream = tokenStream;
        PositionCheckingMap<String> terms = new PositionCheckingMap<String>();
        this.extract(query, boost, terms);
        int totalNumDocs = reader.maxDoc();
        Set weightedTerms = terms.keySet();
        Iterator it = weightedTerms.iterator();
        try {
            while (it.hasNext()) {
                WeightedSpanTerm weightedSpanTerm = (WeightedSpanTerm)terms.get(it.next());
                int docFreq = reader.docFreq(new Term(fieldName, weightedSpanTerm.term));
                float idf = (float)(Math.log((double)totalNumDocs / (double)(docFreq + 1)) + 1.0);
                weightedSpanTerm.weight *= idf;
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(this.internalReader);
            throw throwable;
        }
        IOUtils.close(this.internalReader);
        return terms;
    }

    protected void collectSpanQueryFields(SpanQuery spanQuery, Set<String> fieldNames) {
        if (spanQuery instanceof FieldMaskingSpanQuery) {
            this.collectSpanQueryFields(((FieldMaskingSpanQuery)spanQuery).getMaskedQuery(), fieldNames);
        } else if (spanQuery instanceof SpanFirstQuery) {
            this.collectSpanQueryFields(((SpanFirstQuery)spanQuery).getMatch(), fieldNames);
        } else if (spanQuery instanceof SpanNearQuery) {
            for (SpanQuery clause : ((SpanNearQuery)spanQuery).getClauses()) {
                this.collectSpanQueryFields(clause, fieldNames);
            }
        } else if (spanQuery instanceof SpanNotQuery) {
            this.collectSpanQueryFields(((SpanNotQuery)spanQuery).getInclude(), fieldNames);
        } else if (spanQuery instanceof SpanOrQuery) {
            for (SpanQuery clause : ((SpanOrQuery)spanQuery).getClauses()) {
                this.collectSpanQueryFields(clause, fieldNames);
            }
        } else {
            fieldNames.add(spanQuery.getField());
        }
    }

    protected boolean mustRewriteQuery(SpanQuery spanQuery) {
        if (!this.expandMultiTermQuery) {
            return false;
        }
        if (spanQuery instanceof FieldMaskingSpanQuery) {
            return this.mustRewriteQuery(((FieldMaskingSpanQuery)spanQuery).getMaskedQuery());
        }
        if (spanQuery instanceof SpanFirstQuery) {
            return this.mustRewriteQuery(((SpanFirstQuery)spanQuery).getMatch());
        }
        if (spanQuery instanceof SpanNearQuery) {
            for (SpanQuery clause : ((SpanNearQuery)spanQuery).getClauses()) {
                if (!this.mustRewriteQuery(clause)) continue;
                return true;
            }
            return false;
        }
        if (spanQuery instanceof SpanNotQuery) {
            SpanNotQuery spanNotQuery = (SpanNotQuery)spanQuery;
            return this.mustRewriteQuery(spanNotQuery.getInclude()) || this.mustRewriteQuery(spanNotQuery.getExclude());
        }
        if (spanQuery instanceof SpanOrQuery) {
            for (SpanQuery clause : ((SpanOrQuery)spanQuery).getClauses()) {
                if (!this.mustRewriteQuery(clause)) continue;
                return true;
            }
            return false;
        }
        return !(spanQuery instanceof SpanTermQuery);
    }

    public boolean getExpandMultiTermQuery() {
        return this.expandMultiTermQuery;
    }

    public void setExpandMultiTermQuery(boolean expandMultiTermQuery) {
        this.expandMultiTermQuery = expandMultiTermQuery;
    }

    public boolean isUsePayloads() {
        return this.usePayloads;
    }

    public void setUsePayloads(boolean usePayloads) {
        this.usePayloads = usePayloads;
    }

    public boolean isCachedTokenStream() {
        return this.cachedTokenStream;
    }

    public TokenStream getTokenStream() {
        assert (this.tokenStream != null);
        return this.tokenStream;
    }

    public void setWrapIfNotCachingTokenFilter(boolean wrap) {
        this.wrapToCaching = wrap;
    }

    protected final void setMaxDocCharsToAnalyze(int maxDocCharsToAnalyze) {
        this.maxDocCharsToAnalyze = maxDocCharsToAnalyze;
    }

    protected static class PositionCheckingMap<K>
    extends HashMap<K, WeightedSpanTerm> {
        protected PositionCheckingMap() {
        }

        @Override
        public void putAll(Map<? extends K, ? extends WeightedSpanTerm> m) {
            for (Map.Entry<K, WeightedSpanTerm> entry : m.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public WeightedSpanTerm put(K key, WeightedSpanTerm value) {
            WeightedSpanTerm prev = super.put(key, value);
            if (prev == null) {
                return prev;
            }
            WeightedSpanTerm prevTerm = prev;
            WeightedSpanTerm newTerm = value;
            if (!prevTerm.positionSensitive) {
                newTerm.positionSensitive = false;
            }
            return prev;
        }
    }

    static final class DelegatingLeafReader
    extends FilterLeafReader {
        private static final String FIELD_NAME = "shadowed_field";

        DelegatingLeafReader(LeafReader in) {
            super(in);
        }

        @Override
        public FieldInfos getFieldInfos() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Fields fields() throws IOException {
            return new FilterLeafReader.FilterFields(super.fields()){

                @Override
                public Terms terms(String field) throws IOException {
                    return super.terms(DelegatingLeafReader.FIELD_NAME);
                }

                @Override
                public Iterator<String> iterator() {
                    return Collections.singletonList(DelegatingLeafReader.FIELD_NAME).iterator();
                }

                @Override
                public int size() {
                    return 1;
                }
            };
        }

        @Override
        public NumericDocValues getNumericDocValues(String field) throws IOException {
            return super.getNumericDocValues(FIELD_NAME);
        }

        @Override
        public BinaryDocValues getBinaryDocValues(String field) throws IOException {
            return super.getBinaryDocValues(FIELD_NAME);
        }

        @Override
        public SortedDocValues getSortedDocValues(String field) throws IOException {
            return super.getSortedDocValues(FIELD_NAME);
        }

        @Override
        public NumericDocValues getNormValues(String field) throws IOException {
            return super.getNormValues(FIELD_NAME);
        }

        @Override
        public Bits getDocsWithField(String field) throws IOException {
            return super.getDocsWithField(FIELD_NAME);
        }
    }
}

