/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.TwoPhaseIterator;

class ReqOptSumScorer
extends Scorer {
    protected final Scorer reqScorer;
    protected final Scorer optScorer;
    protected final DocIdSetIterator optIterator;

    public ReqOptSumScorer(Scorer reqScorer, Scorer optScorer) {
        super(reqScorer.weight);
        assert (reqScorer != null);
        assert (optScorer != null);
        this.reqScorer = reqScorer;
        this.optScorer = optScorer;
        this.optIterator = optScorer.iterator();
    }

    @Override
    public TwoPhaseIterator twoPhaseIterator() {
        return this.reqScorer.twoPhaseIterator();
    }

    @Override
    public DocIdSetIterator iterator() {
        return this.reqScorer.iterator();
    }

    @Override
    public int docID() {
        return this.reqScorer.docID();
    }

    @Override
    public float score() throws IOException {
        int curDoc = this.reqScorer.docID();
        float score = this.reqScorer.score();
        int optScorerDoc = this.optIterator.docID();
        if (optScorerDoc < curDoc) {
            optScorerDoc = this.optIterator.advance(curDoc);
        }
        if (optScorerDoc == curDoc) {
            score += this.optScorer.score();
        }
        return score;
    }

    @Override
    public int freq() throws IOException {
        this.score();
        return this.optIterator.docID() == this.reqScorer.docID() ? 2 : 1;
    }

    @Override
    public Collection<Scorer.ChildScorer> getChildren() {
        ArrayList<Scorer.ChildScorer> children = new ArrayList<Scorer.ChildScorer>(2);
        children.add(new Scorer.ChildScorer(this.reqScorer, "MUST"));
        children.add(new Scorer.ChildScorer(this.optScorer, "SHOULD"));
        return children;
    }
}

