/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.TwoPhaseIterator;

class ReqExclScorer
extends Scorer {
    private final Scorer reqScorer;
    private final DocIdSetIterator reqApproximation;
    private final DocIdSetIterator exclApproximation;
    private final TwoPhaseIterator reqTwoPhaseIterator;
    private final TwoPhaseIterator exclTwoPhaseIterator;
    private static final int ADVANCE_COST = 10;

    public ReqExclScorer(Scorer reqScorer, Scorer exclScorer) {
        super(reqScorer.weight);
        this.reqScorer = reqScorer;
        this.reqTwoPhaseIterator = reqScorer.twoPhaseIterator();
        this.reqApproximation = this.reqTwoPhaseIterator == null ? reqScorer.iterator() : this.reqTwoPhaseIterator.approximation();
        this.exclTwoPhaseIterator = exclScorer.twoPhaseIterator();
        this.exclApproximation = this.exclTwoPhaseIterator == null ? exclScorer.iterator() : this.exclTwoPhaseIterator.approximation();
    }

    private static boolean matchesOrNull(TwoPhaseIterator it) throws IOException {
        return it == null || it.matches();
    }

    @Override
    public DocIdSetIterator iterator() {
        return TwoPhaseIterator.asDocIdSetIterator(this.twoPhaseIterator());
    }

    @Override
    public int docID() {
        return this.reqApproximation.docID();
    }

    @Override
    public int freq() throws IOException {
        return this.reqScorer.freq();
    }

    @Override
    public float score() throws IOException {
        return this.reqScorer.score();
    }

    @Override
    public Collection<Scorer.ChildScorer> getChildren() {
        return Collections.singleton(new Scorer.ChildScorer(this.reqScorer, "MUST"));
    }

    private static float matchCost(DocIdSetIterator reqApproximation, TwoPhaseIterator reqTwoPhaseIterator, DocIdSetIterator exclApproximation, TwoPhaseIterator exclTwoPhaseIterator) {
        float matchCost = 2.0f;
        if (reqTwoPhaseIterator != null) {
            matchCost += reqTwoPhaseIterator.matchCost();
        }
        float exclMatchCost = 10.0f + (exclTwoPhaseIterator == null ? 0.0f : exclTwoPhaseIterator.matchCost());
        float ratio = reqApproximation.cost() <= 0L ? 1.0f : (exclApproximation.cost() <= 0L ? 0.0f : (float)Math.min(reqApproximation.cost(), exclApproximation.cost()) / (float)reqApproximation.cost());
        return matchCost += ratio * exclMatchCost;
    }

    @Override
    public TwoPhaseIterator twoPhaseIterator() {
        final float matchCost = ReqExclScorer.matchCost(this.reqApproximation, this.reqTwoPhaseIterator, this.exclApproximation, this.exclTwoPhaseIterator);
        if (this.reqTwoPhaseIterator == null || this.exclTwoPhaseIterator != null && this.reqTwoPhaseIterator.matchCost() <= this.exclTwoPhaseIterator.matchCost()) {
            return new TwoPhaseIterator(this.reqApproximation){

                @Override
                public boolean matches() throws IOException {
                    int doc = ReqExclScorer.this.reqApproximation.docID();
                    int exclDoc = ReqExclScorer.this.exclApproximation.docID();
                    if (exclDoc < doc) {
                        exclDoc = ReqExclScorer.this.exclApproximation.advance(doc);
                    }
                    if (exclDoc != doc) {
                        return ReqExclScorer.matchesOrNull(ReqExclScorer.this.reqTwoPhaseIterator);
                    }
                    return ReqExclScorer.matchesOrNull(ReqExclScorer.this.reqTwoPhaseIterator) && !ReqExclScorer.matchesOrNull(ReqExclScorer.this.exclTwoPhaseIterator);
                }

                @Override
                public float matchCost() {
                    return matchCost;
                }
            };
        }
        return new TwoPhaseIterator(this.reqApproximation){

            @Override
            public boolean matches() throws IOException {
                int doc = ReqExclScorer.this.reqApproximation.docID();
                int exclDoc = ReqExclScorer.this.exclApproximation.docID();
                if (exclDoc < doc) {
                    exclDoc = ReqExclScorer.this.exclApproximation.advance(doc);
                }
                if (exclDoc != doc) {
                    return ReqExclScorer.matchesOrNull(ReqExclScorer.this.reqTwoPhaseIterator);
                }
                return !ReqExclScorer.matchesOrNull(ReqExclScorer.this.exclTwoPhaseIterator) && ReqExclScorer.matchesOrNull(ReqExclScorer.this.reqTwoPhaseIterator);
            }

            @Override
            public float matchCost() {
                return matchCost;
            }
        };
    }
}

