/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.CollectionTerminatedException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Collector;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.FilterCollector;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.FilterLeafCollector;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.LeafCollector;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Sort;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.SortField;

public class EarlyTerminatingSortingCollector
extends FilterCollector {
    protected final Sort sort;
    protected final int numDocsToCollect;
    private final AtomicBoolean terminatedEarly = new AtomicBoolean(false);

    public static boolean canEarlyTerminate(Sort searchSort, Sort mergePolicySort) {
        SortField[] fields2;
        SortField[] fields1 = searchSort.getSort();
        if (fields1.length > (fields2 = mergePolicySort.getSort()).length) {
            return false;
        }
        return Arrays.asList(fields1).equals(Arrays.asList(fields2).subList(0, fields1.length));
    }

    public EarlyTerminatingSortingCollector(Collector in, Sort sort, int numDocsToCollect) {
        super(in);
        if (numDocsToCollect <= 0) {
            throw new IllegalArgumentException("numDocsToCollect must always be > 0, got " + numDocsToCollect);
        }
        this.sort = sort;
        this.numDocsToCollect = numDocsToCollect;
    }

    @Override
    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        Sort segmentSort = context.reader().getIndexSort();
        if (segmentSort != null && !EarlyTerminatingSortingCollector.canEarlyTerminate(this.sort, segmentSort)) {
            throw new IllegalStateException("Cannot early terminate with sort order " + this.sort + " if segments are sorted with " + segmentSort);
        }
        if (segmentSort != null) {
            return new FilterLeafCollector(super.getLeafCollector(context)){
                private int numCollected;

                @Override
                public void collect(int doc) throws IOException {
                    super.collect(doc);
                    if (++this.numCollected >= EarlyTerminatingSortingCollector.this.numDocsToCollect) {
                        EarlyTerminatingSortingCollector.this.terminatedEarly.set(true);
                        throw new CollectionTerminatedException();
                    }
                }
            };
        }
        return super.getLeafCollector(context);
    }

    public boolean terminatedEarly() {
        return this.terminatedEarly.get();
    }
}

