/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.DocIdSet;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.FilteredDocIdSetIterator;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BitDocIdSet;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Bits;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.FixedBitSet;

public abstract class DocValuesDocIdSet
extends DocIdSet {
    protected final int maxDoc;
    protected final Bits acceptDocs;

    public DocValuesDocIdSet(int maxDoc, Bits acceptDocs) {
        this.maxDoc = maxDoc;
        this.acceptDocs = acceptDocs;
    }

    protected abstract boolean matchDoc(int var1);

    @Override
    public long ramBytesUsed() {
        return 0L;
    }

    @Override
    public final Bits bits() {
        return this.acceptDocs == null ? new Bits(){

            @Override
            public boolean get(int docid) {
                return DocValuesDocIdSet.this.matchDoc(docid);
            }

            @Override
            public int length() {
                return DocValuesDocIdSet.this.maxDoc;
            }
        } : new Bits(){

            @Override
            public boolean get(int docid) {
                return DocValuesDocIdSet.this.acceptDocs.get(docid) && DocValuesDocIdSet.this.matchDoc(docid);
            }

            @Override
            public int length() {
                return DocValuesDocIdSet.this.maxDoc;
            }
        };
    }

    @Override
    public final DocIdSetIterator iterator() throws IOException {
        if (this.acceptDocs == null) {
            return new DocIdSetIterator(){
                private int doc = -1;

                @Override
                public int docID() {
                    return this.doc;
                }

                @Override
                public int nextDoc() {
                    do {
                        ++this.doc;
                        if (this.doc < DocValuesDocIdSet.this.maxDoc) continue;
                        this.doc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    } while (!DocValuesDocIdSet.this.matchDoc(this.doc));
                    return this.doc;
                }

                @Override
                public int advance(int target) {
                    this.doc = target;
                    while (this.doc < DocValuesDocIdSet.this.maxDoc) {
                        if (DocValuesDocIdSet.this.matchDoc(this.doc)) {
                            return this.doc;
                        }
                        ++this.doc;
                    }
                    this.doc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }

                @Override
                public long cost() {
                    return DocValuesDocIdSet.this.maxDoc;
                }
            };
        }
        if (this.acceptDocs instanceof FixedBitSet) {
            return new FilteredDocIdSetIterator(new BitDocIdSet((FixedBitSet)this.acceptDocs).iterator()){

                @Override
                protected boolean match(int doc) {
                    return DocValuesDocIdSet.this.matchDoc(doc);
                }
            };
        }
        return new DocIdSetIterator(){
            private int doc = -1;

            @Override
            public int docID() {
                return this.doc;
            }

            @Override
            public int nextDoc() {
                return this.advance(this.doc + 1);
            }

            @Override
            public int advance(int target) {
                this.doc = target;
                while (this.doc < DocValuesDocIdSet.this.maxDoc) {
                    if (DocValuesDocIdSet.this.acceptDocs.get(this.doc) && DocValuesDocIdSet.this.matchDoc(this.doc)) {
                        return this.doc;
                    }
                    ++this.doc;
                }
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }

            @Override
            public long cost() {
                return DocValuesDocIdSet.this.maxDoc;
            }
        };
    }
}

