/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index;

import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.BinaryDocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SortedDocValuesTermsEnum;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.TermsEnum;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRef;

public abstract class SortedDocValues
extends BinaryDocValues {
    private final BytesRef empty = new BytesRef();

    protected SortedDocValues() {
    }

    public abstract int getOrd(int var1);

    public abstract BytesRef lookupOrd(int var1);

    public abstract int getValueCount();

    @Override
    public BytesRef get(int docID) {
        int ord = this.getOrd(docID);
        if (ord == -1) {
            return this.empty;
        }
        return this.lookupOrd(ord);
    }

    public int lookupTerm(BytesRef key) {
        int low = 0;
        int high = this.getValueCount() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            BytesRef term = this.lookupOrd(mid);
            int cmp = term.compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public TermsEnum termsEnum() {
        return new SortedDocValuesTermsEnum(this);
    }
}

