/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.codecs.Codec;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.codecs.DocValuesFormat;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.codecs.LiveDocsFormat;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.BinaryDocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.BinaryDocValuesFieldUpdates;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.DocValuesFieldUpdates;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.DocValuesType;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.FieldInfo;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.FieldInfos;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexWriter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.NumericDocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.NumericDocValuesFieldUpdates;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SegmentCommitInfo;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SegmentReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SegmentWriteState;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.Directory;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.FlushInfo;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.IOContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.TrackingDirectoryWrapper;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Bits;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.IOUtils;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.MutableBits;

class ReadersAndUpdates {
    public final SegmentCommitInfo info;
    private final AtomicInteger refCount = new AtomicInteger(1);
    private final IndexWriter writer;
    private SegmentReader reader;
    private Bits liveDocs;
    private int pendingDeleteCount;
    private boolean liveDocsShared;
    private boolean isMerging = false;
    private final Map<String, DocValuesFieldUpdates> mergingDVUpdates = new HashMap<String, DocValuesFieldUpdates>();

    public ReadersAndUpdates(IndexWriter writer, SegmentCommitInfo info) {
        this.writer = writer;
        this.info = info;
        this.liveDocsShared = true;
    }

    public ReadersAndUpdates(IndexWriter writer, SegmentReader reader) {
        this.writer = writer;
        this.reader = reader;
        this.info = reader.getSegmentInfo();
        this.liveDocs = reader.getLiveDocs();
        this.liveDocsShared = true;
        this.pendingDeleteCount = reader.numDeletedDocs() - this.info.getDelCount();
        assert (this.pendingDeleteCount >= 0) : "got " + this.pendingDeleteCount + " reader.numDeletedDocs()=" + reader.numDeletedDocs() + " info.getDelCount()=" + this.info.getDelCount() + " maxDoc=" + reader.maxDoc() + " numDocs=" + reader.numDocs();
    }

    public void incRef() {
        int rc = this.refCount.incrementAndGet();
        assert (rc > 1);
    }

    public void decRef() {
        int rc = this.refCount.decrementAndGet();
        assert (rc >= 0);
    }

    public int refCount() {
        int rc = this.refCount.get();
        assert (rc >= 0);
        return rc;
    }

    public synchronized int getPendingDeleteCount() {
        return this.pendingDeleteCount;
    }

    public synchronized boolean verifyDocCounts() {
        int count;
        if (this.liveDocs != null) {
            count = 0;
            for (int docID = 0; docID < this.info.info.maxDoc(); ++docID) {
                if (!this.liveDocs.get(docID)) continue;
                ++count;
            }
        } else {
            count = this.info.info.maxDoc();
        }
        assert (this.info.info.maxDoc() - this.info.getDelCount() - this.pendingDeleteCount == count) : "info.maxDoc=" + this.info.info.maxDoc() + " info.getDelCount()=" + this.info.getDelCount() + " pendingDeleteCount=" + this.pendingDeleteCount + " count=" + count;
        return true;
    }

    public SegmentReader getReader(IOContext context) throws IOException {
        if (this.reader == null) {
            this.reader = new SegmentReader(this.info, context);
            if (this.liveDocs == null) {
                this.liveDocs = this.reader.getLiveDocs();
            }
        }
        this.reader.incRef();
        return this.reader;
    }

    public synchronized void release(SegmentReader sr) throws IOException {
        assert (this.info == sr.getSegmentInfo());
        sr.decRef();
    }

    public synchronized boolean delete(int docID) {
        assert (this.liveDocs != null);
        assert (Thread.holdsLock(this.writer));
        assert (docID >= 0 && docID < this.liveDocs.length()) : "out of bounds: docid=" + docID + " liveDocsLength=" + this.liveDocs.length() + " seg=" + this.info.info.name + " maxDoc=" + this.info.info.maxDoc();
        assert (!this.liveDocsShared);
        boolean didDelete = this.liveDocs.get(docID);
        if (didDelete) {
            ((MutableBits)this.liveDocs).clear(docID);
            ++this.pendingDeleteCount;
        }
        return didDelete;
    }

    public synchronized void dropReaders() throws IOException {
        if (this.reader != null) {
            try {
                this.reader.decRef();
            }
            finally {
                this.reader = null;
            }
        }
        this.decRef();
    }

    public synchronized SegmentReader getReadOnlyClone(IOContext context) throws IOException {
        if (this.reader == null) {
            this.getReader(context).decRef();
            assert (this.reader != null);
        }
        this.liveDocsShared = true;
        if (this.liveDocs != null) {
            return new SegmentReader(this.reader.getSegmentInfo(), this.reader, this.liveDocs, this.info.info.maxDoc() - this.info.getDelCount() - this.pendingDeleteCount);
        }
        assert (this.reader.getLiveDocs() == null);
        this.reader.incRef();
        return this.reader;
    }

    public synchronized void initWritableLiveDocs() throws IOException {
        assert (Thread.holdsLock(this.writer));
        assert (this.info.info.maxDoc() > 0);
        if (this.liveDocsShared) {
            LiveDocsFormat liveDocsFormat = this.info.info.getCodec().liveDocsFormat();
            this.liveDocs = this.liveDocs == null ? liveDocsFormat.newLiveDocs(this.info.info.maxDoc()) : liveDocsFormat.newLiveDocs(this.liveDocs);
            this.liveDocsShared = false;
        }
    }

    public synchronized Bits getLiveDocs() {
        assert (Thread.holdsLock(this.writer));
        return this.liveDocs;
    }

    public synchronized Bits getReadOnlyLiveDocs() {
        assert (Thread.holdsLock(this.writer));
        this.liveDocsShared = true;
        return this.liveDocs;
    }

    public synchronized void dropChanges() {
        this.pendingDeleteCount = 0;
        this.dropMergingUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean writeLiveDocs(Directory dir) throws IOException {
        block8: {
            assert (Thread.holdsLock(this.writer));
            if (this.pendingDeleteCount == 0) {
                return false;
            }
            assert (this.liveDocs.length() == this.info.info.maxDoc());
            TrackingDirectoryWrapper trackingDir = new TrackingDirectoryWrapper(dir);
            boolean success = false;
            try {
                Codec codec = this.info.info.getCodec();
                codec.liveDocsFormat().writeLiveDocs((MutableBits)this.liveDocs, trackingDir, this.info, this.pendingDeleteCount, IOContext.DEFAULT);
                success = true;
                if (success) break block8;
                this.info.advanceNextWriteDelGen();
            }
            catch (Throwable throwable) {
                if (!success) {
                    this.info.advanceNextWriteDelGen();
                    for (String fileName : trackingDir.getCreatedFiles()) {
                        IOUtils.deleteFilesIgnoringExceptions(dir, fileName);
                    }
                }
                throw throwable;
            }
            for (String fileName : trackingDir.getCreatedFiles()) {
                IOUtils.deleteFilesIgnoringExceptions(dir, fileName);
            }
        }
        this.info.advanceDelGen();
        this.info.setDelCount(this.info.getDelCount() + this.pendingDeleteCount);
        this.pendingDeleteCount = 0;
        return true;
    }

    private void handleNumericDVUpdates(FieldInfos infos, Map<String, NumericDocValuesFieldUpdates> updates, Directory dir, DocValuesFormat dvFormat, final SegmentReader reader, Map<Integer, Set<String>> fieldFiles) throws IOException {
        for (Map.Entry<String, NumericDocValuesFieldUpdates> e : updates.entrySet()) {
            final String field = e.getKey();
            final NumericDocValuesFieldUpdates fieldUpdates = e.getValue();
            long nextDocValuesGen = this.info.getNextDocValuesGen();
            String segmentSuffix = Long.toString(nextDocValuesGen, 36);
            long estUpdatesSize = fieldUpdates.ramBytesPerDoc() * (long)this.info.info.maxDoc();
            IOContext updatesContext = new IOContext(new FlushInfo(this.info.info.maxDoc(), estUpdatesSize));
            FieldInfo fieldInfo = infos.fieldInfo(field);
            assert (fieldInfo != null);
            fieldInfo.setDocValuesGen(nextDocValuesGen);
            FieldInfos fieldInfos = new FieldInfos(new FieldInfo[]{fieldInfo});
            TrackingDirectoryWrapper trackingDir = new TrackingDirectoryWrapper(dir);
            SegmentWriteState state = new SegmentWriteState(null, trackingDir, this.info.info, fieldInfos, null, updatesContext, segmentSuffix);
            try (DocValuesConsumer fieldsConsumer = dvFormat.fieldsConsumer(state);){
                fieldsConsumer.addNumericField(fieldInfo, new Iterable<Number>(){
                    final NumericDocValues currentValues;
                    final Bits docsWithField;
                    final int maxDoc;
                    final NumericDocValuesFieldUpdates.Iterator updatesIter;
                    {
                        this.currentValues = reader.getNumericDocValues(field);
                        this.docsWithField = reader.getDocsWithField(field);
                        this.maxDoc = reader.maxDoc();
                        this.updatesIter = fieldUpdates.iterator();
                    }

                    @Override
                    public Iterator<Number> iterator() {
                        this.updatesIter.reset();
                        return new Iterator<Number>(){
                            int curDoc = -1;
                            int updateDoc;
                            {
                                this.updateDoc = updatesIter.nextDoc();
                            }

                            @Override
                            public boolean hasNext() {
                                return this.curDoc < maxDoc - 1;
                            }

                            @Override
                            public Number next() {
                                if (++this.curDoc >= maxDoc) {
                                    throw new NoSuchElementException("no more documents to return values for");
                                }
                                if (this.curDoc == this.updateDoc) {
                                    Long value = updatesIter.value();
                                    this.updateDoc = updatesIter.nextDoc();
                                    return value;
                                }
                                assert (this.curDoc < this.updateDoc);
                                if (currentValues != null && docsWithField.get(this.curDoc)) {
                                    return currentValues.get(this.curDoc);
                                }
                                return null;
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException("this iterator does not support removing elements");
                            }
                        };
                    }
                });
            }
            this.info.advanceDocValuesGen();
            assert (!fieldFiles.containsKey(fieldInfo.number));
            fieldFiles.put(fieldInfo.number, trackingDir.getCreatedFiles());
        }
    }

    private void handleBinaryDVUpdates(FieldInfos infos, Map<String, BinaryDocValuesFieldUpdates> updates, TrackingDirectoryWrapper dir, DocValuesFormat dvFormat, final SegmentReader reader, Map<Integer, Set<String>> fieldFiles) throws IOException {
        for (Map.Entry<String, BinaryDocValuesFieldUpdates> e : updates.entrySet()) {
            final String field = e.getKey();
            final BinaryDocValuesFieldUpdates fieldUpdates = e.getValue();
            long nextDocValuesGen = this.info.getNextDocValuesGen();
            String segmentSuffix = Long.toString(nextDocValuesGen, 36);
            long estUpdatesSize = fieldUpdates.ramBytesPerDoc() * (long)this.info.info.maxDoc();
            IOContext updatesContext = new IOContext(new FlushInfo(this.info.info.maxDoc(), estUpdatesSize));
            FieldInfo fieldInfo = infos.fieldInfo(field);
            assert (fieldInfo != null);
            fieldInfo.setDocValuesGen(nextDocValuesGen);
            FieldInfos fieldInfos = new FieldInfos(new FieldInfo[]{fieldInfo});
            TrackingDirectoryWrapper trackingDir = new TrackingDirectoryWrapper(dir);
            SegmentWriteState state = new SegmentWriteState(null, trackingDir, this.info.info, fieldInfos, null, updatesContext, segmentSuffix);
            try (DocValuesConsumer fieldsConsumer = dvFormat.fieldsConsumer(state);){
                fieldsConsumer.addBinaryField(fieldInfo, new Iterable<BytesRef>(){
                    final BinaryDocValues currentValues;
                    final Bits docsWithField;
                    final int maxDoc;
                    final BinaryDocValuesFieldUpdates.Iterator updatesIter;
                    {
                        this.currentValues = reader.getBinaryDocValues(field);
                        this.docsWithField = reader.getDocsWithField(field);
                        this.maxDoc = reader.maxDoc();
                        this.updatesIter = fieldUpdates.iterator();
                    }

                    @Override
                    public Iterator<BytesRef> iterator() {
                        this.updatesIter.reset();
                        return new Iterator<BytesRef>(){
                            int curDoc = -1;
                            int updateDoc;
                            {
                                this.updateDoc = updatesIter.nextDoc();
                            }

                            @Override
                            public boolean hasNext() {
                                return this.curDoc < maxDoc - 1;
                            }

                            @Override
                            public BytesRef next() {
                                if (++this.curDoc >= maxDoc) {
                                    throw new NoSuchElementException("no more documents to return values for");
                                }
                                if (this.curDoc == this.updateDoc) {
                                    BytesRef value = updatesIter.value();
                                    this.updateDoc = updatesIter.nextDoc();
                                    return value;
                                }
                                assert (this.curDoc < this.updateDoc);
                                if (currentValues != null && docsWithField.get(this.curDoc)) {
                                    return currentValues.get(this.curDoc);
                                }
                                return null;
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException("this iterator does not support removing elements");
                            }
                        };
                    }
                });
            }
            this.info.advanceDocValuesGen();
            assert (!fieldFiles.containsKey(fieldInfo.number));
            fieldFiles.put(fieldInfo.number, trackingDir.getCreatedFiles());
        }
    }

    private Set<String> writeFieldInfosGen(FieldInfos fieldInfos, Directory dir, DocValuesFormat dvFormat, FieldInfosFormat infosFormat) throws IOException {
        long nextFieldInfosGen = this.info.getNextFieldInfosGen();
        String segmentSuffix = Long.toString(nextFieldInfosGen, 36);
        long estInfosSize = 40 + 90 * fieldInfos.size();
        IOContext infosContext = new IOContext(new FlushInfo(this.info.info.maxDoc(), estInfosSize));
        TrackingDirectoryWrapper trackingDir = new TrackingDirectoryWrapper(dir);
        infosFormat.write(trackingDir, this.info.info, segmentSuffix, fieldInfos, infosContext);
        this.info.advanceFieldInfosGen();
        return trackingDir.getCreatedFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeFieldUpdates(Directory dir, DocValuesFieldUpdates.Container dvUpdates) throws IOException {
        Set<String> fieldInfosFiles;
        HashMap<Integer, Set<String>> newDVFiles;
        block29: {
            assert (Thread.holdsLock(this.writer));
            assert (dvUpdates.any());
            TrackingDirectoryWrapper trackingDir = new TrackingDirectoryWrapper(dir);
            newDVFiles = new HashMap<Integer, Set<String>>();
            fieldInfosFiles = null;
            FieldInfos fieldInfos = null;
            boolean success = false;
            try {
                Iterator<Object> codec = this.info.info.getCodec();
                SegmentReader segmentReader = this.reader == null ? new SegmentReader(this.info, IOContext.READONCE) : this.reader;
                try {
                    FieldInfo fieldInfo;
                    FieldInfos.Builder builder = new FieldInfos.Builder(this.writer.globalFieldNumberMap);
                    for (FieldInfo fi : segmentReader.getFieldInfos()) {
                        FieldInfo clone = builder.add(fi);
                        for (Map.Entry<String, String> e : fi.attributes().entrySet()) {
                            clone.putAttribute(e.getKey(), e.getValue());
                        }
                        clone.setDocValuesGen(fi.getDocValuesGen());
                    }
                    for (String f : dvUpdates.numericDVUpdates.keySet()) {
                        fieldInfo = builder.getOrAdd(f);
                        fieldInfo.setDocValuesType(DocValuesType.NUMERIC);
                    }
                    for (String f : dvUpdates.binaryDVUpdates.keySet()) {
                        fieldInfo = builder.getOrAdd(f);
                        fieldInfo.setDocValuesType(DocValuesType.BINARY);
                    }
                    fieldInfos = builder.finish();
                    DocValuesFormat docValuesFormat = ((Codec)((Object)codec)).docValuesFormat();
                    this.handleNumericDVUpdates(fieldInfos, dvUpdates.numericDVUpdates, trackingDir, docValuesFormat, segmentReader, newDVFiles);
                    this.handleBinaryDVUpdates(fieldInfos, dvUpdates.binaryDVUpdates, trackingDir, docValuesFormat, segmentReader, newDVFiles);
                    fieldInfosFiles = this.writeFieldInfosGen(fieldInfos, trackingDir, docValuesFormat, ((Codec)((Object)codec)).fieldInfosFormat());
                }
                finally {
                    if (segmentReader != this.reader) {
                        segmentReader.close();
                    }
                }
                success = true;
                if (success) break block29;
                this.info.advanceNextWriteFieldInfosGen();
                this.info.advanceNextWriteDocValuesGen();
            }
            catch (Throwable throwable) {
                if (!success) {
                    this.info.advanceNextWriteFieldInfosGen();
                    this.info.advanceNextWriteDocValuesGen();
                    for (String fileName : trackingDir.getCreatedFiles()) {
                        IOUtils.deleteFilesIgnoringExceptions(dir, fileName);
                    }
                }
                throw throwable;
            }
            for (String string : trackingDir.getCreatedFiles()) {
                IOUtils.deleteFilesIgnoringExceptions(dir, string);
            }
        }
        if (this.isMerging) {
            DocValuesFieldUpdates updates;
            for (Map.Entry entry : dvUpdates.numericDVUpdates.entrySet()) {
                updates = this.mergingDVUpdates.get(entry.getKey());
                if (updates == null) {
                    this.mergingDVUpdates.put((String)entry.getKey(), (DocValuesFieldUpdates)entry.getValue());
                    continue;
                }
                updates.merge((DocValuesFieldUpdates)entry.getValue());
            }
            for (Map.Entry entry : dvUpdates.binaryDVUpdates.entrySet()) {
                updates = this.mergingDVUpdates.get(entry.getKey());
                if (updates == null) {
                    this.mergingDVUpdates.put((String)entry.getKey(), (DocValuesFieldUpdates)entry.getValue());
                    continue;
                }
                updates.merge((DocValuesFieldUpdates)entry.getValue());
            }
        }
        assert (fieldInfosFiles != null);
        this.info.setFieldInfosFiles(fieldInfosFiles);
        assert (!newDVFiles.isEmpty());
        for (Map.Entry entry : this.info.getDocValuesUpdatesFiles().entrySet()) {
            if (newDVFiles.containsKey(entry.getKey())) continue;
            newDVFiles.put((Integer)entry.getKey(), (Set<String>)entry.getValue());
        }
        this.info.setDocValuesUpdatesFiles(newDVFiles);
        this.writer.checkpoint();
        if (this.reader != null) {
            boolean bl;
            SegmentReader newReader = new SegmentReader(this.info, this.reader, this.liveDocs, this.info.info.maxDoc() - this.info.getDelCount() - this.pendingDeleteCount);
            boolean bl2 = false;
            try {
                this.reader.decRef();
                this.reader = newReader;
                bl = true;
            }
            finally {
                if (!bl) {
                    newReader.decRef();
                }
            }
        }
    }

    synchronized SegmentReader getReaderForMerge(IOContext context) throws IOException {
        assert (Thread.holdsLock(this.writer));
        this.isMerging = true;
        return this.getReader(context);
    }

    public synchronized void dropMergingUpdates() {
        this.mergingDVUpdates.clear();
        this.isMerging = false;
    }

    public synchronized Map<String, DocValuesFieldUpdates> getMergingFieldUpdates() {
        return this.mergingDVUpdates;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ReadersAndLiveDocs(seg=").append(this.info);
        sb.append(" pendingDeleteCount=").append(this.pendingDeleteCount);
        sb.append(" liveDocsShared=").append(this.liveDocsShared);
        return sb.toString();
    }
}

