/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.codecs.lucene62;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.codecs.CodecUtil;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.codecs.SegmentInfoFormat;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.CorruptIndexException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexFileNames;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SegmentInfo;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Sort;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.SortField;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.ChecksumIndexInput;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.Directory;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.IOContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.IndexOutput;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Version;

public class Lucene62SegmentInfoFormat
extends SegmentInfoFormat {
    public static final String SI_EXTENSION = "si";
    static final String CODEC_NAME = "Lucene62SegmentInfo";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SegmentInfo read(Directory dir, String segment, byte[] segmentID, IOContext context) throws IOException {
        String fileName = IndexFileNames.segmentFileName(segment, "", SI_EXTENSION);
        try (ChecksumIndexInput input = dir.openChecksumInput(fileName, context);){
            Throwable priorE = null;
            SegmentInfo si = null;
            try {
                Sort indexSort;
                int format = CodecUtil.checkIndexHeader(input, CODEC_NAME, 0, 0, segmentID, "");
                Version version = Version.fromBits(input.readInt(), input.readInt(), input.readInt());
                int docCount = input.readInt();
                if (docCount < 0) {
                    throw new CorruptIndexException("invalid docCount: " + docCount, input);
                }
                boolean isCompoundFile = input.readByte() == 1;
                Map<String, String> diagnostics = input.readMapOfStrings();
                Set<String> files = input.readSetOfStrings();
                Map<String, String> attributes = input.readMapOfStrings();
                int numSortFields = input.readVInt();
                if (numSortFields > 0) {
                    SortField[] sortFields = new SortField[numSortFields];
                    for (int i = 0; i < numSortFields; ++i) {
                        Object missingValue;
                        boolean reverse;
                        SortField.Type sortType;
                        String fieldName = input.readString();
                        int sortTypeID = input.readVInt();
                        switch (sortTypeID) {
                            case 0: {
                                sortType = SortField.Type.STRING;
                                break;
                            }
                            case 1: {
                                sortType = SortField.Type.LONG;
                                break;
                            }
                            case 2: {
                                sortType = SortField.Type.INT;
                                break;
                            }
                            case 3: {
                                sortType = SortField.Type.DOUBLE;
                                break;
                            }
                            case 4: {
                                sortType = SortField.Type.FLOAT;
                                break;
                            }
                            default: {
                                throw new CorruptIndexException("invalid index sort field type ID: " + sortTypeID, input);
                            }
                        }
                        byte b = input.readByte();
                        if (b == 0) {
                            reverse = true;
                        } else if (b == 1) {
                            reverse = false;
                        } else {
                            throw new CorruptIndexException("invalid index sort reverse: " + b, input);
                        }
                        sortFields[i] = new SortField(fieldName, sortType, reverse);
                        b = input.readByte();
                        if (b == 0) {
                            missingValue = null;
                        } else {
                            switch (sortType) {
                                case STRING: {
                                    if (b == 1) {
                                        missingValue = SortField.STRING_LAST;
                                        break;
                                    }
                                    if (b == 2) {
                                        missingValue = SortField.STRING_FIRST;
                                        break;
                                    }
                                    throw new CorruptIndexException("invalid missing value flag: " + b, input);
                                }
                                case LONG: {
                                    if (b != 1) {
                                        throw new CorruptIndexException("invalid missing value flag: " + b, input);
                                    }
                                    missingValue = input.readLong();
                                    break;
                                }
                                case INT: {
                                    if (b != 1) {
                                        throw new CorruptIndexException("invalid missing value flag: " + b, input);
                                    }
                                    missingValue = input.readInt();
                                    break;
                                }
                                case DOUBLE: {
                                    if (b != 1) {
                                        throw new CorruptIndexException("invalid missing value flag: " + b, input);
                                    }
                                    missingValue = Double.longBitsToDouble(input.readLong());
                                    break;
                                }
                                case FLOAT: {
                                    if (b != 1) {
                                        throw new CorruptIndexException("invalid missing value flag: " + b, input);
                                    }
                                    missingValue = Float.valueOf(Float.intBitsToFloat(input.readInt()));
                                    break;
                                }
                                default: {
                                    throw new AssertionError((Object)("unhandled sortType=" + (Object)((Object)sortType)));
                                }
                            }
                        }
                        if (missingValue == null) continue;
                        sortFields[i].setMissingValue(missingValue);
                    }
                    indexSort = new Sort(sortFields);
                } else {
                    if (numSortFields < 0) {
                        throw new CorruptIndexException("invalid index sort field count: " + numSortFields, input);
                    }
                    indexSort = null;
                }
                si = new SegmentInfo(dir, version, segment, docCount, isCompoundFile, null, diagnostics, segmentID, attributes, indexSort);
                si.setFiles(files);
            }
            catch (Throwable exception) {
                priorE = exception;
            }
            finally {
                CodecUtil.checkFooter(input, priorE);
            }
            SegmentInfo segmentInfo = si;
            return segmentInfo;
        }
    }

    @Override
    public void write(Directory dir, SegmentInfo si, IOContext ioContext) throws IOException {
        String fileName = IndexFileNames.segmentFileName(si.name, "", SI_EXTENSION);
        try (IndexOutput output = dir.createOutput(fileName, ioContext);){
            si.addFile(fileName);
            CodecUtil.writeIndexHeader(output, CODEC_NAME, 0, si.getId(), "");
            Version version = si.getVersion();
            if (version.major < 5) {
                throw new IllegalArgumentException("invalid major version: should be >= 5 but got: " + version.major + " segment=" + si);
            }
            output.writeInt(version.major);
            output.writeInt(version.minor);
            output.writeInt(version.bugfix);
            assert (version.prerelease == 0);
            output.writeInt(si.maxDoc());
            output.writeByte((byte)(si.getUseCompoundFile() ? 1 : -1));
            output.writeMapOfStrings(si.getDiagnostics());
            Set<String> files = si.files();
            for (String file : files) {
                if (IndexFileNames.parseSegmentName(file).equals(si.name)) continue;
                throw new IllegalArgumentException("invalid files: expected segment=" + si.name + ", got=" + files);
            }
            output.writeSetOfStrings(files);
            output.writeMapOfStrings(si.getAttributes());
            Sort indexSort = si.getIndexSort();
            int numSortFields = indexSort == null ? 0 : indexSort.getSort().length;
            output.writeVInt(numSortFields);
            block24: for (int i = 0; i < numSortFields; ++i) {
                int sortTypeID;
                SortField sortField = indexSort.getSort()[i];
                output.writeString(sortField.getField());
                switch (sortField.getType()) {
                    case STRING: {
                        sortTypeID = 0;
                        break;
                    }
                    case LONG: {
                        sortTypeID = 1;
                        break;
                    }
                    case INT: {
                        sortTypeID = 2;
                        break;
                    }
                    case DOUBLE: {
                        sortTypeID = 3;
                        break;
                    }
                    case FLOAT: {
                        sortTypeID = 4;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected sort type: " + (Object)((Object)sortField.getType()));
                    }
                }
                output.writeVInt(sortTypeID);
                output.writeByte((byte)(!sortField.getReverse() ? 1 : 0));
                Object missingValue = sortField.getMissingValue();
                if (missingValue == null) {
                    output.writeByte((byte)0);
                    continue;
                }
                switch (sortField.getType()) {
                    case STRING: {
                        if (missingValue == SortField.STRING_LAST) {
                            output.writeByte((byte)1);
                            continue block24;
                        }
                        if (missingValue == SortField.STRING_FIRST) {
                            output.writeByte((byte)2);
                            continue block24;
                        }
                        throw new AssertionError((Object)("unrecognized missing value for STRING field \"" + sortField.getField() + "\": " + missingValue));
                    }
                    case LONG: {
                        output.writeByte((byte)1);
                        output.writeLong((Long)missingValue);
                        continue block24;
                    }
                    case INT: {
                        output.writeByte((byte)1);
                        output.writeInt((Integer)missingValue);
                        continue block24;
                    }
                    case DOUBLE: {
                        output.writeByte((byte)1);
                        output.writeLong(Double.doubleToLongBits((Double)missingValue));
                        continue block24;
                    }
                    case FLOAT: {
                        output.writeByte((byte)1);
                        output.writeInt(Float.floatToIntBits(((Float)missingValue).floatValue()));
                        continue block24;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected sort type: " + (Object)((Object)sortField.getType()));
                    }
                }
            }
            CodecUtil.writeFooter(output);
        }
    }
}

