/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.Tokenizer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.core.UnicodeWhitespaceTokenizer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.AttributeFactory;

public class WhitespaceTokenizerFactory
extends TokenizerFactory {
    public static final String RULE_JAVA = "java";
    public static final String RULE_UNICODE = "unicode";
    private static final Collection<String> RULE_NAMES = Arrays.asList("java", "unicode");
    private final String rule;

    public WhitespaceTokenizerFactory(Map<String, String> args) {
        super(args);
        this.rule = this.get(args, "rule", RULE_NAMES, RULE_JAVA);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    @Override
    public Tokenizer create(AttributeFactory factory) {
        switch (this.rule) {
            case "java": {
                return new WhitespaceTokenizer(factory);
            }
            case "unicode": {
                return new UnicodeWhitespaceTokenizer(factory);
            }
        }
        throw new AssertionError();
    }
}

