/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.logging.log4j.spi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.logging.log4j.spi.ThreadContextMap;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.logging.log4j.spi.ThreadContextMap2;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.logging.log4j.util.SortedArrayStringMap;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.logging.log4j.util.StringMap;

class GarbageFreeSortedArrayThreadContextMap
implements ThreadContextMap2 {
    public static final String INHERITABLE_MAP = "isThreadContextMapInheritable";
    protected static final int DEFAULT_INITIAL_CAPACITY = 16;
    protected static final String PROPERTY_NAME_INITIAL_CAPACITY = "log4j2.ThreadContext.initial.capacity";
    protected final ThreadLocal<StringMap> localMap = this.createThreadLocalMap();

    private ThreadLocal<StringMap> createThreadLocalMap() {
        PropertiesUtil managerProps = PropertiesUtil.getProperties();
        boolean inheritable = managerProps.getBooleanProperty(INHERITABLE_MAP);
        if (inheritable) {
            return new InheritableThreadLocal<StringMap>(){

                @Override
                protected StringMap childValue(StringMap parentValue) {
                    return parentValue != null ? GarbageFreeSortedArrayThreadContextMap.this.createStringMap(parentValue) : null;
                }
            };
        }
        return new ThreadLocal<StringMap>();
    }

    protected StringMap createStringMap() {
        return new SortedArrayStringMap(PropertiesUtil.getProperties().getIntegerProperty(PROPERTY_NAME_INITIAL_CAPACITY, 16));
    }

    protected StringMap createStringMap(ReadOnlyStringMap original) {
        return new SortedArrayStringMap(original);
    }

    private StringMap getThreadLocalMap() {
        StringMap map = this.localMap.get();
        if (map == null) {
            map = this.createStringMap();
            this.localMap.set(map);
        }
        return map;
    }

    @Override
    public void put(String key, String value) {
        this.getThreadLocalMap().putValue(key, value);
    }

    @Override
    public void putAll(Map<String, String> values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        StringMap map = this.getThreadLocalMap();
        for (Map.Entry<String, String> entry : values.entrySet()) {
            map.putValue(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public String get(String key) {
        StringMap map = this.localMap.get();
        return map == null ? null : (String)map.getValue(key);
    }

    @Override
    public void remove(String key) {
        StringMap map = this.localMap.get();
        if (map != null) {
            map.remove(key);
        }
    }

    @Override
    public void clear() {
        StringMap map = this.localMap.get();
        if (map != null) {
            map.clear();
        }
    }

    @Override
    public boolean containsKey(String key) {
        StringMap map = this.localMap.get();
        return map != null && map.containsKey(key);
    }

    @Override
    public Map<String, String> getCopy() {
        StringMap map = this.localMap.get();
        return map == null ? new HashMap() : map.toMap();
    }

    @Override
    public StringMap getReadOnlyContextData() {
        StringMap map = this.localMap.get();
        if (map == null) {
            map = this.createStringMap();
            this.localMap.set(map);
        }
        return map;
    }

    @Override
    public Map<String, String> getImmutableMapOrNull() {
        StringMap map = this.localMap.get();
        return map == null ? null : Collections.unmodifiableMap(map.toMap());
    }

    @Override
    public boolean isEmpty() {
        StringMap map = this.localMap.get();
        return map == null || map.size() == 0;
    }

    public String toString() {
        StringMap map = this.localMap.get();
        return map == null ? "{}" : map.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        StringMap map = this.localMap.get();
        result = 31 * result + (map == null ? 0 : map.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThreadContextMap)) {
            return false;
        }
        ThreadContextMap other = (ThreadContextMap)obj;
        Map<String, String> map = this.getImmutableMapOrNull();
        Map<String, String> otherMap = other.getImmutableMapOrNull();
        return !(map == null ? otherMap != null : !map.equals(otherMap));
    }
}

