/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.query;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.transport.TransportResponse;

public class ScrollQuerySearchResult
extends TransportResponse {
    private QuerySearchResult queryResult;
    private SearchShardTarget shardTarget;

    public ScrollQuerySearchResult() {
    }

    public ScrollQuerySearchResult(QuerySearchResult queryResult, SearchShardTarget shardTarget) {
        this.queryResult = queryResult;
        this.shardTarget = shardTarget;
    }

    public QuerySearchResult queryResult() {
        return this.queryResult;
    }

    public SearchShardTarget shardTarget() {
        return this.shardTarget;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.shardTarget = new SearchShardTarget(in);
        this.queryResult = QuerySearchResult.readQuerySearchResult(in);
        this.queryResult.shardTarget(this.shardTarget);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.shardTarget.writeTo(out);
        this.queryResult.writeTo(out);
    }
}

