/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.tophits;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.ScoreDoc;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Sort;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.TopDocs;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.TopFieldDocs;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.tophits.TopHits;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.InternalSearchHits;

public class InternalTopHits
extends InternalMetricsAggregation
implements TopHits {
    private int from;
    private int size;
    private TopDocs topDocs;
    private InternalSearchHits searchHits;

    public InternalTopHits(String name, int from, int size, TopDocs topDocs, InternalSearchHits searchHits, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.from = from;
        this.size = size;
        this.topDocs = topDocs;
        this.searchHits = searchHits;
    }

    public InternalTopHits(StreamInput in) throws IOException {
        super(in);
        this.from = in.readVInt();
        this.size = in.readVInt();
        this.topDocs = Lucene.readTopDocs(in);
        assert (this.topDocs != null);
        this.searchHits = InternalSearchHits.readSearchHits(in);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.from);
        out.writeVInt(this.size);
        Lucene.writeTopDocs(out, this.topDocs);
        this.searchHits.writeTo(out);
    }

    @Override
    public String getWriteableName() {
        return "top_hits";
    }

    @Override
    public SearchHits getHits() {
        return this.searchHits;
    }

    @Override
    public InternalAggregation doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        InternalSearchHits[] shardHits = new InternalSearchHits[aggregations.size()];
        try {
            TopDocs reducedTopDocs;
            TopDocs[] shardDocs;
            if (this.topDocs instanceof TopFieldDocs) {
                Sort sort = new Sort(((TopFieldDocs)this.topDocs).fields);
                shardDocs = new TopFieldDocs[aggregations.size()];
                for (int i = 0; i < shardDocs.length; ++i) {
                    InternalTopHits topHitsAgg = (InternalTopHits)aggregations.get(i);
                    shardDocs[i] = (TopFieldDocs)topHitsAgg.topDocs;
                    shardHits[i] = topHitsAgg.searchHits;
                }
                reducedTopDocs = TopDocs.merge(sort, this.from, this.size, (TopFieldDocs[])shardDocs);
            } else {
                shardDocs = new TopDocs[aggregations.size()];
                for (int i = 0; i < shardDocs.length; ++i) {
                    InternalTopHits topHitsAgg = (InternalTopHits)aggregations.get(i);
                    shardDocs[i] = topHitsAgg.topDocs;
                    shardHits[i] = topHitsAgg.searchHits;
                }
                reducedTopDocs = TopDocs.merge(this.from, this.size, shardDocs);
            }
            int[] tracker = new int[shardHits.length];
            InternalSearchHit[] hits = new InternalSearchHit[reducedTopDocs.scoreDocs.length];
            for (int i = 0; i < reducedTopDocs.scoreDocs.length; ++i) {
                int position;
                ScoreDoc scoreDoc = reducedTopDocs.scoreDocs[i];
                do {
                    int n = scoreDoc.shardIndex;
                    tracker[n] = tracker[n] + 1;
                } while (shardDocs[scoreDoc.shardIndex].scoreDocs[position] != scoreDoc);
                hits[i] = (InternalSearchHit)shardHits[scoreDoc.shardIndex].getAt(position);
            }
            return new InternalTopHits(this.name, this.from, this.size, reducedTopDocs, new InternalSearchHits(hits, reducedTopDocs.totalHits, reducedTopDocs.getMaxScore()), this.pipelineAggregators(), this.getMetaData());
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToElastic(e);
        }
    }

    @Override
    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + path);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.searchHits.toXContent(builder, params);
        return builder;
    }
}

