/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.BooleanClause;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.BooleanQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Collector;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Query;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.search.SearchPhase;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.AggregationInitializationException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.BucketCollector;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.global.GlobalAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.SiblingPipelineAggregator;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.profile.query.InternalProfileCollector;
import org.elasticsearch.search.query.QueryPhaseExecutionException;

public class AggregationPhase
implements SearchPhase {
    @Inject
    public AggregationPhase() {
    }

    @Override
    public void preProcess(SearchContext context) {
        if (context.aggregations() != null) {
            ArrayList<Aggregator> collectors = new ArrayList<Aggregator>();
            try {
                AggregatorFactories factories = context.aggregations().factories();
                Aggregator[] aggregators = factories.createTopLevelAggregators();
                for (int i = 0; i < aggregators.length; ++i) {
                    if (aggregators[i] instanceof GlobalAggregator) continue;
                    collectors.add(aggregators[i]);
                }
                context.aggregations().aggregators(aggregators);
                if (!collectors.isEmpty()) {
                    Collector collector = BucketCollector.wrap(collectors);
                    collector.preCollection();
                    if (context.getProfilers() != null) {
                        collector = new InternalProfileCollector(collector, "aggregation", Collections.emptyList());
                    }
                    context.queryCollectors().put(AggregationPhase.class, collector);
                }
            }
            catch (IOException e) {
                throw new AggregationInitializationException("Could not initialize aggregators", e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(SearchContext context) {
        if (context.aggregations() == null) {
            context.queryResult().aggregations(null);
            return;
        }
        if (context.queryResult().aggregations() != null) {
            return;
        }
        Aggregator[] aggregators = context.aggregations().aggregators();
        ArrayList<Aggregator> globals = new ArrayList<Aggregator>();
        for (int i = 0; i < aggregators.length; ++i) {
            if (!(aggregators[i] instanceof GlobalAggregator)) continue;
            globals.add(aggregators[i]);
        }
        if (!globals.isEmpty()) {
            BucketCollector globalsCollector = BucketCollector.wrap(globals);
            Query query = Queries.newMatchAllQuery();
            Query searchFilter = context.searchFilter(context.getQueryShardContext().getTypes());
            if (searchFilter != null) {
                BooleanQuery filtered;
                BooleanQuery booleanQuery = filtered = new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).add(searchFilter, BooleanClause.Occur.FILTER).build();
            }
            try {
                void var5_9;
                Collector collector;
                if (context.getProfilers() == null) {
                    collector = globalsCollector;
                } else {
                    InternalProfileCollector profileCollector = new InternalProfileCollector(globalsCollector, "aggregation_global", Collections.emptyList());
                    collector = profileCollector;
                    context.getProfilers().addQueryProfiler().setCollector(profileCollector);
                }
                globalsCollector.preCollection();
                context.searcher().search((Query)var5_9, collector);
            }
            catch (Exception e) {
                throw new QueryPhaseExecutionException(context, "Failed to execute global aggregators", (Throwable)e);
            }
            finally {
                context.clearReleasables(SearchContext.Lifetime.COLLECTION);
            }
        }
        ArrayList<InternalAggregation> aggregations = new ArrayList<InternalAggregation>(aggregators.length);
        for (Aggregator aggregator : context.aggregations().aggregators()) {
            try {
                aggregator.postCollection();
                aggregations.add(aggregator.buildAggregation(0L));
            }
            catch (IOException e) {
                throw new AggregationExecutionException("Failed to build aggregation [" + aggregator.name() + "]", e);
            }
        }
        context.queryResult().aggregations(new InternalAggregations(aggregations));
        try {
            List<PipelineAggregator> list = context.aggregations().factories().createPipelineAggregators();
            ArrayList<SiblingPipelineAggregator> siblingPipelineAggregators = new ArrayList<SiblingPipelineAggregator>(list.size());
            for (PipelineAggregator pipelineAggregator : list) {
                if (pipelineAggregator instanceof SiblingPipelineAggregator) {
                    siblingPipelineAggregators.add((SiblingPipelineAggregator)pipelineAggregator);
                    continue;
                }
                throw new AggregationExecutionException("Invalid pipeline aggregation named [" + pipelineAggregator.name() + "] of type [" + pipelineAggregator.getWriteableName() + "]. Only sibling pipeline aggregations are allowed at the top level");
            }
            context.queryResult().pipelineAggregators(siblingPipelineAggregators);
        }
        catch (IOException iOException) {
            throw new AggregationExecutionException("Failed to build top level pipeline aggregators", iOException);
        }
        context.aggregations(null);
        context.queryCollectors().remove(AggregationPhase.class);
    }
}

