/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.joptsimple.OptionSet;
import org.elasticsearch.cli.EnvironmentAwareCommand;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.env.Environment;
import org.elasticsearch.plugins.PluginInfo;

class ListPluginsCommand
extends EnvironmentAwareCommand {
    ListPluginsCommand() {
        super("Lists installed elasticsearch plugins");
    }

    @Override
    protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        if (!Files.exists(env.pluginsFile(), new LinkOption[0])) {
            throw new IOException("Plugins directory missing: " + env.pluginsFile());
        }
        terminal.println(Terminal.Verbosity.VERBOSE, "Plugins directory: " + env.pluginsFile());
        ArrayList<Path> plugins = new ArrayList<Path>();
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(env.pluginsFile());){
            for (Path plugin : paths) {
                plugins.add(plugin);
            }
        }
        Collections.sort(plugins);
        for (Path plugin : plugins) {
            terminal.println(plugin.getFileName().toString());
            PluginInfo info = PluginInfo.readFromProperties(env.pluginsFile().resolve(plugin.toAbsolutePath()));
            terminal.println(Terminal.Verbosity.VERBOSE, info.toString());
        }
    }
}

