/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.percolator.PercolateSourceBuilder;

@Deprecated
public class PercolateRequest
extends ActionRequest
implements IndicesRequest.Replaceable {
    protected String[] indices;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpenAndForbidClosed();
    private String documentType;
    private String routing;
    private String preference;
    private boolean onlyCount;
    private GetRequest getRequest;
    private BytesReference source;

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public final PercolateRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public PercolateRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public String documentType() {
        return this.documentType;
    }

    public PercolateRequest documentType(String type) {
        this.documentType = type;
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public PercolateRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    public PercolateRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public GetRequest getRequest() {
        return this.getRequest;
    }

    public PercolateRequest getRequest(GetRequest getRequest) {
        this.getRequest = getRequest;
        return this;
    }

    public BytesReference source() {
        return this.source;
    }

    public PercolateRequest source(Map document) throws ElasticsearchGenerationException {
        return this.source(document, Requests.CONTENT_TYPE);
    }

    public PercolateRequest source(Map document, XContentType contentType) throws ElasticsearchGenerationException {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(contentType);
            builder.map(document);
            return this.source(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + document + "]", e);
        }
    }

    public PercolateRequest source(String document) {
        this.source = new BytesArray(document);
        return this;
    }

    public PercolateRequest source(XContentBuilder documentBuilder) {
        this.source = documentBuilder.bytes();
        return this;
    }

    public PercolateRequest source(byte[] document) {
        return this.source(document, 0, document.length);
    }

    public PercolateRequest source(byte[] source, int offset, int length) {
        return this.source(new BytesArray(source, offset, length));
    }

    public PercolateRequest source(BytesReference source) {
        this.source = source;
        return this;
    }

    public PercolateRequest source(PercolateSourceBuilder sourceBuilder) {
        this.source = sourceBuilder.buildAsBytes(Requests.CONTENT_TYPE);
        return this;
    }

    public boolean onlyCount() {
        return this.onlyCount;
    }

    public PercolateRequest onlyCount(boolean onlyCount) {
        this.onlyCount = onlyCount;
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.documentType == null) {
            validationException = ValidateActions.addValidationError("type is missing", validationException);
        }
        if (this.source == null && this.getRequest == null) {
            validationException = ValidateActions.addValidationError("source or get is missing", validationException);
        }
        if (this.getRequest != null && this.getRequest.storedFields() != null) {
            validationException = ValidateActions.addValidationError("get stored fields option isn't supported via percolate request", validationException);
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.documentType = in.readString();
        this.routing = in.readOptionalString();
        this.preference = in.readOptionalString();
        this.source = in.readBytesReference();
        if (in.readBoolean()) {
            this.getRequest = new GetRequest();
            this.getRequest.readFrom(in);
        }
        this.onlyCount = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        out.writeString(this.documentType);
        out.writeOptionalString(this.routing);
        out.writeOptionalString(this.preference);
        out.writeBytesReference(this.source);
        if (this.getRequest != null) {
            out.writeBoolean(true);
            this.getRequest.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.onlyCount);
    }
}

