/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Locale;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.BooleanClause;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.CollectionUtils;

public enum Operator implements Writeable
{
    OR,
    AND;


    public BooleanClause.Occur toBooleanClauseOccur() {
        switch (this) {
            case OR: {
                return BooleanClause.Occur.SHOULD;
            }
            case AND: {
                return BooleanClause.Occur.MUST;
            }
        }
        throw Operator.newOperatorException(this.toString());
    }

    public QueryParser.Operator toQueryParserOperator() {
        switch (this) {
            case OR: {
                return QueryParser.Operator.OR;
            }
            case AND: {
                return QueryParser.Operator.AND;
            }
        }
        throw Operator.newOperatorException(this.toString());
    }

    public static Operator readFromStream(StreamInput in) throws IOException {
        int ordinal = in.readVInt();
        if (ordinal < 0 || ordinal >= Operator.values().length) {
            throw new IOException("Unknown Operator ordinal [" + ordinal + "]");
        }
        return Operator.values()[ordinal];
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.ordinal());
    }

    public static Operator fromString(String op) {
        return Operator.valueOf(op.toUpperCase(Locale.ROOT));
    }

    private static IllegalArgumentException newOperatorException(String op) {
        return new IllegalArgumentException("operator needs to be either " + CollectionUtils.arrayAsArrayList(Operator.values()) + ", but not [" + op + "]");
    }
}

