/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.ArrayUtil;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.InPlaceMergeSorter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Sorter;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;

public abstract class SortingNumericDoubleValues
extends SortedNumericDoubleValues {
    private int count;
    protected double[] values = new double[1];
    private final Sorter sorter = new InPlaceMergeSorter(){

        @Override
        protected void swap(int i, int j) {
            double tmp = SortingNumericDoubleValues.this.values[i];
            SortingNumericDoubleValues.this.values[i] = SortingNumericDoubleValues.this.values[j];
            SortingNumericDoubleValues.this.values[j] = tmp;
        }

        @Override
        protected int compare(int i, int j) {
            return Double.compare(SortingNumericDoubleValues.this.values[i], SortingNumericDoubleValues.this.values[j]);
        }
    };

    protected SortingNumericDoubleValues() {
    }

    protected final void resize(int newSize) {
        this.count = newSize;
        this.values = ArrayUtil.grow(this.values, this.count);
    }

    protected final void sort() {
        this.sorter.sort(0, this.count);
    }

    @Override
    public final int count() {
        return this.count;
    }

    @Override
    public final double valueAt(int index) {
        return this.values[index];
    }
}

