/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.SetOnce;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.CompositeIndexEventListener;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexingSlowLog;
import org.elasticsearch.index.SearchSlowLog;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.index.cache.query.DisabledQueryCache;
import org.elasticsearch.index.cache.query.IndexQueryCache;
import org.elasticsearch.index.cache.query.QueryCache;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexSearcherWrapper;
import org.elasticsearch.index.shard.IndexingOperationListener;
import org.elasticsearch.index.shard.SearchOperationListener;
import org.elasticsearch.index.similarity.SimilarityProvider;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.index.store.IndexStore;
import org.elasticsearch.index.store.IndexStoreConfig;
import org.elasticsearch.indices.IndicesQueryCache;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.fielddata.cache.IndicesFieldDataCache;
import org.elasticsearch.indices.mapper.MapperRegistry;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;

public final class IndexModule {
    public static final Setting<String> INDEX_STORE_TYPE_SETTING = new Setting("index.store.type", "", Function.identity(), Setting.Property.IndexScope, Setting.Property.NodeScope);
    public static final Setting<List<String>> INDEX_STORE_PRE_LOAD_SETTING = Setting.listSetting("index.store.preload", Collections.emptyList(), Function.identity(), Setting.Property.IndexScope, Setting.Property.NodeScope);
    public static final String SIMILARITY_SETTINGS_PREFIX = "index.similarity";
    public static final Setting<Boolean> INDEX_QUERY_CACHE_ENABLED_SETTING = Setting.boolSetting("index.queries.cache.enabled", true, Setting.Property.IndexScope);
    public static final Setting<Boolean> INDEX_QUERY_CACHE_EVERYTHING_SETTING = Setting.boolSetting("index.queries.cache.everything", false, Setting.Property.IndexScope);
    public static final Setting<Boolean> INDEX_QUERY_CACHE_TERM_QUERIES_SETTING = Setting.boolSetting("index.queries.cache.term_queries", false, Setting.Property.IndexScope);
    private final IndexSettings indexSettings;
    private final IndexStoreConfig indexStoreConfig;
    private final AnalysisRegistry analysisRegistry;
    final SetOnce<EngineFactory> engineFactory = new SetOnce();
    private SetOnce<IndexSearcherWrapperFactory> indexSearcherWrapper = new SetOnce();
    private final Set<IndexEventListener> indexEventListeners = new HashSet<IndexEventListener>();
    private final Map<String, BiFunction<String, Settings, SimilarityProvider>> similarities = new HashMap<String, BiFunction<String, Settings, SimilarityProvider>>();
    private final Map<String, BiFunction<IndexSettings, IndexStoreConfig, IndexStore>> storeTypes = new HashMap<String, BiFunction<IndexSettings, IndexStoreConfig, IndexStore>>();
    private final SetOnce<BiFunction<IndexSettings, IndicesQueryCache, QueryCache>> forceQueryCacheProvider = new SetOnce();
    private final List<SearchOperationListener> searchOperationListeners = new ArrayList<SearchOperationListener>();
    private final List<IndexingOperationListener> indexOperationListeners = new ArrayList<IndexingOperationListener>();
    private final AtomicBoolean frozen = new AtomicBoolean(false);

    public IndexModule(IndexSettings indexSettings, IndexStoreConfig indexStoreConfig, AnalysisRegistry analysisRegistry) {
        this.indexStoreConfig = indexStoreConfig;
        this.indexSettings = indexSettings;
        this.analysisRegistry = analysisRegistry;
        this.searchOperationListeners.add(new SearchSlowLog(indexSettings));
        this.indexOperationListeners.add(new IndexingSlowLog(indexSettings));
    }

    public <T> void addSettingsUpdateConsumer(Setting<T> setting, Consumer<T> consumer) {
        this.ensureNotFrozen();
        if (setting == null) {
            throw new IllegalArgumentException("setting must not be null");
        }
        this.indexSettings.getScopedSettings().addSettingsUpdateConsumer(setting, consumer);
    }

    public <T> void addSettingsUpdateConsumer(Setting<T> setting, Consumer<T> consumer, Consumer<T> validator) {
        this.ensureNotFrozen();
        if (setting == null) {
            throw new IllegalArgumentException("setting must not be null");
        }
        this.indexSettings.getScopedSettings().addSettingsUpdateConsumer(setting, consumer, validator);
    }

    public Settings getSettings() {
        return this.indexSettings.getSettings();
    }

    public Index getIndex() {
        return this.indexSettings.getIndex();
    }

    public void addIndexEventListener(IndexEventListener listener) {
        this.ensureNotFrozen();
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (this.indexEventListeners.contains(listener)) {
            throw new IllegalArgumentException("listener already added");
        }
        this.indexEventListeners.add(listener);
    }

    public void addSearchOperationListener(SearchOperationListener listener) {
        this.ensureNotFrozen();
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (this.searchOperationListeners.contains(listener)) {
            throw new IllegalArgumentException("listener already added");
        }
        this.searchOperationListeners.add(listener);
    }

    public void addIndexOperationListener(IndexingOperationListener listener) {
        this.ensureNotFrozen();
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (this.indexOperationListeners.contains(listener)) {
            throw new IllegalArgumentException("listener already added");
        }
        this.indexOperationListeners.add(listener);
    }

    public void addIndexStore(String type, BiFunction<IndexSettings, IndexStoreConfig, IndexStore> provider) {
        this.ensureNotFrozen();
        if (this.storeTypes.containsKey(type)) {
            throw new IllegalArgumentException("key [" + type + "] already registered");
        }
        this.storeTypes.put(type, provider);
    }

    public void addSimilarity(String name, BiFunction<String, Settings, SimilarityProvider> similarity) {
        this.ensureNotFrozen();
        if (this.similarities.containsKey(name) || SimilarityService.BUILT_IN.containsKey(name)) {
            throw new IllegalArgumentException("similarity for name: [" + name + " is already registered");
        }
        this.similarities.put(name, similarity);
    }

    public void setSearcherWrapper(IndexSearcherWrapperFactory indexSearcherWrapperFactory) {
        this.ensureNotFrozen();
        this.indexSearcherWrapper.set(indexSearcherWrapperFactory);
    }

    IndexEventListener freeze() {
        if (this.frozen.compareAndSet(false, true)) {
            return new CompositeIndexEventListener(this.indexSettings, this.indexEventListeners);
        }
        throw new IllegalStateException("already frozen");
    }

    private static boolean isBuiltinType(String storeType) {
        for (Type type : Type.values()) {
            if (!type.match(storeType)) continue;
            return true;
        }
        return false;
    }

    public IndexService newIndexService(NodeEnvironment environment, NamedXContentRegistry xContentRegistry, IndexService.ShardStoreDeleter shardStoreDeleter, CircuitBreakerService circuitBreakerService, BigArrays bigArrays, ThreadPool threadPool, ScriptService scriptService, ClusterService clusterService, Client client, IndicesQueryCache indicesQueryCache, MapperRegistry mapperRegistry, IndicesFieldDataCache indicesFieldDataCache) throws IOException {
        BiFunction<IndexSettings, IndicesQueryCache, QueryCache> queryCacheProvider;
        IndexStore store;
        IndexEventListener eventListener = this.freeze();
        IndexSearcherWrapperFactory searcherWrapperFactory = this.indexSearcherWrapper.get() == null ? shard -> null : this.indexSearcherWrapper.get();
        eventListener.beforeIndexCreated(this.indexSettings.getIndex(), this.indexSettings.getSettings());
        String storeType = this.indexSettings.getValue(INDEX_STORE_TYPE_SETTING);
        if (Strings.isEmpty(storeType) || IndexModule.isBuiltinType(storeType)) {
            store = new IndexStore(this.indexSettings, this.indexStoreConfig);
        } else {
            BiFunction<IndexSettings, IndexStoreConfig, IndexStore> factory = this.storeTypes.get(storeType);
            if (factory == null) {
                throw new IllegalArgumentException("Unknown store type [" + storeType + "]");
            }
            store = factory.apply(this.indexSettings, this.indexStoreConfig);
            if (store == null) {
                throw new IllegalStateException("store must not be null");
            }
        }
        this.indexSettings.getScopedSettings().addSettingsUpdateConsumer(IndexStore.INDEX_STORE_THROTTLE_TYPE_SETTING, store::setType);
        this.indexSettings.getScopedSettings().addSettingsUpdateConsumer(IndexStore.INDEX_STORE_THROTTLE_MAX_BYTES_PER_SEC_SETTING, store::setMaxRate);
        QueryCache queryCache = this.indexSettings.getValue(INDEX_QUERY_CACHE_ENABLED_SETTING).booleanValue() ? ((queryCacheProvider = this.forceQueryCacheProvider.get()) == null ? new IndexQueryCache(this.indexSettings, indicesQueryCache) : queryCacheProvider.apply(this.indexSettings, indicesQueryCache)) : new DisabledQueryCache(this.indexSettings);
        return new IndexService(this.indexSettings, environment, xContentRegistry, new SimilarityService(this.indexSettings, this.similarities), shardStoreDeleter, this.analysisRegistry, this.engineFactory.get(), circuitBreakerService, bigArrays, threadPool, scriptService, clusterService, client, queryCache, store, eventListener, searcherWrapperFactory, mapperRegistry, indicesFieldDataCache, this.searchOperationListeners, this.indexOperationListeners);
    }

    public MapperService newIndexMapperService(NamedXContentRegistry xContentRegistry, MapperRegistry mapperRegistry) throws IOException {
        return new MapperService(this.indexSettings, this.analysisRegistry.build(this.indexSettings), xContentRegistry, new SimilarityService(this.indexSettings, this.similarities), mapperRegistry, () -> {
            throw new UnsupportedOperationException("no index query shard context available");
        });
    }

    public void forceQueryCacheProvider(BiFunction<IndexSettings, IndicesQueryCache, QueryCache> queryCacheProvider) {
        this.ensureNotFrozen();
        this.forceQueryCacheProvider.set(queryCacheProvider);
    }

    private void ensureNotFrozen() {
        if (this.frozen.get()) {
            throw new IllegalStateException("Can't modify IndexModule once the index service has been created");
        }
    }

    public static interface IndexSearcherWrapperFactory {
        public IndexSearcherWrapper newWrapper(IndexService var1);
    }

    public static enum Type {
        NIOFS,
        MMAPFS,
        SIMPLEFS,
        FS,
        DEFAULT;


        public String getSettingsKey() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public boolean match(String setting) {
            return this.getSettingsKey().equals(setting);
        }
    }
}

