/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.ArrayUtils;

public abstract class SecureSetting<T>
extends Setting<T> {
    private static final Set<Setting.Property> ALLOWED_PROPERTIES = new HashSet<Setting.Property>(Arrays.asList(Setting.Property.Deprecated, Setting.Property.Shared));
    private static final Setting.Property[] FIXED_PROPERTIES = new Setting.Property[]{Setting.Property.NodeScope};
    private static final Setting.Property[] LEGACY_PROPERTIES = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Deprecated, Setting.Property.Filtered};

    private SecureSetting(String key, Setting.Property ... properties) {
        super(key, (String)null, null, ArrayUtils.concat(properties, FIXED_PROPERTIES, Setting.Property.class));
        assert (this.assertAllowedProperties(properties));
    }

    private boolean assertAllowedProperties(Setting.Property ... properties) {
        for (Setting.Property property : properties) {
            if (ALLOWED_PROPERTIES.contains((Object)property)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getDefaultRaw(Settings settings) {
        throw new UnsupportedOperationException("secure settings are not strings");
    }

    @Override
    public T getDefault(Settings settings) {
        throw new UnsupportedOperationException("secure settings are not strings");
    }

    @Override
    public String getRaw(Settings settings) {
        throw new UnsupportedOperationException("secure settings are not strings");
    }

    @Override
    public boolean exists(Settings settings) {
        SecureSettings secureSettings = settings.getSecureSettings();
        return secureSettings != null && secureSettings.getSettingNames().contains(this.getKey());
    }

    @Override
    public T get(Settings settings) {
        this.checkDeprecation(settings);
        SecureSettings secureSettings = settings.getSecureSettings();
        if (secureSettings == null || !secureSettings.getSettingNames().contains(this.getKey())) {
            return this.getFallback(settings);
        }
        try {
            return this.getSecret(secureSettings);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("failed to read secure setting " + this.getKey(), e);
        }
    }

    abstract T getSecret(SecureSettings var1) throws GeneralSecurityException;

    abstract T getFallback(Settings var1);

    public static Setting<SecureString> secureString(String name, final Setting<SecureString> fallback, boolean allowLegacy, Setting.Property ... properties) {
        Setting<String> legacy;
        if (allowLegacy) {
            Setting.Property[] legacyProperties = ArrayUtils.concat(properties, LEGACY_PROPERTIES, Setting.Property.class);
            legacy = Setting.simpleString(name, legacyProperties);
        } else {
            legacy = null;
        }
        return new SecureSetting<SecureString>(name, properties){

            @Override
            protected SecureString getSecret(SecureSettings secureSettings) throws GeneralSecurityException {
                return secureSettings.getString(this.getKey());
            }

            @Override
            SecureString getFallback(Settings settings) {
                if (legacy != null && legacy.exists(settings)) {
                    return new SecureString(((String)legacy.get(settings)).toCharArray());
                }
                if (fallback != null) {
                    return (SecureString)fallback.get(settings);
                }
                return new SecureString(new char[0]);
            }

            @Override
            protected void checkDeprecation(Settings settings) {
                super.checkDeprecation(settings);
                if (legacy != null) {
                    legacy.checkDeprecation(settings);
                }
            }

            @Override
            public boolean exists(Settings settings) {
                return super.exists(settings) || legacy != null && legacy.exists(settings);
            }
        };
    }
}

