/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.FastStringReader;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;

public class Strings {
    public static final String[] EMPTY_ARRAY = new String[0];
    private static final String FOLDER_SEPARATOR = "/";
    private static final String WINDOWS_FOLDER_SEPARATOR = "\\";
    private static final String TOP_PATH = "src/test";
    private static final String CURRENT_PATH = ".";
    public static final Set<Character> INVALID_FILENAME_CHARS = Collections.unmodifiableSet(Sets.newHashSet(Character.valueOf('\\'), Character.valueOf('/'), Character.valueOf('*'), Character.valueOf('?'), Character.valueOf('\"'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('|'), Character.valueOf(' '), Character.valueOf(',')));

    public static void spaceify(int spaces, String from, StringBuilder to) throws Exception {
        try (BufferedReader reader = new BufferedReader(new FastStringReader(from));){
            String line;
            while ((line = reader.readLine()) != null) {
                for (int i = 0; i < spaces; ++i) {
                    to.append(' ');
                }
                to.append(line).append('\n');
            }
        }
    }

    public static List<String> splitSmart(String s, String separator, boolean decode) {
        ArrayList<String> lst = new ArrayList<String>(2);
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int end = s.length();
        while (pos < end) {
            int ch;
            if (s.startsWith(separator, pos)) {
                if (sb.length() > 0) {
                    lst.add(sb.toString());
                    sb = new StringBuilder();
                }
                pos += separator.length();
                continue;
            }
            if ((ch = s.charAt(pos++)) == 92) {
                if (!decode) {
                    sb.append((char)ch);
                }
                if (pos >= end) break;
                ch = s.charAt(pos++);
                if (decode) {
                    switch (ch) {
                        case 110: {
                            ch = 10;
                            break;
                        }
                        case 116: {
                            ch = 9;
                            break;
                        }
                        case 114: {
                            ch = 13;
                            break;
                        }
                        case 98: {
                            ch = 8;
                            break;
                        }
                        case 102: {
                            ch = 12;
                        }
                    }
                }
            }
            sb.append((char)ch);
        }
        if (sb.length() > 0) {
            lst.add(sb.toString());
        }
        return lst;
    }

    public static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static boolean hasLength(BytesReference bytesReference) {
        return bytesReference != null && bytesReference.length() > 0;
    }

    public static boolean hasLength(String str) {
        return Strings.hasLength((CharSequence)str);
    }

    public static boolean isEmpty(CharSequence str) {
        return !Strings.hasLength(str);
    }

    public static boolean hasText(CharSequence str) {
        if (!Strings.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasText(String str) {
        return Strings.hasText((CharSequence)str);
    }

    public static String trimLeadingCharacter(String str, char leadingCharacter) {
        if (!Strings.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && sb.charAt(0) == leadingCharacter) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public static boolean substringMatch(CharSequence str, int index, CharSequence substring) {
        for (int j = 0; j < substring.length(); ++j) {
            int i = index + j;
            if (i < str.length() && str.charAt(i) == substring.charAt(j)) continue;
            return false;
        }
        return true;
    }

    public static int countOccurrencesOf(String str, String sub) {
        int idx;
        if (str == null || sub == null || str.length() == 0 || sub.length() == 0) {
            return 0;
        }
        int count = 0;
        int pos = 0;
        while ((idx = str.indexOf(sub, pos)) != -1) {
            ++count;
            pos = idx + sub.length();
        }
        return count;
    }

    public static String replace(String inString, String oldPattern, String newPattern) {
        if (!Strings.hasLength(inString) || !Strings.hasLength(oldPattern) || newPattern == null) {
            return inString;
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int index = inString.indexOf(oldPattern);
        int patLen = oldPattern.length();
        while (index >= 0) {
            sb.append(inString.substring(pos, index));
            sb.append(newPattern);
            pos = index + patLen;
            index = inString.indexOf(oldPattern, pos);
        }
        sb.append(inString.substring(pos));
        return sb.toString();
    }

    public static String delete(String inString, String pattern) {
        return Strings.replace(inString, pattern, "");
    }

    public static String deleteAny(String inString, String charsToDelete) {
        if (!Strings.hasLength(inString) || !Strings.hasLength(charsToDelete)) {
            return inString;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < inString.length(); ++i) {
            char c = inString.charAt(i);
            if (charsToDelete.indexOf(c) != -1) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String quote(String str) {
        return str != null ? "'" + str + "'" : null;
    }

    public static String capitalize(String str) {
        return Strings.changeFirstCharacterCase(str, true);
    }

    private static String changeFirstCharacterCase(String str, boolean capitalize) {
        if (str == null || str.length() == 0) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str.length());
        if (capitalize) {
            sb.append(Character.toUpperCase(str.charAt(0)));
        } else {
            sb.append(Character.toLowerCase(str.charAt(0)));
        }
        sb.append(str.substring(1));
        return sb.toString();
    }

    public static boolean validFileName(String fileName) {
        for (int i = 0; i < fileName.length(); ++i) {
            char c = fileName.charAt(i);
            if (!INVALID_FILENAME_CHARS.contains(Character.valueOf(c))) continue;
            return false;
        }
        return true;
    }

    public static boolean validFileNameExcludingAstrix(String fileName) {
        for (int i = 0; i < fileName.length(); ++i) {
            char c = fileName.charAt(i);
            if (c == '*' || !INVALID_FILENAME_CHARS.contains(Character.valueOf(c))) continue;
            return false;
        }
        return true;
    }

    public static String cleanPath(String path) {
        int i;
        if (path == null) {
            return null;
        }
        String pathToUse = Strings.replace(path, WINDOWS_FOLDER_SEPARATOR, FOLDER_SEPARATOR);
        int prefixIndex = pathToUse.indexOf(":");
        String prefix = "";
        if (prefixIndex != -1) {
            prefix = pathToUse.substring(0, prefixIndex + 1);
            pathToUse = pathToUse.substring(prefixIndex + 1);
        }
        if (pathToUse.startsWith(FOLDER_SEPARATOR)) {
            prefix = prefix + FOLDER_SEPARATOR;
            pathToUse = pathToUse.substring(1);
        }
        String[] pathArray = Strings.delimitedListToStringArray(pathToUse, FOLDER_SEPARATOR);
        LinkedList<String> pathElements = new LinkedList<String>();
        int tops = 0;
        for (i = pathArray.length - 1; i >= 0; --i) {
            String element = pathArray[i];
            if (CURRENT_PATH.equals(element)) continue;
            if (TOP_PATH.equals(element)) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.add(0, element);
        }
        for (i = 0; i < tops; ++i) {
            pathElements.add(0, TOP_PATH);
        }
        return prefix + Strings.collectionToDelimitedString(pathElements, FOLDER_SEPARATOR);
    }

    public static String[] toStringArray(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new String[collection.size()]);
    }

    public static Set<String> splitStringByCommaToSet(String s) {
        return Strings.splitStringToSet(s, ',');
    }

    public static String[] splitStringByCommaToArray(String s) {
        if (s == null || s.isEmpty()) {
            return EMPTY_ARRAY;
        }
        return s.split(",");
    }

    public static Set<String> splitStringToSet(String s, char c) {
        int size;
        if (s == null || s.isEmpty()) {
            return Collections.emptySet();
        }
        char[] chars = s.toCharArray();
        int count = 1;
        for (char x : chars) {
            if (x != c) continue;
            ++count;
        }
        HashSet<String> result = new HashSet<String>(count);
        int len = chars.length;
        int start = 0;
        int end = 0;
        for (int pos = 0; pos < len; ++pos) {
            if (chars[pos] == c) {
                size = end - start;
                if (size > 0) {
                    result.add(new String(chars, start, size));
                }
                end = start = pos + 1;
                continue;
            }
            if (Character.isWhitespace(chars[pos])) {
                if (start != pos) continue;
                ++start;
                continue;
            }
            end = pos + 1;
        }
        size = end - start;
        if (size > 0) {
            result.add(new String(chars, start, size));
        }
        return result;
    }

    public static String[] split(String toSplit, String delimiter) {
        if (!Strings.hasLength(toSplit) || !Strings.hasLength(delimiter)) {
            return null;
        }
        int offset = toSplit.indexOf(delimiter);
        if (offset < 0) {
            return null;
        }
        String beforeDelimiter = toSplit.substring(0, offset);
        String afterDelimiter = toSplit.substring(offset + delimiter.length());
        return new String[]{beforeDelimiter, afterDelimiter};
    }

    public static String[] tokenizeToStringArray(String str, String delimiters) {
        return Strings.tokenizeToStringArray(str, delimiters, true, true);
    }

    public static String[] tokenizeToStringArray(String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (str == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return Strings.toStringArray(tokens);
    }

    public static String[] delimitedListToStringArray(String str, String delimiter) {
        return Strings.delimitedListToStringArray(str, delimiter, null);
    }

    public static String[] delimitedListToStringArray(String str, String delimiter, String charsToDelete) {
        if (str == null) {
            return new String[0];
        }
        if (delimiter == null) {
            return new String[]{str};
        }
        ArrayList<String> result = new ArrayList<String>();
        if ("".equals(delimiter)) {
            for (int i = 0; i < str.length(); ++i) {
                result.add(Strings.deleteAny(str.substring(i, i + 1), charsToDelete));
            }
        } else {
            int delPos;
            int pos = 0;
            while ((delPos = str.indexOf(delimiter, pos)) != -1) {
                result.add(Strings.deleteAny(str.substring(pos, delPos), charsToDelete));
                pos = delPos + delimiter.length();
            }
            if (str.length() > 0 && pos <= str.length()) {
                result.add(Strings.deleteAny(str.substring(pos), charsToDelete));
            }
        }
        return Strings.toStringArray(result);
    }

    public static String[] commaDelimitedListToStringArray(String str) {
        return Strings.delimitedListToStringArray(str, ",");
    }

    public static Set<String> commaDelimitedListToSet(String str) {
        TreeSet<String> set = new TreeSet<String>();
        String[] tokens = Strings.commaDelimitedListToStringArray(str);
        set.addAll(Arrays.asList(tokens));
        return set;
    }

    public static String collectionToDelimitedString(Iterable<?> coll, String delim, String prefix, String suffix) {
        return Strings.collectionToDelimitedString(coll, delim, prefix, suffix, new StringBuilder());
    }

    public static String collectionToDelimitedString(Iterable<?> coll, String delim, String prefix, String suffix, StringBuilder sb) {
        Iterator<?> it = coll.iterator();
        while (it.hasNext()) {
            sb.append(prefix).append(it.next()).append(suffix);
            if (!it.hasNext()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static String collectionToDelimitedString(Iterable<?> coll, String delim) {
        return Strings.collectionToDelimitedString(coll, delim, "", "");
    }

    public static String collectionToCommaDelimitedString(Iterable<?> coll) {
        return Strings.collectionToDelimitedString(coll, ",");
    }

    public static String arrayToDelimitedString(Object[] arr, String delim) {
        return Strings.arrayToDelimitedString(arr, delim, new StringBuilder());
    }

    public static String arrayToDelimitedString(Object[] arr, String delim, StringBuilder sb) {
        if (Strings.isEmpty(arr)) {
            return "";
        }
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                sb.append(delim);
            }
            sb.append(arr[i]);
        }
        return sb.toString();
    }

    public static String arrayToCommaDelimitedString(Object[] arr) {
        return Strings.arrayToDelimitedString(arr, ",");
    }

    public static String format1Decimals(double value, String suffix) {
        String p = String.valueOf(value);
        int ix = p.indexOf(46) + 1;
        int ex = p.indexOf(69);
        char fraction = p.charAt(ix);
        if (fraction == '0') {
            if (ex != -1) {
                return p.substring(0, ix - 1) + p.substring(ex) + suffix;
            }
            return p.substring(0, ix - 1) + suffix;
        }
        if (ex != -1) {
            return p.substring(0, ix) + fraction + p.substring(ex) + suffix;
        }
        return p.substring(0, ix) + fraction + suffix;
    }

    private static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    private Strings() {
    }

    public static byte[] toUTF8Bytes(CharSequence charSequence) {
        return Strings.toUTF8Bytes(charSequence, new BytesRefBuilder());
    }

    public static byte[] toUTF8Bytes(CharSequence charSequence, BytesRefBuilder spare) {
        spare.copyChars(charSequence);
        return Arrays.copyOf(spare.bytes(), spare.length());
    }

    public static String substring(String s, int beginIndex, int endIndex) {
        int realEndIndex;
        if (s == null) {
            return s;
        }
        int n = realEndIndex = s.length() > 0 ? s.length() - 1 : 0;
        if (endIndex > realEndIndex) {
            return s.substring(beginIndex);
        }
        return s.substring(beginIndex, endIndex);
    }

    public static boolean isAllOrWildcard(String[] data) {
        return CollectionUtils.isEmpty(data) || data.length == 1 && ("_all".equals(data[0]) || "*".equals(data[0]));
    }

    public static String toString(ToXContent toXContent) {
        try {
            XContentBuilder builder = JsonXContent.contentBuilder();
            if (toXContent.isFragment()) {
                builder.startObject();
            }
            toXContent.toXContent(builder, ToXContent.EMPTY_PARAMS);
            if (toXContent.isFragment()) {
                builder.endObject();
            }
            return builder.string();
        }
        catch (IOException e) {
            return "Error building toString out of XContent: " + ExceptionsHelper.stackTrace(e);
        }
    }

    public static String cleanTruncate(String s, int length) {
        if (s == null) {
            return s;
        }
        if (length == 0) {
            return "";
        }
        if (length >= s.length()) {
            return s;
        }
        if (Character.isHighSurrogate(s.charAt(length - 1))) {
            --length;
        }
        return s.substring(0, length);
    }

    public static boolean isNullOrEmpty(@Nullable String s) {
        return s == null || s.isEmpty();
    }

    public static String coalesceToEmpty(@Nullable String s) {
        return s == null ? "" : s;
    }

    public static String padStart(String s, int minimumLength, char c) {
        if (s == null) {
            throw new NullPointerException("s");
        }
        if (s.length() >= minimumLength) {
            return s;
        }
        StringBuilder sb = new StringBuilder(minimumLength);
        for (int i = s.length(); i < minimumLength; ++i) {
            sb.append(c);
        }
        sb.append(s);
        return sb.toString();
    }
}

