/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.nio.file.Path;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.bootstrap.ConsoleCtrlHandler;
import org.elasticsearch.bootstrap.JNANatives;
import org.elasticsearch.common.logging.Loggers;

final class Natives {
    private static final Logger logger = Loggers.getLogger(Natives.class);
    static final boolean JNA_AVAILABLE;

    private Natives() {
    }

    static void tryMlockall() {
        if (!JNA_AVAILABLE) {
            logger.warn("cannot mlockall because JNA is not available");
            return;
        }
        JNANatives.tryMlockall();
    }

    static boolean definitelyRunningAsRoot() {
        if (!JNA_AVAILABLE) {
            logger.warn("cannot check if running as root because JNA is not available");
            return false;
        }
        return JNANatives.definitelyRunningAsRoot();
    }

    static void tryVirtualLock() {
        if (!JNA_AVAILABLE) {
            logger.warn("cannot mlockall because JNA is not available");
            return;
        }
        JNANatives.tryVirtualLock();
    }

    static void addConsoleCtrlHandler(ConsoleCtrlHandler handler) {
        if (!JNA_AVAILABLE) {
            logger.warn("cannot register console handler because JNA is not available");
            return;
        }
        JNANatives.addConsoleCtrlHandler(handler);
    }

    static boolean isMemoryLocked() {
        if (!JNA_AVAILABLE) {
            return false;
        }
        return JNANatives.LOCAL_MLOCKALL;
    }

    static void tryInstallSystemCallFilter(Path tmpFile) {
        if (!JNA_AVAILABLE) {
            logger.warn("cannot install system call filter because JNA is not available");
            return;
        }
        JNANatives.tryInstallSystemCallFilter(tmpFile);
    }

    static void trySetMaxNumberOfThreads() {
        if (!JNA_AVAILABLE) {
            logger.warn("cannot getrlimit RLIMIT_NPROC because JNA is not available");
            return;
        }
        JNANatives.trySetMaxNumberOfThreads();
    }

    static void trySetMaxSizeVirtualMemory() {
        if (!JNA_AVAILABLE) {
            logger.warn("cannot getrlimit RLIMIT_AS beacuse JNA is not available");
            return;
        }
        JNANatives.trySetMaxSizeVirtualMemory();
    }

    static boolean isSystemCallFilterInstalled() {
        if (!JNA_AVAILABLE) {
            return false;
        }
        return JNANatives.LOCAL_SYSTEM_CALL_FILTER;
    }

    static {
        boolean v = false;
        try {
            Class.forName("org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.sun.jna.Native");
            v = true;
        }
        catch (ClassNotFoundException e) {
            logger.warn("JNA not found. native methods will be disabled.", (Throwable)e);
        }
        catch (UnsatisfiedLinkError e) {
            logger.warn("unable to load JNA native support library, native methods will be disabled.", (Throwable)e);
        }
        JNA_AVAILABLE = v;
    }
}

