/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.RealtimeRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;

public class MultiGetRequest
extends ActionRequest
implements Iterable<Item>,
CompositeIndicesRequest,
RealtimeRequest {
    String preference;
    boolean realtime = true;
    boolean refresh;
    List<Item> items = new ArrayList<Item>();

    public List<Item> getItems() {
        return this.items;
    }

    public MultiGetRequest add(Item item) {
        this.items.add(item);
        return this;
    }

    public MultiGetRequest add(String index, @Nullable String type, String id) {
        this.items.add(new Item(index, type, id));
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.items.isEmpty()) {
            validationException = ValidateActions.addValidationError("no documents to get", validationException);
        } else {
            for (int i = 0; i < this.items.size(); ++i) {
                Item item = this.items.get(i);
                if (item.index() == null) {
                    validationException = ValidateActions.addValidationError("index is missing for doc " + i, validationException);
                }
                if (item.id() != null) continue;
                validationException = ValidateActions.addValidationError("id is missing for doc " + i, validationException);
            }
        }
        return validationException;
    }

    public MultiGetRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    public boolean realtime() {
        return this.realtime;
    }

    public MultiGetRequest realtime(boolean realtime) {
        this.realtime = realtime;
        return this;
    }

    public boolean refresh() {
        return this.refresh;
    }

    public MultiGetRequest refresh(boolean refresh) {
        this.refresh = refresh;
        return this;
    }

    public MultiGetRequest add(@Nullable String defaultIndex, @Nullable String defaultType, @Nullable String[] defaultFields, @Nullable FetchSourceContext defaultFetchSource, @Nullable String defaultRouting, XContentParser parser, boolean allowExplicitIndex) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token != XContentParser.Token.START_ARRAY) continue;
            if ("docs".equals(currentFieldName)) {
                MultiGetRequest.parseDocuments(parser, this.items, defaultIndex, defaultType, defaultFields, defaultFetchSource, defaultRouting, allowExplicitIndex);
                continue;
            }
            if (!"ids".equals(currentFieldName)) continue;
            MultiGetRequest.parseIds(parser, this.items, defaultIndex, defaultType, defaultFields, defaultFetchSource, defaultRouting);
        }
        return this;
    }

    public static void parseDocuments(XContentParser parser, List<Item> items, @Nullable String defaultIndex, @Nullable String defaultType, @Nullable String[] defaultFields, @Nullable FetchSourceContext defaultFetchSource, @Nullable String defaultRouting, boolean allowExplicitIndex) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            if (token != XContentParser.Token.START_OBJECT) {
                throw new IllegalArgumentException("docs array element should include an object");
            }
            String index = defaultIndex;
            String type = defaultType;
            String id = null;
            String routing = defaultRouting;
            String parent = null;
            ArrayList<String> storedFields = null;
            long version = -3L;
            VersionType versionType = VersionType.INTERNAL;
            FetchSourceContext fetchSourceContext = FetchSourceContext.FETCH_SOURCE;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if ("_index".equals(currentFieldName)) {
                        if (!allowExplicitIndex) {
                            throw new IllegalArgumentException("explicit index in multi get is not allowed");
                        }
                        index = parser.text();
                        continue;
                    }
                    if ("_type".equals(currentFieldName)) {
                        type = parser.text();
                        continue;
                    }
                    if ("_id".equals(currentFieldName)) {
                        id = parser.text();
                        continue;
                    }
                    if ("_routing".equals(currentFieldName) || "routing".equals(currentFieldName)) {
                        routing = parser.text();
                        continue;
                    }
                    if ("_parent".equals(currentFieldName) || "parent".equals(currentFieldName)) {
                        parent = parser.text();
                        continue;
                    }
                    if ("fields".equals(currentFieldName)) {
                        throw new ParsingException(parser.getTokenLocation(), "Unsupported field [fields] used, expected [stored_fields] instead", new Object[0]);
                    }
                    if ("stored_fields".equals(currentFieldName)) {
                        storedFields = new ArrayList();
                        storedFields.add(parser.text());
                        continue;
                    }
                    if ("_version".equals(currentFieldName) || "version".equals(currentFieldName)) {
                        version = parser.longValue();
                        continue;
                    }
                    if ("_version_type".equals(currentFieldName) || "_versionType".equals(currentFieldName) || "version_type".equals(currentFieldName) || "versionType".equals(currentFieldName)) {
                        versionType = VersionType.fromString(parser.text());
                        continue;
                    }
                    if (!"_source".equals(currentFieldName)) continue;
                    if (parser.isBooleanValue()) {
                        fetchSourceContext = new FetchSourceContext(parser.booleanValue(), fetchSourceContext.includes(), fetchSourceContext.excludes());
                        continue;
                    }
                    if (token == XContentParser.Token.VALUE_STRING) {
                        fetchSourceContext = new FetchSourceContext(fetchSourceContext.fetchSource(), new String[]{parser.text()}, fetchSourceContext.excludes());
                        continue;
                    }
                    throw new ElasticsearchParseException("illegal type for _source: [{}]", new Object[]{token});
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if ("fields".equals(currentFieldName)) {
                        throw new ParsingException(parser.getTokenLocation(), "Unsupported field [fields] used, expected [stored_fields] instead", new Object[0]);
                    }
                    if ("stored_fields".equals(currentFieldName)) {
                        storedFields = new ArrayList<String>();
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            storedFields.add(parser.text());
                        }
                        continue;
                    }
                    if (!"_source".equals(currentFieldName)) continue;
                    ArrayList<String> includes = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        includes.add(parser.text());
                    }
                    fetchSourceContext = new FetchSourceContext(fetchSourceContext.fetchSource(), includes.toArray(Strings.EMPTY_ARRAY), fetchSourceContext.excludes());
                    continue;
                }
                if (token != XContentParser.Token.START_OBJECT || !"_source".equals(currentFieldName)) continue;
                List currentList = null;
                ArrayList includes = null;
                ArrayList excludes = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        if ("includes".equals(currentFieldName) || "include".equals(currentFieldName)) {
                            currentList = includes != null ? includes : new ArrayList(2);
                            continue;
                        }
                        if ("excludes".equals(currentFieldName) || "exclude".equals(currentFieldName)) {
                            currentList = excludes != null ? excludes : new ArrayList(2);
                            continue;
                        }
                        throw new ElasticsearchParseException("source definition may not contain [{}]", parser.text());
                    }
                    if (token == XContentParser.Token.START_ARRAY) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            currentList.add(parser.text());
                        }
                        continue;
                    }
                    if (token.isValue()) {
                        currentList.add(parser.text());
                        continue;
                    }
                    throw new ElasticsearchParseException("unexpected token while parsing source settings", new Object[0]);
                }
                fetchSourceContext = new FetchSourceContext(fetchSourceContext.fetchSource(), includes == null ? Strings.EMPTY_ARRAY : includes.toArray(new String[includes.size()]), excludes == null ? Strings.EMPTY_ARRAY : excludes.toArray(new String[excludes.size()]));
            }
            String[] aFields = storedFields != null ? storedFields.toArray(new String[storedFields.size()]) : defaultFields;
            items.add(new Item(index, type, id).routing(routing).storedFields(aFields).parent(parent).version(version).versionType(versionType).fetchSourceContext(fetchSourceContext == FetchSourceContext.FETCH_SOURCE ? defaultFetchSource : fetchSourceContext));
        }
    }

    public static void parseDocuments(XContentParser parser, List<Item> items) throws IOException {
        MultiGetRequest.parseDocuments(parser, items, null, null, null, null, null, true);
    }

    public static void parseIds(XContentParser parser, List<Item> items, @Nullable String defaultIndex, @Nullable String defaultType, @Nullable String[] defaultFields, @Nullable FetchSourceContext defaultFetchSource, @Nullable String defaultRouting) throws IOException {
        XContentParser.Token token;
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            if (!token.isValue()) {
                throw new IllegalArgumentException("ids array element should only contain ids");
            }
            items.add(new Item(defaultIndex, defaultType, parser.text()).storedFields(defaultFields).fetchSourceContext(defaultFetchSource).routing(defaultRouting));
        }
    }

    public static void parseIds(XContentParser parser, List<Item> items) throws IOException {
        MultiGetRequest.parseIds(parser, items, null, null, null, null, null);
    }

    @Override
    public Iterator<Item> iterator() {
        return Collections.unmodifiableCollection(this.items).iterator();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.preference = in.readOptionalString();
        this.refresh = in.readBoolean();
        this.realtime = in.readBoolean();
        int size = in.readVInt();
        this.items = new ArrayList<Item>(size);
        for (int i = 0; i < size; ++i) {
            this.items.add(Item.readItem(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.preference);
        out.writeBoolean(this.refresh);
        out.writeBoolean(this.realtime);
        out.writeVInt(this.items.size());
        for (Item item : this.items) {
            item.writeTo(out);
        }
    }

    public static class Item
    implements Streamable,
    IndicesRequest {
        private String index;
        private String type;
        private String id;
        private String routing;
        private String parent;
        private String[] storedFields;
        private long version = -3L;
        private VersionType versionType = VersionType.INTERNAL;
        private FetchSourceContext fetchSourceContext;

        public Item() {
        }

        public Item(String index, @Nullable String type, String id) {
            this.index = index;
            this.type = type;
            this.id = id;
        }

        public String index() {
            return this.index;
        }

        @Override
        public String[] indices() {
            return new String[]{this.index};
        }

        @Override
        public IndicesOptions indicesOptions() {
            return GetRequest.INDICES_OPTIONS;
        }

        public Item index(String index) {
            this.index = index;
            return this;
        }

        public String type() {
            return this.type;
        }

        public Item type(String type) {
            this.type = type;
            return this;
        }

        public String id() {
            return this.id;
        }

        public Item routing(String routing) {
            this.routing = routing;
            return this;
        }

        public String routing() {
            return this.routing;
        }

        public Item parent(String parent) {
            this.parent = parent;
            return this;
        }

        public String parent() {
            return this.parent;
        }

        public Item storedFields(String ... fields) {
            this.storedFields = fields;
            return this;
        }

        public String[] storedFields() {
            return this.storedFields;
        }

        public long version() {
            return this.version;
        }

        public Item version(long version) {
            this.version = version;
            return this;
        }

        public VersionType versionType() {
            return this.versionType;
        }

        public Item versionType(VersionType versionType) {
            this.versionType = versionType;
            return this;
        }

        public FetchSourceContext fetchSourceContext() {
            return this.fetchSourceContext;
        }

        public Item fetchSourceContext(FetchSourceContext fetchSourceContext) {
            this.fetchSourceContext = fetchSourceContext;
            return this;
        }

        public static Item readItem(StreamInput in) throws IOException {
            Item item = new Item();
            item.readFrom(in);
            return item;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.index = in.readString();
            this.type = in.readOptionalString();
            this.id = in.readString();
            this.routing = in.readOptionalString();
            this.parent = in.readOptionalString();
            this.storedFields = in.readOptionalStringArray();
            this.version = in.readLong();
            this.versionType = VersionType.fromValue(in.readByte());
            this.fetchSourceContext = in.readOptionalWriteable(FetchSourceContext::new);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.index);
            out.writeOptionalString(this.type);
            out.writeString(this.id);
            out.writeOptionalString(this.routing);
            out.writeOptionalString(this.parent);
            out.writeOptionalStringArray(this.storedFields);
            out.writeLong(this.version);
            out.writeByte(this.versionType.getValue());
            out.writeOptionalWriteable(this.fetchSourceContext);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Item)) {
                return false;
            }
            Item item = (Item)o;
            if (this.version != item.version) {
                return false;
            }
            if (this.fetchSourceContext != null ? !this.fetchSourceContext.equals(item.fetchSourceContext) : item.fetchSourceContext != null) {
                return false;
            }
            if (!Arrays.equals(this.storedFields, item.storedFields)) {
                return false;
            }
            if (!this.id.equals(item.id)) {
                return false;
            }
            if (!this.index.equals(item.index)) {
                return false;
            }
            if (this.routing != null ? !this.routing.equals(item.routing) : item.routing != null) {
                return false;
            }
            if (this.parent != null ? !this.parent.equals(item.parent) : item.parent != null) {
                return false;
            }
            if (this.type != null ? !this.type.equals(item.type) : item.type != null) {
                return false;
            }
            return this.versionType == item.versionType;
        }

        public int hashCode() {
            int result = this.index.hashCode();
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            result = 31 * result + this.id.hashCode();
            result = 31 * result + (this.routing != null ? this.routing.hashCode() : 0);
            result = 31 * result + (this.parent != null ? this.parent.hashCode() : 0);
            result = 31 * result + (this.storedFields != null ? Arrays.hashCode(this.storedFields) : 0);
            result = 31 * result + Long.hashCode(this.version);
            result = 31 * result + this.versionType.hashCode();
            result = 31 * result + (this.fetchSourceContext != null ? this.fetchSourceContext.hashCode() : 0);
            return result;
        }
    }
}

