/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Accountable;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Constants;

public final class RamUsageEstimator {
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    public static final long ONE_GB = 0x40000000L;
    @Deprecated
    public static final int NUM_BYTES_BOOLEAN = 1;
    @Deprecated
    public static final int NUM_BYTES_BYTE = 1;
    @Deprecated
    public static final int NUM_BYTES_CHAR = 2;
    @Deprecated
    public static final int NUM_BYTES_SHORT = 2;
    @Deprecated
    public static final int NUM_BYTES_INT = 4;
    @Deprecated
    public static final int NUM_BYTES_FLOAT = 4;
    @Deprecated
    public static final int NUM_BYTES_LONG = 8;
    @Deprecated
    public static final int NUM_BYTES_DOUBLE = 8;
    public static final boolean COMPRESSED_REFS_ENABLED;
    public static final int NUM_BYTES_OBJECT_REF;
    public static final int NUM_BYTES_OBJECT_HEADER;
    public static final int NUM_BYTES_ARRAY_HEADER;
    public static final int NUM_BYTES_OBJECT_ALIGNMENT;
    private static final Map<Class<?>, Integer> primitiveSizes;
    static final long LONG_CACHE_MIN_VALUE;
    static final long LONG_CACHE_MAX_VALUE;
    static final int LONG_SIZE;
    static final boolean JVM_IS_HOTSPOT_64BIT;
    static final String MANAGEMENT_FACTORY_CLASS = "java.lang.management.ManagementFactory";
    static final String HOTSPOT_BEAN_CLASS = "org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.sun.management.HotSpotDiagnosticMXBean";

    private RamUsageEstimator() {
    }

    public static long alignObjectSize(long size) {
        return (size += (long)NUM_BYTES_OBJECT_ALIGNMENT - 1L) - size % (long)NUM_BYTES_OBJECT_ALIGNMENT;
    }

    public static long sizeOf(Long value) {
        if (value >= LONG_CACHE_MIN_VALUE && value <= LONG_CACHE_MAX_VALUE) {
            return 0L;
        }
        return LONG_SIZE;
    }

    public static long sizeOf(byte[] arr) {
        return RamUsageEstimator.alignObjectSize((long)NUM_BYTES_ARRAY_HEADER + (long)arr.length);
    }

    public static long sizeOf(boolean[] arr) {
        return RamUsageEstimator.alignObjectSize((long)NUM_BYTES_ARRAY_HEADER + (long)arr.length);
    }

    public static long sizeOf(char[] arr) {
        return RamUsageEstimator.alignObjectSize((long)NUM_BYTES_ARRAY_HEADER + 2L * (long)arr.length);
    }

    public static long sizeOf(short[] arr) {
        return RamUsageEstimator.alignObjectSize((long)NUM_BYTES_ARRAY_HEADER + 2L * (long)arr.length);
    }

    public static long sizeOf(int[] arr) {
        return RamUsageEstimator.alignObjectSize((long)NUM_BYTES_ARRAY_HEADER + 4L * (long)arr.length);
    }

    public static long sizeOf(float[] arr) {
        return RamUsageEstimator.alignObjectSize((long)NUM_BYTES_ARRAY_HEADER + 4L * (long)arr.length);
    }

    public static long sizeOf(long[] arr) {
        return RamUsageEstimator.alignObjectSize((long)NUM_BYTES_ARRAY_HEADER + 8L * (long)arr.length);
    }

    public static long sizeOf(double[] arr) {
        return RamUsageEstimator.alignObjectSize((long)NUM_BYTES_ARRAY_HEADER + 8L * (long)arr.length);
    }

    public static long shallowSizeOf(Object[] arr) {
        return RamUsageEstimator.alignObjectSize((long)NUM_BYTES_ARRAY_HEADER + (long)NUM_BYTES_OBJECT_REF * (long)arr.length);
    }

    public static long shallowSizeOf(Object obj) {
        if (obj == null) {
            return 0L;
        }
        Class<?> clz = obj.getClass();
        if (clz.isArray()) {
            return RamUsageEstimator.shallowSizeOfArray(obj);
        }
        return RamUsageEstimator.shallowSizeOfInstance(clz);
    }

    public static long shallowSizeOfInstance(Class<?> clazz) {
        if (clazz.isArray()) {
            throw new IllegalArgumentException("This method does not work with array classes.");
        }
        if (clazz.isPrimitive()) {
            return primitiveSizes.get(clazz).intValue();
        }
        long size = NUM_BYTES_OBJECT_HEADER;
        while (clazz != null) {
            Field[] fields;
            final Class<?> target = clazz;
            for (Field f : fields = AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

                @Override
                public Field[] run() {
                    return target.getDeclaredFields();
                }
            })) {
                if (Modifier.isStatic(f.getModifiers())) continue;
                size = RamUsageEstimator.adjustForField(size, f);
            }
            clazz = clazz.getSuperclass();
        }
        return RamUsageEstimator.alignObjectSize(size);
    }

    private static long shallowSizeOfArray(Object array) {
        long size = NUM_BYTES_ARRAY_HEADER;
        int len = Array.getLength(array);
        if (len > 0) {
            Class<?> arrayElementClazz = array.getClass().getComponentType();
            size = arrayElementClazz.isPrimitive() ? (size += (long)len * (long)primitiveSizes.get(arrayElementClazz).intValue()) : (size += (long)NUM_BYTES_OBJECT_REF * (long)len);
        }
        return RamUsageEstimator.alignObjectSize(size);
    }

    static long adjustForField(long sizeSoFar, Field f) {
        Class<?> type = f.getType();
        int fsize = type.isPrimitive() ? primitiveSizes.get(type) : NUM_BYTES_OBJECT_REF;
        return sizeSoFar + (long)fsize;
    }

    public static String humanReadableUnits(long bytes) {
        return RamUsageEstimator.humanReadableUnits(bytes, new DecimalFormat("0.#", DecimalFormatSymbols.getInstance(Locale.ROOT)));
    }

    public static String humanReadableUnits(long bytes, DecimalFormat df) {
        if (bytes / 0x40000000L > 0L) {
            return df.format((float)bytes / 1.0737418E9f) + " GB";
        }
        if (bytes / 0x100000L > 0L) {
            return df.format((float)bytes / 1048576.0f) + " MB";
        }
        if (bytes / 1024L > 0L) {
            return df.format((float)bytes / 1024.0f) + " KB";
        }
        return bytes + " bytes";
    }

    public static long sizeOf(Accountable[] accountables) {
        long size = RamUsageEstimator.shallowSizeOf(accountables);
        for (Accountable accountable : accountables) {
            if (accountable == null) continue;
            size += accountable.ramBytesUsed();
        }
        return size;
    }

    static {
        long longCacheMaxValue;
        long longCacheMinValue;
        primitiveSizes = new IdentityHashMap();
        primitiveSizes.put(Boolean.TYPE, 1);
        primitiveSizes.put(Byte.TYPE, 1);
        primitiveSizes.put(Character.TYPE, 2);
        primitiveSizes.put(Short.TYPE, 2);
        primitiveSizes.put(Integer.TYPE, 4);
        primitiveSizes.put(Float.TYPE, 4);
        primitiveSizes.put(Double.TYPE, 8);
        primitiveSizes.put(Long.TYPE, 8);
        if (Constants.JRE_IS_64BIT) {
            boolean isHotspot;
            int objectAlignment;
            boolean compressedOops;
            block10: {
                compressedOops = false;
                objectAlignment = 8;
                isHotspot = false;
                try {
                    Object vmOption;
                    Class<?> beanClazz = Class.forName(HOTSPOT_BEAN_CLASS);
                    Object hotSpotBean = Class.forName(MANAGEMENT_FACTORY_CLASS).getMethod("getPlatformMXBean", Class.class).invoke(null, beanClazz);
                    if (hotSpotBean == null) break block10;
                    isHotspot = true;
                    Method getVMOptionMethod = beanClazz.getMethod("getVMOption", String.class);
                    try {
                        vmOption = getVMOptionMethod.invoke(hotSpotBean, "UseCompressedOops");
                        compressedOops = Boolean.parseBoolean(vmOption.getClass().getMethod("getValue", new Class[0]).invoke(vmOption, new Object[0]).toString());
                    }
                    catch (ReflectiveOperationException | RuntimeException e) {
                        isHotspot = false;
                    }
                    try {
                        vmOption = getVMOptionMethod.invoke(hotSpotBean, "ObjectAlignmentInBytes");
                        objectAlignment = Integer.parseInt(vmOption.getClass().getMethod("getValue", new Class[0]).invoke(vmOption, new Object[0]).toString());
                    }
                    catch (ReflectiveOperationException | RuntimeException e) {
                        isHotspot = false;
                    }
                }
                catch (ReflectiveOperationException | RuntimeException e) {
                    isHotspot = false;
                }
            }
            JVM_IS_HOTSPOT_64BIT = isHotspot;
            COMPRESSED_REFS_ENABLED = compressedOops;
            NUM_BYTES_OBJECT_ALIGNMENT = objectAlignment;
            NUM_BYTES_OBJECT_REF = COMPRESSED_REFS_ENABLED ? 4 : 8;
            NUM_BYTES_OBJECT_HEADER = 8 + NUM_BYTES_OBJECT_REF;
            NUM_BYTES_ARRAY_HEADER = (int)RamUsageEstimator.alignObjectSize(NUM_BYTES_OBJECT_HEADER + 4);
        } else {
            JVM_IS_HOTSPOT_64BIT = false;
            COMPRESSED_REFS_ENABLED = false;
            NUM_BYTES_OBJECT_ALIGNMENT = 8;
            NUM_BYTES_OBJECT_REF = 4;
            NUM_BYTES_OBJECT_HEADER = 8;
            NUM_BYTES_ARRAY_HEADER = NUM_BYTES_OBJECT_HEADER + 4;
        }
        for (longCacheMinValue = 0L; longCacheMinValue > Long.MIN_VALUE && Long.valueOf(longCacheMinValue - 1L) == Long.valueOf(longCacheMinValue - 1L); --longCacheMinValue) {
        }
        for (longCacheMaxValue = -1L; longCacheMaxValue < Long.MAX_VALUE && Long.valueOf(longCacheMaxValue + 1L) == Long.valueOf(longCacheMaxValue + 1L); ++longCacheMaxValue) {
        }
        LONG_CACHE_MIN_VALUE = longCacheMinValue;
        LONG_CACHE_MAX_VALUE = longCacheMaxValue;
        LONG_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(Long.class);
    }
}

