/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.suggest;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.document.Document;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexableField;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.MultiDocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.MultiFields;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.NumericDocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.spell.Dictionary;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.suggest.InputIterator;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Bits;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRef;

public class DocumentDictionary
implements Dictionary {
    protected final IndexReader reader;
    protected final String payloadField;
    protected final String contextsField;
    private final String field;
    private final String weightField;

    public DocumentDictionary(IndexReader reader, String field, String weightField) {
        this(reader, field, weightField, null);
    }

    public DocumentDictionary(IndexReader reader, String field, String weightField, String payloadField) {
        this(reader, field, weightField, payloadField, null);
    }

    public DocumentDictionary(IndexReader reader, String field, String weightField, String payloadField, String contextsField) {
        this.reader = reader;
        this.field = field;
        this.weightField = weightField;
        this.payloadField = payloadField;
        this.contextsField = contextsField;
    }

    @Override
    public InputIterator getEntryIterator() throws IOException {
        return new DocumentInputIterator(this.payloadField != null, this.contextsField != null);
    }

    protected class DocumentInputIterator
    implements InputIterator {
        private final int docCount;
        private final Set<String> relevantFields;
        private final boolean hasPayloads;
        private final boolean hasContexts;
        private final Bits liveDocs;
        private int currentDocId = -1;
        private long currentWeight = 0L;
        private BytesRef currentPayload = null;
        private Set<BytesRef> currentContexts;
        private final NumericDocValues weightValues;
        IndexableField[] currentDocFields = new IndexableField[0];
        int nextFieldsPosition = 0;

        public DocumentInputIterator(boolean hasPayloads, boolean hasContexts) throws IOException {
            this.hasPayloads = hasPayloads;
            this.hasContexts = hasContexts;
            this.docCount = DocumentDictionary.this.reader.maxDoc() - 1;
            this.weightValues = DocumentDictionary.this.weightField != null ? MultiDocValues.getNumericValues(DocumentDictionary.this.reader, DocumentDictionary.this.weightField) : null;
            this.liveDocs = DocumentDictionary.this.reader.leaves().size() > 0 ? MultiFields.getLiveDocs(DocumentDictionary.this.reader) : null;
            this.relevantFields = this.getRelevantFields(DocumentDictionary.this.field, DocumentDictionary.this.weightField, DocumentDictionary.this.payloadField, DocumentDictionary.this.contextsField);
        }

        @Override
        public long weight() {
            return this.currentWeight;
        }

        @Override
        public BytesRef next() throws IOException {
            block14: {
                BytesRef tempTerm;
                Set tempContexts;
                BytesRef tempPayload;
                Document doc;
                block15: {
                    IndexableField fieldValue;
                    while (true) {
                        if (this.nextFieldsPosition < this.currentDocFields.length) {
                            IndexableField fieldValue2;
                            if ((fieldValue2 = this.currentDocFields[this.nextFieldsPosition++]).binaryValue() != null) {
                                return fieldValue2.binaryValue();
                            }
                            if (fieldValue2.stringValue() == null) continue;
                            return new BytesRef(fieldValue2.stringValue());
                        }
                        if (this.currentDocId == this.docCount) break block14;
                        ++this.currentDocId;
                        if (this.liveDocs != null && !this.liveDocs.get(this.currentDocId)) continue;
                        doc = DocumentDictionary.this.reader.document(this.currentDocId, this.relevantFields);
                        tempPayload = null;
                        if (this.hasPayloads) {
                            IndexableField payload = doc.getField(DocumentDictionary.this.payloadField);
                            if (payload != null) {
                                if (payload.binaryValue() != null) {
                                    tempPayload = payload.binaryValue();
                                } else if (payload.stringValue() != null) {
                                    tempPayload = new BytesRef(payload.stringValue());
                                }
                            }
                            if (tempPayload == null) {
                                tempPayload = new BytesRef();
                            }
                        }
                        if (this.hasContexts) {
                            IndexableField[] contextFields;
                            tempContexts = new HashSet();
                            for (IndexableField contextField : contextFields = doc.getFields(DocumentDictionary.this.contextsField)) {
                                if (contextField.binaryValue() != null) {
                                    tempContexts.add(contextField.binaryValue());
                                    continue;
                                }
                                if (contextField.stringValue() == null) continue;
                                tempContexts.add(new BytesRef(contextField.stringValue()));
                            }
                        } else {
                            tempContexts = Collections.emptySet();
                        }
                        this.currentDocFields = doc.getFields(DocumentDictionary.this.field);
                        this.nextFieldsPosition = 0;
                        if (this.currentDocFields.length == 0) continue;
                        if ((fieldValue = this.currentDocFields[this.nextFieldsPosition++]).binaryValue() != null) {
                            tempTerm = fieldValue.binaryValue();
                            break block15;
                        }
                        if (fieldValue.stringValue() != null) break;
                    }
                    tempTerm = new BytesRef(fieldValue.stringValue());
                }
                this.currentPayload = tempPayload;
                this.currentContexts = tempContexts;
                this.currentWeight = this.getWeight(doc, this.currentDocId);
                return tempTerm;
            }
            return null;
        }

        @Override
        public BytesRef payload() {
            return this.currentPayload;
        }

        @Override
        public boolean hasPayloads() {
            return this.hasPayloads;
        }

        protected long getWeight(Document doc, int docId) throws IOException {
            IndexableField weight = doc.getField(DocumentDictionary.this.weightField);
            if (weight != null) {
                return weight.numericValue() != null ? weight.numericValue().longValue() : 0L;
            }
            if (this.weightValues != null) {
                return this.weightValues.get(docId);
            }
            return 0L;
        }

        private Set<String> getRelevantFields(String ... fields) {
            HashSet<String> relevantFields = new HashSet<String>();
            for (String relevantField : fields) {
                if (relevantField == null) continue;
                relevantFields.add(relevantField);
            }
            return relevantFields;
        }

        @Override
        public Set<BytesRef> contexts() {
            if (this.hasContexts) {
                return this.currentContexts;
            }
            return null;
        }

        @Override
        public boolean hasContexts() {
            return this.hasContexts;
        }
    }
}

