/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.document;

import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.document.Field;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.document.FieldType;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.document.LatLonPointSortField;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.DocValuesType;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.FieldInfo;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.SortField;

public class LatLonDocValuesField
extends Field {
    public static final FieldType TYPE = new FieldType();

    public LatLonDocValuesField(String name, double latitude, double longitude) {
        super(name, TYPE);
        this.setLocationValue(latitude, longitude);
    }

    public void setLocationValue(double latitude, double longitude) {
        int latitudeEncoded = GeoEncodingUtils.encodeLatitude(latitude);
        int longitudeEncoded = GeoEncodingUtils.encodeLongitude(longitude);
        this.fieldsData = (long)latitudeEncoded << 32 | (long)longitudeEncoded & 0xFFFFFFFFL;
    }

    static void checkCompatible(FieldInfo fieldInfo) {
        if (fieldInfo.getDocValuesType() != DocValuesType.NONE && fieldInfo.getDocValuesType() != TYPE.docValuesType()) {
            throw new IllegalArgumentException("field=\"" + fieldInfo.name + "\" was indexed with docValuesType=" + (Object)((Object)fieldInfo.getDocValuesType()) + " but this type has docValuesType=" + (Object)((Object)TYPE.docValuesType()) + ", is the field really a LatLonDocValuesField?");
        }
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append(" <");
        result.append(this.name);
        result.append(':');
        long currentValue = (Long)this.fieldsData;
        result.append(GeoEncodingUtils.decodeLatitude((int)(currentValue >> 32)));
        result.append(',');
        result.append(GeoEncodingUtils.decodeLongitude((int)(currentValue & 0xFFFFFFFFFFFFFFFFL)));
        result.append('>');
        return result.toString();
    }

    public static SortField newDistanceSort(String field, double latitude, double longitude) {
        return new LatLonPointSortField(field, latitude, longitude);
    }

    static {
        TYPE.setDocValuesType(DocValuesType.SORTED_NUMERIC);
        TYPE.freeze();
    }
}

