/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.TokenFilter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.AttributeSource;

public final class CachingTokenFilter
extends TokenFilter {
    private List<AttributeSource.State> cache = null;
    private Iterator<AttributeSource.State> iterator = null;
    private AttributeSource.State finalState;

    public CachingTokenFilter(TokenStream input) {
        super(input);
    }

    @Override
    public void reset() throws IOException {
        if (this.cache == null) {
            this.input.reset();
        } else {
            this.iterator = this.cache.iterator();
        }
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (this.cache == null) {
            this.cache = new ArrayList<AttributeSource.State>(64);
            this.fillCache();
            this.iterator = this.cache.iterator();
        }
        if (!this.iterator.hasNext()) {
            return false;
        }
        this.restoreState(this.iterator.next());
        return true;
    }

    @Override
    public final void end() {
        if (this.finalState != null) {
            this.restoreState(this.finalState);
        }
    }

    private void fillCache() throws IOException {
        while (this.input.incrementToken()) {
            this.cache.add(this.captureState());
        }
        this.input.end();
        this.finalState = this.captureState();
    }

    public boolean isCached() {
        return this.cache != null;
    }
}

