/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.joptsimple.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.joptsimple.ValueConversionException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.joptsimple.ValueConverter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.joptsimple.internal.Messages;

public class InetAddressConverter
implements ValueConverter<InetAddress> {
    @Override
    public InetAddress convert(String value) {
        try {
            return InetAddress.getByName(value);
        }
        catch (UnknownHostException e) {
            throw new ValueConversionException(this.message(value));
        }
    }

    @Override
    public Class<InetAddress> valueType() {
        return InetAddress.class;
    }

    @Override
    public String valuePattern() {
        return null;
    }

    private String message(String value) {
        return Messages.message(Locale.getDefault(), "org.apache.flink.streaming.connectors.elasticsearch5.shaded.joptsimple.ExceptionMessages", InetAddressConverter.class, "message", value);
    }
}

