/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.github.mustachejava.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.github.mustachejava.Binding;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.github.mustachejava.Code;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.github.mustachejava.MustacheException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.github.mustachejava.ObjectHandler;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.github.mustachejava.TemplateContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.github.mustachejava.reflect.BaseObjectHandler;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.github.mustachejava.util.Wrapper;

public class SimpleObjectHandler
extends BaseObjectHandler {
    private Map<WrapperKey, AccessibleObject> cache = new ConcurrentHashMap<WrapperKey, AccessibleObject>();
    private static AccessibleObject NONE;

    @Override
    public Binding createBinding(final String name, TemplateContext tc, Code code) {
        return new Binding(){
            private Wrapper wrapper;
            {
                this.wrapper = SimpleObjectHandler.this.find(name, null);
            }

            @Override
            public Object get(List<Object> scopes) {
                return this.wrapper.call(scopes);
            }
        };
    }

    @Override
    public Wrapper find(String name, List<Object> scopes) {
        return scopes1 -> {
            for (int i = scopes1.size() - 1; i >= 0; --i) {
                Object scope = scopes1.get(i);
                if (scope == null) continue;
                int index = name.indexOf(".");
                if (index == -1) {
                    if (scope instanceof Map) {
                        Map map = (Map)scope;
                        if (map.containsKey(name)) {
                            return map.get(name);
                        }
                        if (!this.areMethodsAccessible(map)) continue;
                    }
                    try {
                        AccessibleObject ao = this.lookup(scope.getClass(), name);
                        if (ao instanceof Method) {
                            return ((Method)ao).invoke(scope, new Object[0]);
                        }
                        if (!(ao instanceof Field)) continue;
                        return ((Field)ao).get(scope);
                    }
                    catch (InvocationTargetException ie) {
                        throw new MustacheException("Failed to get " + name + " from " + scope.getClass(), ie);
                    }
                    catch (IllegalAccessException iae) {
                        throw new MustacheException("Set accessible failed to get " + name + " from " + scope.getClass(), iae);
                    }
                }
                List<Object> subscope = ObjectHandler.makeList(scope);
                Wrapper wrapper = this.find(name.substring(0, index), subscope);
                if (wrapper == null || (scope = wrapper.call(subscope)) == null) continue;
                subscope = ObjectHandler.makeList(scope);
                return this.find(name.substring(index + 1), ObjectHandler.makeList(subscope)).call(subscope);
            }
            return null;
        };
    }

    private AccessibleObject lookup(Class sClass, String name) {
        WrapperKey key = new WrapperKey(sClass, name);
        AccessibleObject ao = this.cache.get(key);
        if (ao == null) {
            ao = this.findMember(sClass, name);
            this.cache.put(key, ao == null ? NONE : ao);
        }
        return ao == NONE ? null : ao;
    }

    protected boolean areMethodsAccessible(Map<?, ?> map) {
        return false;
    }

    static {
        try {
            NONE = SimpleObjectHandler.class.getDeclaredField("NONE");
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)("Failed to init: " + e));
        }
    }

    private static class WrapperKey {
        private final Class aClass;
        private final String name;
        private final int hashcode;

        WrapperKey(Class aClass, String name) {
            this.aClass = aClass;
            this.name = name;
            this.hashcode = aClass.hashCode() + 43 * name.hashCode();
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof WrapperKey) {
                WrapperKey oKey = (WrapperKey)obj;
                return this.aClass.equals(oKey.aClass) && this.name.equals(oKey.name);
            }
            return false;
        }
    }
}

