/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.util.function.Supplier;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.transport.DelegatingTransportChannel;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseOptions;

public class RequestHandlerRegistry<Request extends TransportRequest> {
    private final String action;
    private final TransportRequestHandler<Request> handler;
    private final boolean forceExecution;
    private final boolean canTripCircuitBreaker;
    private final String executor;
    private final Supplier<Request> requestFactory;
    private final TaskManager taskManager;

    public RequestHandlerRegistry(String action, Supplier<Request> requestFactory, TaskManager taskManager, TransportRequestHandler<Request> handler, String executor, boolean forceExecution, boolean canTripCircuitBreaker) {
        this.action = action;
        this.requestFactory = requestFactory;
        assert (this.newRequest() != null);
        this.handler = handler;
        this.forceExecution = forceExecution;
        this.canTripCircuitBreaker = canTripCircuitBreaker;
        this.executor = executor;
        this.taskManager = taskManager;
    }

    public String getAction() {
        return this.action;
    }

    public Request newRequest() {
        return (Request)((TransportRequest)this.requestFactory.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessageReceived(Request request, TransportChannel channel) throws Exception {
        Task task = this.taskManager.register(channel.getChannelType(), this.action, (TransportRequest)request);
        if (task == null) {
            this.handler.messageReceived(request, channel);
        } else {
            boolean success = false;
            try {
                this.handler.messageReceived(request, new TransportChannelWrapper(this.taskManager, task, channel), task);
                success = true;
            }
            finally {
                if (!success) {
                    this.taskManager.unregister(task);
                }
            }
        }
    }

    public boolean isForceExecution() {
        return this.forceExecution;
    }

    public boolean canTripCircuitBreaker() {
        return this.canTripCircuitBreaker;
    }

    public String getExecutor() {
        return this.executor;
    }

    public String toString() {
        return this.handler.toString();
    }

    private static class TransportChannelWrapper
    extends DelegatingTransportChannel {
        private final Task task;
        private final TaskManager taskManager;

        public TransportChannelWrapper(TaskManager taskManager, Task task, TransportChannel channel) {
            super(channel);
            this.task = task;
            this.taskManager = taskManager;
        }

        @Override
        public void sendResponse(TransportResponse response) throws IOException {
            this.endTask();
            super.sendResponse(response);
        }

        @Override
        public void sendResponse(TransportResponse response, TransportResponseOptions options) throws IOException {
            this.endTask();
            super.sendResponse(response, options);
        }

        @Override
        public void sendResponse(Exception exception) throws IOException {
            this.endTask();
            super.sendResponse(exception);
        }

        private void endTask() {
            this.taskManager.unregister(this.task);
        }
    }
}

