/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.search.suggest.completion.CompletionSuggestion;
import org.elasticsearch.search.suggest.phrase.PhraseSuggestion;
import org.elasticsearch.search.suggest.term.TermSuggestion;

public class Suggest
implements Iterable<Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>>>,
Streamable,
ToXContent {
    private static final String NAME = "suggest";
    public static final Comparator<Suggestion.Entry.Option> COMPARATOR = (first, second) -> {
        int cmp = Float.compare(second.getScore(), first.getScore());
        if (cmp != 0) {
            return cmp;
        }
        return first.getText().compareTo(second.getText());
    };
    private List<Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>>> suggestions;
    private boolean hasScoreDocs;
    private Map<String, Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>>> suggestMap;

    public Suggest() {
        this(Collections.emptyList());
    }

    public Suggest(List<Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>>> suggestions) {
        suggestions.sort((o1, o2) -> o1.getName().compareTo(o2.getName()));
        this.suggestions = suggestions;
        this.hasScoreDocs = this.filter(CompletionSuggestion.class).stream().anyMatch(CompletionSuggestion::hasScoreDocs);
    }

    @Override
    public Iterator<Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>>> iterator() {
        return this.suggestions.iterator();
    }

    public int size() {
        return this.suggestions.size();
    }

    public <T extends Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>>> T getSuggestion(String name) {
        if (this.suggestions.isEmpty() || name == null) {
            return null;
        }
        if (this.suggestions.size() == 1) {
            return (T)(name.equals(this.suggestions.get((int)0).name) ? this.suggestions.get(0) : null);
        }
        if (this.suggestMap == null) {
            this.suggestMap = new HashMap<String, Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>>>();
            for (Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>> item : this.suggestions) {
                this.suggestMap.put(item.getName(), item);
            }
        }
        return (T)this.suggestMap.get(name);
    }

    public boolean hasScoreDocs() {
        return this.hasScoreDocs;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int size = in.readVInt();
        this.suggestions = new ArrayList<Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>>>(size);
        for (int i = 0; i < size; ++i) {
            Suggestion suggestion;
            int type = in.readVInt();
            switch (type) {
                case 1: {
                    suggestion = new TermSuggestion();
                    break;
                }
                case 4: {
                    suggestion = new CompletionSuggestion();
                    break;
                }
                case 2: {
                    suggestion = new org.elasticsearch.search.suggest.completion2x.CompletionSuggestion();
                    break;
                }
                case 3: {
                    suggestion = new PhraseSuggestion();
                    break;
                }
                default: {
                    suggestion = new Suggestion();
                }
            }
            suggestion.readFrom(in);
            this.suggestions.add(suggestion);
        }
        this.hasScoreDocs = this.filter(CompletionSuggestion.class).stream().anyMatch(CompletionSuggestion::hasScoreDocs);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.suggestions.size());
        for (Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>> command : this.suggestions) {
            out.writeVInt(command.getType());
            command.writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        this.toInnerXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public XContentBuilder toInnerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>> suggestion : this.suggestions) {
            suggestion.toXContent(builder, params);
        }
        return builder;
    }

    public static Suggest readSuggest(StreamInput in) throws IOException {
        Suggest result = new Suggest();
        result.readFrom(in);
        return result;
    }

    public static List<Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>>> reduce(Map<String, List<Suggestion>> groupedSuggestions) {
        ArrayList<Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>>> reduced = new ArrayList<Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>>>(groupedSuggestions.size());
        for (Map.Entry<String, List<Suggestion>> unmergedResults : groupedSuggestions.entrySet()) {
            List value = unmergedResults.getValue();
            Class<?> suggestionClass = null;
            for (Suggestion suggestion : value) {
                if (suggestionClass == null) {
                    suggestionClass = suggestion.getClass();
                    continue;
                }
                if (suggestionClass == suggestion.getClass()) continue;
                throw new IllegalArgumentException("detected mixed suggestion results, due to querying on old and new completion suggester, query on a single completion suggester version");
            }
            Suggestion reduce = value.get(0).reduce(value);
            reduce.trim();
            reduced.add(reduce);
        }
        return reduced;
    }

    public <T extends Suggestion> List<T> filter(Class<T> suggestionType) {
        return this.suggestions.stream().filter((? super T suggestion) -> suggestion.getClass() == suggestionType).map(suggestion -> suggestion).collect(Collectors.toList());
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
            builder.startObject();
            this.toXContent(builder, EMPTY_PARAMS);
            builder.endObject();
            return builder.string();
        }
        catch (IOException e) {
            return "{ \"error\" : \"" + e.getMessage() + "\"}";
        }
    }

    public static class Suggestion<T extends Entry>
    implements Iterable<T>,
    Streamable,
    ToXContent {
        public static final int TYPE = 0;
        protected String name;
        protected int size;
        protected final List<T> entries = new ArrayList<T>(5);

        public Suggestion() {
        }

        public Suggestion(String name, int size) {
            this.name = name;
            this.size = size;
        }

        public void addTerm(T entry) {
            this.entries.add(entry);
        }

        public int getType() {
            return 0;
        }

        @Override
        public Iterator<T> iterator() {
            return this.entries.iterator();
        }

        public List<T> getEntries() {
            return this.entries;
        }

        public String getName() {
            return this.name;
        }

        public int getSize() {
            return this.size;
        }

        public Suggestion<T> reduce(List<Suggestion<T>> toReduce) {
            if (toReduce.size() == 1) {
                return toReduce.get(0);
            }
            if (toReduce.isEmpty()) {
                return null;
            }
            Suggestion<T> leader = toReduce.get(0);
            List<T> entries = leader.entries;
            int size = entries.size();
            Comparator<Entry.Option> sortComparator = this.sortComparator();
            ArrayList<T> currentEntries = new ArrayList<T>();
            for (int i = 0; i < size; ++i) {
                for (Suggestion<T> suggestion : toReduce) {
                    if (suggestion.entries.size() != size) {
                        throw new IllegalStateException("Can't merge suggest result, this might be caused by suggest calls across multiple indices with different analysis chains. Suggest entries have different sizes actual [" + suggestion.entries.size() + "] expected [" + size + "]");
                    }
                    assert (suggestion.name.equals(leader.name));
                    currentEntries.add(suggestion.entries.get(i));
                }
                Entry<Entry.Option> entry = ((Entry)entries.get(i)).reduce(currentEntries);
                entry.sort(sortComparator);
                entries.set(i, entry);
                currentEntries.clear();
            }
            return leader;
        }

        protected Comparator<Entry.Option> sortComparator() {
            return COMPARATOR;
        }

        public void trim() {
            for (Entry entry : this.entries) {
                entry.trim(this.size);
            }
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.innerReadFrom(in);
            int size = in.readVInt();
            this.entries.clear();
            for (int i = 0; i < size; ++i) {
                T newEntry = this.newEntry();
                ((Entry)newEntry).readFrom(in);
                this.entries.add(newEntry);
            }
        }

        protected T newEntry() {
            return (T)new Entry();
        }

        protected void innerReadFrom(StreamInput in) throws IOException {
            this.name = in.readString();
            this.size = in.readVInt();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.innerWriteTo(out);
            out.writeVInt(this.entries.size());
            for (Entry entry : this.entries) {
                entry.writeTo(out);
            }
        }

        public void innerWriteTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            out.writeVInt(this.size);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startArray(this.name);
            for (Entry entry : this.entries) {
                entry.toXContent(builder, params);
            }
            builder.endArray();
            return builder;
        }

        public static class Entry<O extends Option>
        implements Iterable<O>,
        Streamable,
        ToXContent {
            protected Text text;
            protected int offset;
            protected int length;
            protected List<O> options;

            public Entry(Text text, int offset, int length) {
                this.text = text;
                this.offset = offset;
                this.length = length;
                this.options = new ArrayList<O>(5);
            }

            public Entry() {
            }

            public void addOption(O option) {
                this.options.add(option);
            }

            protected void sort(Comparator<O> comparator) {
                CollectionUtil.timSort(this.options, comparator);
            }

            protected <T extends Entry<O>> Entry<O> reduce(List<T> toReduce) {
                if (toReduce.size() == 1) {
                    return (Entry)toReduce.get(0);
                }
                HashMap<Option, Option> entries = new HashMap<Option, Option>();
                Entry leader = (Entry)toReduce.get(0);
                for (Entry entry : toReduce) {
                    if (!leader.text.equals(entry.text)) {
                        throw new IllegalStateException("Can't merge suggest entries, this might be caused by suggest calls across multiple indices with different analysis chains. Suggest entries have different text actual [" + entry.text + "] expected [" + leader.text + "]");
                    }
                    assert (leader.offset == entry.offset);
                    assert (leader.length == entry.length);
                    leader.merge(entry);
                    for (Option option : entry) {
                        Option merger = (Option)entries.get(option);
                        if (merger == null) {
                            entries.put(option, option);
                            continue;
                        }
                        merger.mergeInto(option);
                    }
                }
                leader.options.clear();
                for (Option option : entries.keySet()) {
                    leader.addOption(option);
                }
                return leader;
            }

            protected void merge(Entry<O> other) {
            }

            public Text getText() {
                return this.text;
            }

            public int getOffset() {
                return this.offset;
            }

            public int getLength() {
                return this.length;
            }

            @Override
            public Iterator<O> iterator() {
                return this.options.iterator();
            }

            public List<O> getOptions() {
                return this.options;
            }

            void trim(int size) {
                int optionsToRemove = Math.max(0, this.options.size() - size);
                for (int i = 0; i < optionsToRemove; ++i) {
                    this.options.remove(this.options.size() - 1);
                }
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Entry entry = (Entry)o;
                if (this.length != entry.length) {
                    return false;
                }
                if (this.offset != entry.offset) {
                    return false;
                }
                return this.text.equals(entry.text);
            }

            public int hashCode() {
                int result = this.text.hashCode();
                result = 31 * result + this.offset;
                result = 31 * result + this.length;
                return result;
            }

            @Override
            public void readFrom(StreamInput in) throws IOException {
                this.text = in.readText();
                this.offset = in.readVInt();
                this.length = in.readVInt();
                int suggestedWords = in.readVInt();
                this.options = new ArrayList<O>(suggestedWords);
                for (int j = 0; j < suggestedWords; ++j) {
                    O newOption = this.newOption();
                    ((Option)newOption).readFrom(in);
                    this.options.add(newOption);
                }
            }

            protected O newOption() {
                return (O)new Option();
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeText(this.text);
                out.writeVInt(this.offset);
                out.writeVInt(this.length);
                out.writeVInt(this.options.size());
                for (Option option : this.options) {
                    option.writeTo(out);
                }
            }

            @Override
            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                builder.field("text", this.text);
                builder.field("offset", this.offset);
                builder.field("length", this.length);
                builder.startArray("options");
                for (Option option : this.options) {
                    option.toXContent(builder, params);
                }
                builder.endArray();
                builder.endObject();
                return builder;
            }

            public static class Option
            implements Streamable,
            ToXContent {
                private Text text;
                private Text highlighted;
                private float score;
                private Boolean collateMatch;

                public Option(Text text, Text highlighted, float score, Boolean collateMatch) {
                    this.text = text;
                    this.highlighted = highlighted;
                    this.score = score;
                    this.collateMatch = collateMatch;
                }

                public Option(Text text, Text highlighted, float score) {
                    this(text, highlighted, score, null);
                }

                public Option(Text text, float score) {
                    this(text, null, score);
                }

                public Option() {
                }

                public Text getText() {
                    return this.text;
                }

                public Text getHighlighted() {
                    return this.highlighted;
                }

                public float getScore() {
                    return this.score;
                }

                public boolean collateMatch() {
                    return this.collateMatch != null ? this.collateMatch : true;
                }

                protected void setScore(float score) {
                    this.score = score;
                }

                @Override
                public void readFrom(StreamInput in) throws IOException {
                    this.text = in.readText();
                    this.score = in.readFloat();
                    this.highlighted = in.readOptionalText();
                    this.collateMatch = in.readOptionalBoolean();
                }

                @Override
                public void writeTo(StreamOutput out) throws IOException {
                    out.writeText(this.text);
                    out.writeFloat(this.score);
                    out.writeOptionalText(this.highlighted);
                    out.writeOptionalBoolean(this.collateMatch);
                }

                @Override
                public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                    builder.startObject();
                    this.innerToXContent(builder, params);
                    builder.endObject();
                    return builder;
                }

                protected XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                    builder.field("text", this.text);
                    if (this.highlighted != null) {
                        builder.field("highlighted", this.highlighted);
                    }
                    builder.field("score", this.score);
                    if (this.collateMatch != null) {
                        builder.field("collate_match", (boolean)this.collateMatch);
                    }
                    return builder;
                }

                protected void mergeInto(Option otherOption) {
                    this.score = Math.max(this.score, otherOption.score);
                }

                public boolean equals(Object o) {
                    if (this == o) {
                        return true;
                    }
                    if (o == null || this.getClass() != o.getClass()) {
                        return false;
                    }
                    Option that = (Option)o;
                    return this.text.equals(that.text);
                }

                public int hashCode() {
                    return this.text.hashCode();
                }

                static class Fields {
                    static final String TEXT = "text";
                    static final String HIGHLIGHTED = "highlighted";
                    static final String SCORE = "score";
                    static final String COLLATE_MATCH = "collate_match";

                    Fields() {
                    }
                }
            }

            static class Fields {
                static final String TEXT = "text";
                static final String OFFSET = "offset";
                static final String LENGTH = "length";
                static final String OPTIONS = "options";

                Fields() {
                }
            }
        }
    }
}

