/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.sort;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public enum SortMode implements Writeable
{
    MIN,
    MAX,
    SUM,
    AVG,
    MEDIAN;


    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.ordinal());
    }

    public static SortMode readFromStream(StreamInput in) throws IOException {
        int ordinal = in.readVInt();
        if (ordinal < 0 || ordinal >= SortMode.values().length) {
            throw new IOException("Unknown SortMode ordinal [" + ordinal + "]");
        }
        return SortMode.values()[ordinal];
    }

    public static SortMode fromString(String str) {
        Objects.requireNonNull(str, "input string is null");
        switch (str.toLowerCase(Locale.ROOT)) {
            case "min": {
                return MIN;
            }
            case "max": {
                return MAX;
            }
            case "sum": {
                return SUM;
            }
            case "avg": {
                return AVG;
            }
            case "median": {
                return MEDIAN;
            }
        }
        throw new IllegalArgumentException("Unknown SortMode [" + str + "]");
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

