/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile.aggregation;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Scorer;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.profile.aggregation.AggregationProfileBreakdown;
import org.elasticsearch.search.profile.aggregation.AggregationTimingType;

public class ProfilingLeafBucketCollector
extends LeafBucketCollector {
    private LeafBucketCollector delegate;
    private AggregationProfileBreakdown profileBreakdown;

    public ProfilingLeafBucketCollector(LeafBucketCollector delegate, AggregationProfileBreakdown profileBreakdown) {
        this.delegate = delegate;
        this.profileBreakdown = profileBreakdown;
    }

    @Override
    public void collect(int doc, long bucket) throws IOException {
        this.profileBreakdown.startTime(AggregationTimingType.COLLECT);
        this.delegate.collect(doc, bucket);
        this.profileBreakdown.stopAndRecordTime();
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        this.delegate.setScorer(scorer);
    }
}

