/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase.highlight;

import java.io.IOException;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexOptions;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.highlight.Encoder;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.postingshighlight.CustomPassageFormatter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.postingshighlight.CustomPostingsHighlighter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.postingshighlight.CustomSeparatorBreakIterator;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.postingshighlight.Snippet;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.search.fetch.FetchPhaseExecutionException;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightUtils;
import org.elasticsearch.search.fetch.subphase.highlight.Highlighter;
import org.elasticsearch.search.fetch.subphase.highlight.HighlighterContext;
import org.elasticsearch.search.fetch.subphase.highlight.SearchContextHighlight;
import org.elasticsearch.search.internal.SearchContext;

public class PostingsHighlighter
implements Highlighter {
    private static final String CACHE_KEY = "highlight-postings";

    @Override
    public HighlightField highlight(HighlighterContext highlighterContext) {
        FieldMapper fieldMapper = highlighterContext.mapper;
        SearchContextHighlight.Field field = highlighterContext.field;
        if (!this.canHighlight(fieldMapper)) {
            throw new IllegalArgumentException("the field [" + highlighterContext.fieldName + "] should be indexed with positions and offsets in the postings list to be used with postings highlighter");
        }
        SearchContext context = highlighterContext.context;
        FetchSubPhase.HitContext hitContext = highlighterContext.hitContext;
        if (!hitContext.cache().containsKey(CACHE_KEY)) {
            hitContext.cache().put(CACHE_KEY, new HighlighterEntry());
        }
        HighlighterEntry highlighterEntry = (HighlighterEntry)hitContext.cache().get(CACHE_KEY);
        MapperHighlighterEntry mapperHighlighterEntry = highlighterEntry.mappers.get(fieldMapper);
        if (mapperHighlighterEntry == null) {
            Encoder encoder = field.fieldOptions().encoder().equals("html") ? HighlightUtils.Encoders.HTML : HighlightUtils.Encoders.DEFAULT;
            CustomPassageFormatter passageFormatter = new CustomPassageFormatter(field.fieldOptions().preTags()[0], field.fieldOptions().postTags()[0], encoder);
            mapperHighlighterEntry = new MapperHighlighterEntry(passageFormatter);
        }
        List<Snippet> snippets = new ArrayList<Snippet>();
        try {
            Snippet[] fieldSnippets;
            int numberOfFragments;
            CustomPostingsHighlighter highlighter;
            String fieldValue;
            Analyzer analyzer = context.mapperService().documentMapper(hitContext.hit().type()).mappers().indexAnalyzer();
            List<Object> fieldValues = HighlightUtils.loadFieldValues(field, fieldMapper, context, hitContext);
            if (field.fieldOptions().numberOfFragments() == 0) {
                fieldValue = PostingsHighlighter.mergeFieldValues(fieldValues, '\u0000');
                CustomSeparatorBreakIterator breakIterator = new CustomSeparatorBreakIterator('\u0000');
                highlighter = new CustomPostingsHighlighter(analyzer, mapperHighlighterEntry.passageFormatter, breakIterator, fieldValue, field.fieldOptions().noMatchSize() > 0);
                numberOfFragments = fieldValues.size();
            } else {
                fieldValue = PostingsHighlighter.mergeFieldValues(fieldValues, '\u2029');
                highlighter = new CustomPostingsHighlighter(analyzer, mapperHighlighterEntry.passageFormatter, fieldValue, field.fieldOptions().noMatchSize() > 0);
                numberOfFragments = field.fieldOptions().numberOfFragments();
            }
            IndexSearcher searcher = new IndexSearcher(hitContext.reader());
            for (Snippet fieldSnippet : fieldSnippets = highlighter.highlightField(fieldMapper.fieldType().name(), highlighterContext.query, searcher, hitContext.docId(), numberOfFragments)) {
                if (!Strings.hasText(fieldSnippet.getText())) continue;
                snippets.add(fieldSnippet);
            }
        }
        catch (IOException e) {
            throw new FetchPhaseExecutionException(context, "Failed to highlight field [" + highlighterContext.fieldName + "]", (Throwable)e);
        }
        snippets = PostingsHighlighter.filterSnippets(snippets, field.fieldOptions().numberOfFragments());
        if (field.fieldOptions().scoreOrdered().booleanValue()) {
            CollectionUtil.introSort(snippets, new Comparator<Snippet>(){

                @Override
                public int compare(Snippet o1, Snippet o2) {
                    return (int)Math.signum(o2.getScore() - o1.getScore());
                }
            });
        }
        String[] fragments = new String[snippets.size()];
        for (int i = 0; i < fragments.length; ++i) {
            fragments[i] = snippets.get(i).getText();
        }
        if (fragments.length > 0) {
            return new HighlightField(highlighterContext.fieldName, Text.convertFromStringArray(fragments));
        }
        return null;
    }

    @Override
    public boolean canHighlight(FieldMapper fieldMapper) {
        return fieldMapper.fieldType().indexOptions() == IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS;
    }

    private static String mergeFieldValues(List<Object> fieldValues, char valuesSeparator) {
        String rawValue = Strings.collectionToDelimitedString(fieldValues, String.valueOf(valuesSeparator));
        return rawValue.substring(0, Math.min(rawValue.length(), 0x7FFFFFFE));
    }

    private static List<Snippet> filterSnippets(List<Snippet> snippets, int numberOfFragments) {
        ArrayList<Snippet> filteredSnippets = new ArrayList<Snippet>(snippets.size());
        for (Snippet snippet : snippets) {
            if (!snippet.isHighlighted()) continue;
            filteredSnippets.add(snippet);
        }
        if (filteredSnippets.size() == 0 && snippets.size() > 0) {
            Snippet snippet = snippets.get(0);
            if (numberOfFragments == 0) {
                BreakIterator bi = BreakIterator.getSentenceInstance(Locale.ROOT);
                String text = snippet.getText();
                bi.setText(text);
                int next = bi.next();
                if (next != -1) {
                    String newText = text.substring(0, next).trim();
                    snippet = new Snippet(newText, snippet.getScore(), snippet.isHighlighted());
                }
            }
            filteredSnippets.add(snippet);
        }
        return filteredSnippets;
    }

    private static class MapperHighlighterEntry {
        final CustomPassageFormatter passageFormatter;

        private MapperHighlighterEntry(CustomPassageFormatter passageFormatter) {
            this.passageFormatter = passageFormatter;
        }
    }

    private static class HighlighterEntry {
        Map<FieldMapper, MapperHighlighterEntry> mappers = new HashMap<FieldMapper, MapperHighlighterEntry>();

        private HighlighterEntry() {
        }
    }
}

